        .Z80
        ;
        ASEG
        ;
        ORG      0100H
        ;
        OFFSET   EQU   0DA00H
        ZEI0     EQU   OFFSET
        ;
;Grafik-Prozeduren f}r Bondwell 2
;
;    (C) 1986 GEORG GERDES
;      H. HEINE STR. 11A
;         3550 MARBURG
;
          .PHASE OFFSET
          ;
ZEI0:     DEFB 128
ZEI1:     DEFB 64
ZEI2:     DEFB 32
ZEI3:     DEFB 16
ZEI4:     DEFB 8
ZEI5:     DEFB 4
ZEI6:     DEFB 2
ZEI7:     DEFB 1
SP1:      DEFB 0
ROUT:     DEFB 0
INK:      DEFB 0
ZEI:      DEFB 0
SPADR:    DEFB 0,0
XB:       DEFB 0
XY:       DEFB 0
X1:       DEFB 0,0
Y1:       DEFB 0,0
X2:       DEFB 0,0
Y2:       DEFB 0,0
XSTEP:    DEFB 0,0
YSTEP:    DEFB 0,0
XDIFF:    DEFB 0,0
YDIFF:    DEFB 0,0
SUM:      DEFB 0,0
DMAX:     DEFB 0,0
;
;
GETROU: LD       A,(ROUT)
        CP       1
        JP       Z,SET
        CP       2
        JP       Z,DRAW
        CP       3
        JP       Z,INV
        CP       4
        JP       Z,PRINT
        CP       5
        JP       Z,FILL
        CP       6
        JP       Z,SQUARE
        CP       7
        JP       Z,KREIS
        CP       8
        JP       Z,GETBYT
        CP       9
        JP       Z,MOVSCR
;
FINIS:  CALL     GRAOFF
        RET
                ;
PLOT:   CALL     GETADR
        LD       A,(INK)
        BIT      0,A
        JR       Z,PLOT0
PLOT1:  LD       HL,OFFSET
        LD       A,(ZEI)
        OR       L
        LD       L,A
        LD       A,(HL)
        LD       HL,(SPADR)
        LD       C,(HL)
        OR       C
        LD       (HL),A
        RET
PLOT0:  LD       HL,OFFSET
        LD       A,(ZEI)
        OR       L
        LD       L,A
        LD       A,(HL)
        XOR      0FFH
        LD       HL,(SPADR)
        LD       C,(HL)
        AND      C
        LD       (HL),A
        RET
        ;
        ;
GETADR: LD       HL,(X1)
        LD       A,L
        AND      00000111B
        LD       (ZEI),A
        SRL      H
        RR       L
        SRL      H
        RR       L
        SRL      H
        RR       L
        EX       DE,HL
        LD       HL,(Y1)
        LD       B,H
        LD       C,L
        ADD      HL,HL       ; *2
        ADD      HL,HL       ; *4
        ADD      HL,BC       ; *5
        ADD      HL,HL       ; *10
        ADD      HL,HL       ; *20
        ADD      HL,HL       ; *40
        ADD      HL,HL       ; *80
        ADD      HL,DE
        LD       (SPADR),HL
        RET
        ;
        ;
SET:    CALL     GRAON
        CALL     PLOT
        JP       FINIS
        ;
        ;
DRAW:   CALL     GRAON
        CALL     DRAW1
        JP       FINIS
        ;
        ;
KREIS:  CALL     GRAON
        CALL     SIN0
        JP       FINIS
        ;
        ;
DRAW1:  LD       DE,(X1)
        LD       HL,(X2)
        CALL     BETRAG
        LD       (XDIFF),HL
        LD       (XSTEP),BC
        LD       A,H
        OR       L
        LD       DE,(Y1)
        LD       HL,(Y2)
        CALL     BETRAG
        LD       (YDIFF),HL
        LD       (YSTEP),BC
        OR       H
        OR       L
        RET      Z
        ;
DRAW2:  XOR      A
        LD       HL,(XDIFF)
        LD       BC,-1
        OR       H
        OR       L
        JR       Z,XD0
        LD       BC,0
XD0:    LD       (SUM),BC
        ;
DRAW5:  CALL     PLOT
        OR       A
        LD       HL,(X1)
        LD       BC,(X2)
        SBC      HL,BC
        JR       NZ,DRAW6
        LD       HL,(Y1)
        LD       BC,(Y2)
        SBC      HL,BC
        RET      Z
        ;
DRAW6:  LD       HL,(SUM)
        BIT      7,H
        JR       Z,DRAW7
        LD       BC,(XDIFF)
        ADD      HL,BC
        LD       (SUM),HL
        LD       HL,(Y1)
        LD       BC,(YSTEP)
        ADD      HL,BC
        LD       (Y1),HL
        JR       DRAW5
        ;
DRAW7:  LD       BC,(YDIFF)
        OR       A
        SBC      HL,BC
        LD       (SUM),HL
        LD       HL,(X1)
        LD       BC,(XSTEP)
        ADD      HL,BC
        LD       (X1),HL
        JR       DRAW5
        ;
        ;
INV:    CALL     GRAON
        LD       HL,0000
        LD       C,03FH
LOOP0:  LD       B,0FFH
LOOP1:  LD       A,(HL)
        XOR      0FFH
        LD       (HL),A
        INC      HL
        DJNZ     LOOP1
        DEC      C
        JR       NZ,LOOP0
        JP       FINIS
        RET
        ;
        ;
BETRAG: OR       A
        LD       BC,1
        SBC      HL,DE
        RET      P
        ADD      HL,DE
        EX       DE,HL
        OR       A
        SBC      HL,DE
        LD       BC,-1
        RET
;
;
XALT:   DEFB 0,0
YALT:   DEFB 0,0
STRADR: DEFB 0,0
MAXLEF: DEFB 0
MAXRIG: DEFB 0
MUSTRT: DEFB 0,0
MUSEND: DEFB 0,0
ENDFLG: DEFB 0
SETPKT: DEFB 0,0
PATCNT: DEFB 170
LEFADR: DEFB 0,0
RIGADR: DEFB 0,0
MUST1:  DEFB 255,255,255,255
        DEFB 255,255,255,255
MUST2:  DEFB  60,102,195,129
        DEFB 129,195,102, 60
MUST3:  DEFB  24, 36, 66,129
 	DEFB  24, 36, 66,129
MUST4:  DEFB 204, 51,204, 51
	DEFB 204, 51,204, 51
MUST5:  DEFB 240,144,144,240
	DEFB  15,  9,  9, 15
MUST6:  DEFB  20, 34, 65,128
	DEFB   1,130, 68, 40
MUST7:  DEFB  17, 34, 68,136
	DEFB 136, 68, 34, 17
MUST8:  DEFB 119,136,136,136
	DEFB 119,136,136,136
TABEND: DEFB 255
;
;
FILL:   LD       HL,X1
        LD       DE,XALT
        LD       BC,4
        LDIR
        LD       HL,X1
        LD       DE,XDIFF
        LD       BC,4
        LDIR
        LD       DE,0000H
        LD       IY,MUST1
        LD       A,(SP1)
        RLA
        RLA
        RLA
        LD       E,A
        ADD      IY,DE
        LD       (MUSTRT),IY
        CALL     GRAON
FILL0:  CALL     GETADR
        LD       HL,(SPADR)
        LD       BC,OFFSET
        LD       A,(ZEI)
        OR       C
        LD       C,A
        LD       A,(BC)
        AND      (HL)
        CP       0
        JP       NZ,FINIS
UP:     LD       DE,(Y1)
        LD       A,E
        AND      7
        LD       E,A
        XOR      A
        LD       D,A
        LD       IY,(MUSTRT)
        ADD      IY,DE
        CALL     GOLINE
        LD       HL,(LEFADR)
        EX       DE,HL
        SBC      HL,DE
        JP       Z,DOWN
        LD       DE,(LEFADR)
        XOR      A
        SRL      H
        RR       L
        ADD      HL,DE
        LD       (XALT),HL
        LD       HL,(Y1)
        DEC      HL
        LD       (Y1),HL
        JR       UP
        JP       FINIS
        ;
        ;
DOWN:   LD       HL,(YALT)
        INC      HL
        LD       (Y1),HL
        LD       HL,(XDIFF)
        LD       (XALT),HL
DOWN1:  LD       DE,(Y1)
        LD       A,E
        AND      7
        LD       E,A
        XOR      A
        LD       D,A
        LD       IY,(MUSTRT)
        ADD      IY,DE
        CALL     GOLINE
        LD       HL,(LEFADR)
        EX       DE,HL
        SBC      HL,DE
        JP       Z,FINIS
        LD       DE,(LEFADR)
        XOR      A
        SRL      H
        RR       L
        ADD      HL,DE
        LD       (XALT),HL
        LD       HL,(Y1)
        INC      HL
        LD       (Y1),HL
        JR       DOWN1
        JP       FINIS
        ;
        ;
GOLINE: LD       HL,(XALT)
        LD       (X1),HL
        CALL     GETADR
        LD       BC,OFFSET
        LD       A,(ZEI)
        OR       C
        LD       C,A
        LD       A,(BC)
        LD       (SP1),A
        LD       C,A
        LD       DE,(XALT)
        LD       HL,(SPADR)
        JR       LE2
LE1:    LD       C,1
LE2:    LD       A,C
        OR       A
        AND      (HL)
        CP       0
        JR       NZ,GORIGHT
        CALL     PP
        DEC      DE
        XOR      A
        RLC      C
        JR       NC,LE2
        DEC      HL
        JR       LE1
        ;
        ;
GORIGHT:LD       (LEFADR),DE
        LD       HL,(SPADR)
        LD       DE,(XALT)
        LD       A,(SP1)
        OR       A
        RRCA
        JR       C,RIG3
        LD       C,A
        JR       RIG2
RIG1:   LD       C,128
RIG2:   LD       A,C
        OR       A
        AND      (HL)
        CP       0
        RET      NZ
        CALL     PP
        INC      DE
        XOR      A
        RRC      C
        JR       NC,RIG2
RIG3:   INC      HL
        JR       RIG1
        ;
        ;
PP:     LD       A,(IY)
        AND      C
        OR       (HL)
        LD       (HL),A
        RET
        ;
        ;
GRAON:  LD       A,0C1H
        OUT      (02),A
        LD       A,0
        LD       C,21H
        LD       B,5
        OUT      (C),B
        OUT      (20H),A
        INC      B
        OUT      (C),B
        OUT      (20H),A
        RET
        ;
        ;
GRAOFF: LD       C,02
        LD       A,0C0H
        OUT      (C),A
        LD       C,21H
        LD       A,0
        LD       B,5
        OUT      (C),B
        OUT      (20H),A
        INC      B
        OUT      (C),B
        OUT      (20H),A
        RET
        ;
        ;

PRINT:  CALL     RESETP
        CALL     CRLF
        CALL     PRTINI
        CALL     GRPINI
        LD       HL,0000H
        LD       B,25
        LD       C,81
        LD       (SPADR),HL
        LD       (COUNT),BC
LOOP3:  JP       LOOPC
LOOP4:  CALL     LPRSP1
        CALL     ROLL
        CALL     OUTSP
        JR       LOOP3
        ;
        ;
LPRSP1: LD       HL,(SPADR)
        INC      HL
        LD       (SPADR),HL
        DEC      HL
        CALL     GRAON
        LD       BC,80
        LD       DE,PRSP1
        LD       A,8
LOOP2:  LD       (ZEI),A
        LD       A,(HL)
        EX       DE,HL
        LD       (HL),A
        EX       DE,HL
INV1:   XOR      0FFH
INV2:   LD       (HL),A
        INC      DE
        ADD      HL,BC
        LD       A,(ZEI)
        DEC      A
        JR       NZ,LOOP2
        CALL     GRAOFF
        RET
        ;
        ;
LOOPC:  LD       BC,(COUNT)
        LD       HL,(SPADR)
        OR       A
        LD       A,B
        CP       0
        JP       Z,RESETP
        OR       A
        DEC      C
        JR       NZ,NOT0
        XOR      A
        DEC      B
        LD       C,80
        LD       DE,560
        ADD      HL,DE
        LD       (COUNT),BC
        LD       (SPADR),HL
        CALL     CRLF
        LD       BC,(COUNT)
        LD       A,B
        CP       0
        CALL     NZ,GRPINI
NOTB:   JP       LOOP4
NOT0:   LD       (COUNT),BC
        LD       (SPADR),HL
        JP       LOOP4
        ;
        ;
ROLL:   LD       DE,PRSP2
        LD       B,8
LOOPA:  LD       HL,PRSP1
        LD       C,8
        XOR      A
LOOPI:  OR       A
        BIT      7,(HL)
        JR       Z,NULL
        SET      0,A
NULL:   RLC      (HL)
        RLCA
        INC      HL
        DEC      C
        JR       NZ,LOOPI
        EX       DE,HL
        RRCA
        LD       (HL),A
        INC      HL
        EX       DE,HL
        DEC      B
        JR       NZ,LOOPA
        RET
        ;
        ;
OUTSP:  LD       HL,PRSP2
        LD       A,8
LOOP5:  LD       E,(HL)
        LD       (ZEI),A
        PUSH     HL
        CALL     PRT
        POP      HL
        LD       A,(ZEI)
        INC      HL
        DEC      A
        JR       NZ,LOOP5
        RET
        ;
        ;
PRTINI: LD       E,27
        CALL     PRT
        LD       E,65
        CALL     PRT
        LD       E,8
        CALL     PRT
        RET
        ;
        ;
RESETP: LD       E,27
        CALL     PRT
        LD       E,64
        CALL     PRT
        LD       E,7
        CALL     PRT
        RET
        ;
        ;
GRPINI: LD       E,27
        CALL     PRT
        LD       E,'*'
        CALL     PRT
        LD       E,4
        CALL     PRT
        LD       E,128
        CALL     PRT
        LD       E,2
        CALL     PRT
        RET
        ;
        ;
CRLF:   LD       E,10
        CALL     PRT
        LD       E,13
        CALL     PRT
        RET
        ;
        ;
PRT:    ;RET
        LD       C,5
        CALL     0005H
        RET
        ;
        ;
COUNT:  DEFS     2
PRSP1:  DEFS     8
PRSP2:  DEFS     8
        ;
        ;
X3:     DEFB 0,0
Y3:     DEFB 0,0
X4:     DEFB 0,0
Y4:     DEFB 0,0
;
SQUARE: LD       HL,X1
        LD       DE,X3
        LD       BC,8
        LDIR
        CALL     GRAON
        LD       HL,(X3)
        LD       (X1),HL
        LD       HL,(X4)
        LD       (X2),HL
        LD       HL,(Y3)
        LD       (Y1),HL
        LD       (Y2),HL
        CALL     DRAW1
        LD       HL,(X4)
        LD       (X1),HL
        LD       HL,(Y4)
        LD       (Y2),HL
        CALL     DRAW1
        LD       HL,(X3)
        LD       (X2),HL
        LD       HL,(Y4)
        LD       (Y1),HL
        CALL     DRAW1
        LD       HL,(X3)
        LD       (X1),HL
        LD       HL,(Y3)
        LD       (Y2),HL
        CALL     DRAW1
        JP       FINIS
        RET
        ;
        ;
SINTAB:

DEFB   0
DEFB   1,   3,   4,   6
DEFB   7,   9,  10,  12
DEFB  14,  15,  17,  18
DEFB  20,  21,  23,  25
DEFB  26,  28,  29,  31
DEFB  32,  34,  35,  37
DEFB  39,  40,  42,  43
DEFB  45,  46,  48,  49
DEFB  51,  52,  54,  56
DEFB  57,  59,  60,  62
DEFB  63,  65,  66,  68
DEFB  69,  71,  72,  74
DEFB  75,  77,  78,  80
DEFB  81,  83,  84,  86
DEFB  87,  89,  90,  92
DEFB  93,  95,  96,  97
DEFB  99, 100, 102, 103
DEFB 105, 106, 107, 109
DEFB 110, 112, 113, 115
DEFB 116, 117, 119, 120
DEFB 122, 123, 124, 126
DEFB 127, 128, 130, 131
DEFB 132, 134, 135, 136
DEFB 138, 139, 140, 142
DEFB 143, 144, 146, 147
DEFB 148, 149, 151, 152
DEFB 153, 154, 156, 157
DEFB 158, 159, 161, 162
DEFB 163, 164, 165, 167
DEFB 168, 169, 170, 171
DEFB 173, 174, 175, 176
DEFB 177, 178, 179, 180
DEFB 182, 183, 184, 185
DEFB 186, 187, 188, 189
DEFB 190, 191, 192, 193
DEFB 194, 195, 196, 197
DEFB 198, 199, 200, 201
DEFB 202, 203, 204, 205
DEFB 206, 207, 208, 209
DEFB 210, 211, 211, 212
DEFB 213, 214, 215, 216
DEFB 217, 217, 218, 219
DEFB 220, 221, 221, 222
DEFB 223, 224, 224, 225
DEFB 226, 227, 227, 228
DEFB 229, 229, 230, 231
DEFB 232, 232, 233, 233
DEFB 234, 235, 235, 236
DEFB 237, 237, 238, 238
DEFB 239, 239, 240, 240
DEFB 241, 242, 242, 243
DEFB 243, 243, 244, 244
DEFB 245, 245, 246, 246
DEFB 247, 247, 247, 248
DEFB 248, 249, 249, 249
DEFB 250, 250, 250, 251
DEFB 251, 251, 251, 252
DEFB 252, 252, 252, 253
DEFB 253, 253, 253, 254
DEFB 254, 254, 254, 254
DEFB 254, 255, 255, 255
DEFB 255, 255, 255, 255
DEFB 255, 255, 255, 255
DEFB 255, 255, 255
  ;
  ;
XCIR:    DEFB 0,0
YCIR:    DEFB 0,0
RADX:    DEFB 0,0
RADY:    DEFB 0,0
X1CIR:   DEFB 0,0
Y1CIR:   DEFB 0,0
CSTEP:   DEFB 255,0
CWINK:   DEFB 0,0
PRD:     DEFB 0,0,0,0
MPDAD:   DEFB 0,0
MPRAD:   DEFB 0,0
WORTL:   DEFB 2
BITZ:    DEFB 0,0
  ;
  ;
SIN0:   LD       HL,X1
        LD       DE,XCIR
        LD       BC,8
        LDIR
        LD       HL,255
        LD       (CSTEP),HL
SIN1:   LD       HL,(RADX)
        LD       (MPDAD),HL
        LD       HL,SINTAB
        LD       A,(CSTEP)
        XOR      0FFH
        LD       D,0
        LD       E,A
        ADD      HL,DE
        LD       A,(HL)
        LD       (MPRAD),A
        CALL     MULT
        LD       HL,(PRD)
        LD       (X1CIR),HL
        LD       HL,(RADY)
        LD       (MPDAD),HL
        LD       HL,SINTAB
        LD       A,(CSTEP)
        LD       D,0
        LD       E,A
        ADD      HL,DE
        LD       A,(HL)
        LD       (MPRAD),A
        CALL     MULT
        LD       HL,(PRD)
        LD       (Y1CIR),HL
CPLOT1: LD       HL,(XCIR)
        LD       DE,(X1CIR)
        ADD      HL,DE
        LD       (X1),HL
        LD       HL,(YCIR)
        LD       DE,(Y1CIR)
        ADD      HL,DE
        LD       (Y1),HL
        CALL     PLOT
CPLOT2: LD       HL,(XCIR)
        LD       DE,(X1CIR)
        ADD      HL,DE
        LD       (X1),HL
        LD       HL,(YCIR)
        LD       DE,(Y1CIR)
        SBC      HL,DE
        LD       (Y1),HL
        CALL     PLOT
CPLOT3: LD       HL,(XCIR)
        LD       DE,(X1CIR)
        SBC      HL,DE
        LD       (X1),HL
        LD       HL,(YCIR)
        LD       DE,(Y1CIR)
        ADD      HL,DE
        LD       (Y1),HL
        CALL     PLOT
CPLOT4: LD       HL,(XCIR)
        LD       DE,(X1CIR)
        SBC      HL,DE
        LD       (X1),HL
        LD       HL,(YCIR)
        LD       DE,(Y1CIR)
        SBC      HL,DE
        LD       (Y1),HL
        CALL     PLOT
        XOR      A
        LD       BC,(CSTEP)
        DEC      BC
        OR       B
        OR       C
        RET      Z
        LD       (CSTEP),BC
        JP       SIN1
        ;
MULT:   LD       BC,(MPRAD)
        LD       DE,(MPDAD)
        LD       HL,0
        LD       L,H
        LD       B,8
        OR       A
MULT1:  SRL      C
        JR       NC,NOADD
        ADD      HL,DE
NOADD:  SLA      E
        RL       D
        DEC      B
        JR       NZ,MULT1
        LD       L,H
        LD       H,0
        LD       (PRD),HL
        RET
        ;
        RET
GETBYT: CALL     GRAON
        CALL     GETADR
        LD       IY,(SPADR)
        LD       HL,PRSP1
        LD       BC,0800H
        LD       DE,80
LOOPG:  LD       A,(IY+0)
        LD       (HL),A
        ADD      IY,DE
        INC      HL
        DJNZ     LOOPG
        JP       FINIS
        ;
SETBYT: CALL     GRAON
        CALL     GETADR
        LD       DE,80
        LD       HL,PRSP2
        LD       IY,(SPADR)
        LD       BC,0800H
LOOPS:  LD       A,(HL)
        LD       (IY+0),A
        INC      HL
        ADD      IY,DE
        DJNZ     LOOPS
        JP       FINIS
        ;
MOVSCR: CALL     GRAON
        LD       HL,(X1)
        LD       DE,(X2)
        LD       BC,03FFFH
        LDIR
        JP       FINIS
        ;
        ;
MIX:    CALL     GRAON
        LD       BC,03FFFH
        LD       HL,0000H
        LD       DE,(X2)
LMIX:   LD       A,(DE)
        OR       (HL)
        LD       (HL),A
        INC      DE
        INC      HL
        DEC      BC
        XOR      A
        OR       B
        OR       C
        JR       NZ,LMIX
        JP       FINIS
        ;
        ;
FREE:   DEFS OFFSET+0700H-FREE
        .DEPHASE
        ;
        ;
        END