; NULUTERM.ASM	11/01/85
;
; For NULU.COM Version 1.5
;
; The NULU.DOC contains the information to patch NULU.COM using DDT and
; the save command.  An easier way is to use this routine and then use
; MLOADxx.COM.	Set the various items as desired and assemble with ASM
; or MAC to obtain a .HEX file.  Then use MLOAD as follows:
;
;	MLOAD NEWFILE.COM=OLDFILE.COM,NULUTERM.HEX
;
;	Keith W. Antcliff
;	P.O. Box 906
;	Mead, WA 99021
;	Northwest GodBout/CompuPro RCP/M (509) 624-6799
;	S.M.U.G. (509) 624-7321
;
;-----------------------------------------------------------------------
;
; 11/01/85  Revised for Version 1.5		- Martin Murray
; 01/25/85  Revised for Version 1.1		- Keith Antcliff
; 12/02/84  Added EQU's for Patch ORG's 	- Keith Antcliff
;
;-----------------------------------------------------------------------
;
; See NULU.DOC for further information on the following values.
;
NO	EQU	0
YES	EQU	0FFH
;
NL	EQU	3		; Nesting Level for NCF files
PATCH1	EQU	0163H		; Number of Characters etc.
PATCH2	EQU	0167H		; Number of Open Files etc.
PATCH3	EQU	019CH		; BDOS Vector
PATCH4	EQU	021CH		; Some Toggles and Storage Area
PATCH5	EQU	024CH		; Terminal Control Area
PATCH6	EQU	026FH		; Number of Lines for LST
PATCH7	EQU	0271H		; Printer Initialization Area
;
;
	ORG	PATCH1
	DB	80H		; Number of Characters each line can contain
	DB	50H		; Number of Visible Characters/Line
;
	ORG	PATCH2
	DB	4+NL		; Number of Open Files Allowed
	DW	13+NL		; Number of Relocatable Tasks
	DB	6 		; Number of Contiguously numbered drives
	DB	10		; Number of Contiguous User Areas
;
	ORG	PATCH3
	DW	5		; BDOS vector (See Doc)
;
	ORG	PATCH4
	DB	NO		; NULU Read/Only
	DB	NO		; Exit like LU on command tail
	DB	YES		; BRIEF mode OFF
	DB	YES		; Allow ESC,RET from PROMPT etc.
	DB	NL		; Nesting Level for NCF files
;
;
; The following 39 bytes can be used to store any valid NULU operators.
; See NULU.DOC for details
;
	DB	'-U B: -H -Y -Y *.LBR -O'
	DB	0,0,0
	DB	0,0,0            
	DB	0		; Terminator...Do Not Change
;
;
; The following routines are for a TeleVideo 950 terminal.  Change to
; suit your terminal.  Use This Format:
;
;    ID byte,Number of Bytes,byte,byte,byte,byte,byte - 7 bytes total
;    Do Not Change The ID Byte
;
	ORG	PATCH5
	DB	1,04H,1BH,41H,1BH,6AH	; Background Mode ON
	DB	2,02H,1BH,6BH      	; Background Mode OFF
	DB	3,04H,1BH,41H,1BH,6CH   ; Underline ON
	DB	4,02H,1BH,6DH     	; Underline OFF
	DB	6,04H,1BH,2AH,1BH,41H	; Clear Screen
;
	ORG	PATCH6
	DB	72		 ; Number of lines/page for LST
				 ; 0 to supress page formatting
;
;
; Number of Bytes,byte,byte,byte,byte,byte,byte - 6 bytes total
;
	ORG	PATCH7
	DB	04,1BH,40H,1BH,48H   	 ; Initialize Printer
;
;
	END
