/*
UNIXFUNC.C - Unix functions module of CP/M File eXpress
Copyright 15 Dec 1991 by 
Carson Wilson
1359 W. Greenleaf, #1D
Chicago, IL 60626

UUCP:	carson@sputnik.uucp
	carson@ddsw1.MCS.COM

BBS:	Antelope Freeway, 1-708-455-0120
*/

#include "cfx.h"
#include <termio.h>

struct	termio save, term;	/* terminal status buffer */

/* ---------------------------------------------------------------- */
/*
	Select "raw" tty mode.
*/
int ttyraw()
{
	if ( ioctl (0, TCGETA, &term) == -1) {
		fprintf (stderr, "standard input not a tty\n");
		exit (1);	
	}

	/* save old tty state */
	save = term;

	/* turn off canonical processing */
	term.c_lflag &= ~ICANON;

	/* zero out echo bit of c_lflag */
	term.c_lflag &= ~ECHO;

	/* set MIN and TIME to zero */
	term.c_cc[VMIN] = 0;
	term.c_cc[VTIME] = 0;

	/* set new terminal state */
	ioctl (0, TCSETA, &term);
}
/* ---------------------------------------------------------------- */
/*
	Restore tty state.
*/
int ttyrestore()
{
	/* reset old tty state */
	ioctl (0, TCSETA, &save);

}
/* ---------------------------------------------------------------- */
/*
	Translate CP/M filename to Unix
*/
void unixfn(inputfn)
char *inputfn;
{
	char	tempfn[30];
	char	*fnptr = tempfn;
	char	*inputptr = inputfn;

	*fnptr = '\0';
	for ( ; *inputptr ; inputptr++)
		if ((*inputptr & 0x7F) != ' ')
			*fnptr++ = (tolower(*inputptr) & 0x7F);
	*fnptr = '\0';
	strcpy(inputfn, tempfn);
}
/* End of UNIXFUNC.C */
