/*
LZH.C - .LZH file module of CP/M File eXpress
Copyright 20 Jan 1992 by 
Carson Wilson
1359 W. Greenleaf, #1D
Chicago, IL 60626

UUCP:	carson@sputnik.uucp
	..!uunet!ddsw1!carson

BBS:	Antelope Freeway, 1-708-455-0120

Notes:
	This module is based on the UNLZH.C code distributed with 
	LZH21SRC.LBR by R. Warren, included by his permission.
*/

#include "cfx.h"

/* -------- COMPILER/IMPLEMENTATION DEPENDENT ---------- */

#define ID1 0x76
#define ID2 0xFD

typedef unsigned char uchar;

uchar lgetbuf;
unsigned vbits, vmask, vshift;
char flag_checksum;

/*----------------------- LZSS Parameters ----------------------------- */

/* Size of string buffer */
#define N		2048

/* Size of look-ahead buffer */
#define F		60

#define THRESHOLD	2

/* End of tree's node  */
#define NIL		N

uchar		text_buf[N];

/*------------------ Huffman coding parameters ----------------------------*/

/* Number of Special Characters */
#define NUMSPEC		1

/* EOF code (special character) */
#define EOF_CODE	256

/* character code (= 0..N_CHAR-1) */
#define N_CHAR  	(256 + NUMSPEC + F - THRESHOLD )

/* Size of table */
#define T 		(N_CHAR * 2 - 1)

/* root position */
#define R 		(T - 1)

/* update when cumulative frequency */
/* reaches to this value */
#define MAX_FREQ	0x8000

unsigned freq[T + 1];	/* cumulative freq table */

/*
 * pointing parent nodes.
 * area [T..(T + N_CHAR - 1)] are pointers for leaves
 */
int prnt[T + N_CHAR];

/* pointing children nodes (son[], son[] + 1)*/
int son[T];

/* decoder table */
uchar d_code[256] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
	0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
	0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
	0x0C, 0x0C, 0x0C, 0x0C, 0x0D, 0x0D, 0x0D, 0x0D,
	0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F,
	0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11, 0x11,
	0x12, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13, 0x13,
	0x14, 0x14, 0x14, 0x14, 0x15, 0x15, 0x15, 0x15,
	0x16, 0x16, 0x16, 0x16, 0x17, 0x17, 0x17, 0x17,
	0x18, 0x18, 0x19, 0x19, 0x1A, 0x1A, 0x1B, 0x1B,
	0x1C, 0x1C, 0x1D, 0x1D, 0x1E, 0x1E, 0x1F, 0x1F,
	0x20, 0x20, 0x21, 0x21, 0x22, 0x22, 0x23, 0x23,
	0x24, 0x24, 0x25, 0x25, 0x26, 0x26, 0x27, 0x27,
	0x28, 0x28, 0x29, 0x29, 0x2A, 0x2A, 0x2B, 0x2B,
	0x2C, 0x2C, 0x2D, 0x2D, 0x2E, 0x2E, 0x2F, 0x2F,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
};

uchar d_len[256] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
};
/* ======================= CODE BEGINS ========================= */

void lputc(c, stream)
int c;
FILE *stream;
{
	output(c, stream);
	cksum += (unsigned) c;
}
/* ---------------------------------------------------------------- */

unsigned GetBit(infile)
FILE *infile;
{
	unsigned c;
	if (lgetbuf == 0x80)
		c = (unsigned) (cgetc(infile) << 1) | 0x1;
	else
		c = ((unsigned) lgetbuf) << 1;
	lgetbuf = (uchar) c;

	if (feof(infile))
	{	cerror("unexpected EOF on input file.");
		contin = 0;
	}
	return  ((c & 0x100) ? 1 : 0);
}
/* ---------------------------------------------------------------- */

unsigned GetByte(infile)
FILE *infile;
{
	char i;
	unsigned temp;

	for (i = 8, temp = 0 ; i ; i--)
		temp = (temp <<1) | GetBit(infile);
	return(temp);
}
/* ---------------------------------------------------------------- */

void StartHuff()	/* initialize freq tree */
{
	int i, j;

	for (i = 0; i < N_CHAR; i++) {
		freq[i] = 1;
		son[i] = i + T;
		prnt[i + T] = i;
	}
	i = 0; j = N_CHAR;
	while (j <= R) {
		freq[j] = freq[i] + freq[i + 1];
		son[j] = i;
		prnt[i] = prnt[i + 1] = j;
		i += 2; j++;
	}
	freq[T] = 0xffff;
	prnt[R] = 0;
}
/* ---------------------------------------------------------------- */

void reconst()		/* reconstruct freq tree */
{
	int i, j, k;
	unsigned f, l;

	/* halven cumulative freq for leaf nodes */
	j = 0;
	for (i = 0; i < T; i++)
	{	if (son[i] >= T)
		{	freq[j] = (freq[i] + 1) / 2;
			son[j] = son[i];
			j++;
		}
	}

	/* make a tree : first, connect child nodes */
	for (i = 0, j = N_CHAR; j < T; i += 2, j++)
	{	k = i + 1;
		f = freq[j] = freq[i] + freq[k];
		for (k = j - 1; f < freq[k]; k--);
		k++;

		for (l=j; l != k ; l--)
		{	freq[l] = freq[l-1];
			son[l] = son[l-1];
		}
		freq[k] = f;
		son[k] = i;
	}

	/* connect parent nodes */
	for (i = 0; i < T; i++)
	{	if ((k = son[i]) >= T)
			prnt[k] = i;
		else
			prnt[k] = prnt[k + 1] = i;
	}
}
/* ---------------------------------------------------------------- */

void update(c)		/* update freq tree */
int c;
{
	int i, j, k, l;

	if (freq[R] == MAX_FREQ) {
		reconst();
	}
	c = prnt[c + T];
	do {
		k = ++freq[c];

		/* swap nodes to keep the tree freq-ordered */
		if (k > freq[l = c + 1])
		{	while (k > freq[++l]);
			l--;
			freq[c] = freq[l];
			freq[l] = k;

			i = son[c];
			prnt[i] = l;
			if (i < T)
				prnt[i + 1] = l;

			j = son[l];
			son[l] = i;

			prnt[j] = c;
			if (j < T)
				prnt[j + 1] = c;
			son[c] = j;

			c = l;
		}
	} while ((c = prnt[c]) != 0);	/* do it until reaching the root */
}
/* ---------------------------------------------------------------- */

unsigned DecodeChar(infile)
FILE *infile;
{
	unsigned c;

	c = son[R];

	/*
	 * start searching tree from the root to leaves.
	 * choose node #(son[]) if input bit == 0
	 * else choose #(son[]+1) (input bit == 1)
	 */
	while (c < T)
	{	c += GetBit(infile);
		c = son[c];
	}
	c -= T;
	update(c);
	return c;
}
/* ---------------------------------------------------------------- */

unsigned DecodePosition(infile)
FILE *infile;
{
	unsigned i, j, c;

	/* decode upper 6 bits from given table */
	i = GetByte(infile);
	c = (unsigned) d_code[i] << vshift;
	j = d_len[i];

	/* input lower 6 bits directly */
	j -= vbits;
	while (j--)
		i = (i << 1) + GetBit(infile);
	return c | (i & vmask);
}
/* ---------------------------------------------------------------- */

void Decode(infile)	/* Decoding/Uncompressing */
FILE *infile;
{
	int  i, j, k, r, c;

	lgetbuf = 0x80;		/* prime input engine */
	StartHuff();
	for (i = 0; i < N - F; i++)
		text_buf[i] = ' ';
	r = N - F;
	while ((c = DecodeChar(infile)) != EOF_CODE && (contin))
	{	if (c < 256)
		{	lputc(c, outfd);
			text_buf[r++] = c;
			r &= (N - 1);
		}
		else
		{	i = (r - DecodePosition(infile) - 1) & (N - 1);
			j = c - 255-NUMSPEC + THRESHOLD;
			for (k = 0; k < j; k++)
			{	c = text_buf[(i + k) & (N - 1)];
				lputc(c, outfd);
				text_buf[r++] = c;
				r &= (N - 1);
			}
		}
	}
}
/* ---------------------------------------------------------------- */
/*
	Un-LZH a single file.
*/
void unlzh(lzhfd, lzhfn, lzhfs)
FILE *lzhfd;
char *lzhfn;
long lzhfs;
{
	char *p;
	char outfn[80];		/* space to build output file name   */

	uchar version;
	int  i;
	unsigned hold_check;

	/* Extract and build output file name */

	cgetc(lzhfd);	/* skip signature */
	cgetc(lzhfd);

	for ( p = outfn; (*p = (cgetc(lzhfd) & 0x7F)) != '\0' ; p++)
	{
		if (*p == '[')		/* comment separator */
		{
			*p = ' ';
			*++p = '[';
		}
		else if (*p == 1)	/* DateStamper separator */
			*p = '\0';
	}

	outcrlf(1);
	printf("  --> %s", outfn);

	*(cisubstr(outfn, ".") + 4) = '\0'; /* truncate non-name portion */
	if (diskout)
	{
#ifdef UNIX
		unixfn(outfn);
		printf(" (%s)", outfn);
#endif
		/* Open output file */
		if ( 0 == (outfd = fopen( outfn, "wb")) )
		{	cerror("can't create %s!", outfn);
			return;
		}
        }
	else
		outcrlf(2);

	cgetc(lzhfd); 				/* Encoder version */

	if ((version = cgetc(lzhfd)) == 0x20)	/* Significant version */
	{	vbits = 3;
		vmask = 0x1F;
		vshift= 5;
	}
	else if (version < 0x20)
	{	vbits = 2;
		vmask = 0x3F;
		vshift= 6;
	}
	else
	{	outcrlf(1);
		cerror("needs newer LZH revision");
		return;
	}

	flag_checksum = (uchar) cgetc(lzhfd);	/* Check Type */
	cgetc(lzhfd);				/* Filler */
	outreccount = 0;

	Decode(lzhfd);			/* Extract file to screen/disk */
	if (contin == 0)
		return;			/* quit now if input error */

	/* Test checksum */
	if (flag_checksum == 0 ) /* Only handle CHECKSUM type == 0 */
		for (i = 0, hold_check = cksum; i++ < 2 ; hold_check >>= 8)
			if ((unsigned) cgetc(lzhfd) != (hold_check & 0xFF))
				cerror("checksum error");
}
/* End of LZH.C */
