	title	'Bank & Move Module for the Modular CP/M 3 BIOS'

;	CP/M-80 Version 3	-- Modular BIOS
;	Bank and Move Module for Z80-Simulator
;	Initial version 1.0
;	Copyright (C) 1989 by Udo Munk

	cseg

	public	?move,?xmove,?bank
	extrn	@cbnk

	maclib z80
	maclib ports

?xmove:		; no interbank moves used
	ret

?move:
	xchg			; we are passed source in DE and dest in HL
	ldir			; use Z80 block move instruction
	xchg			; need next address in same regs
	ret

?bank:
banked  equ 15 ; number of switched 4k pages
        push bc
        push de
        push hl
        ; load DE with the highest page number in the new bank
        add a
        mov e,a
        xra a
        mov d,a
        lxi h,toppage
        dad d
        mov e,m
        inx h
        mov d,m
        ; load B with the highest switched frame number
        mvi a,banked
        mov b,a
map:
        dcr b
        mov a,e
        out p$pagelow
        mov a,d
        out p$pagehigh
        mov a,b
        out p$frame
        dcx d
        jnz map
        pop hl
        pop de
        pop bc
	ret
toppage:
        ; banked-1, 15+banked*bank
        dw 14,30

	end
