	title	'LDRBIOS for CP/M 3'

;	CP/M-80 Version 3
;	LDRBIOS for Z80-Simulator
;	Version 1.1
;	Copyright (C) 1989-95 by Udo Munk

	maclib cpm3	; disk definition macros
	maclib ports	; define port addresses
        maclib z80

	; BIOS Jump vector.

	jmp boot	; initial entry on cold start
	jmp wboot	; reentry on program exit, warm start

	jmp const	; return console input status
	jmp conin	; return console input character
	jmp conout	; send console output character
	jmp list	; send list output character
	jmp auxout	; send auxiliary output character
	jmp auxin	; return auxiliary input character

	jmp home	; set disks to logical home
	jmp seldsk	; select disk drive, return disk parameter info
	jmp settrk	; set disk track
	jmp setsec	; set disk sector
	jmp setdma	; set disk I/O memory address
	jmp read	; read physical block(s)
	jmp write	; write physical block(s)

	jmp listst	; return list device status
	jmp sectrn	; translate logical to physical sector

	jmp conost	; return console output status
	jmp auxist	; return auxx input status
	jmp auxost	; return aux output status
	jmp devtbl	; return address of device def table
	jmp ?cinit	; change baud  rate of device

	jmp getdrv	; return address of disk drive table
	jmp multio	; set multiple record count for disk I/O
	jmp flush	; flush BIOS maintained disk caching

	jmp ?move	; block move memory to memory
	jmp ?time	; signal time and date operation
	jmp bnksel	; select bank for code execution and default DMA
	jmp setbnk	; select different bank for disk I/O DMA operation
	jmp ?xmove	; set source and destination banks for one operation

	jmp 0		; reserved for future expansion
	jmp 0		; reserved for future expansion
	jmp 0		; reserved for future expansion

boot:
wboot:
	ret

const:
	ret

conin:
	ret

conout:
	mov a,c ! out p$crt$data ! ret

list:
	ret

auxout:
	ret

auxin:
	ret

home:
	ret

seldsk:
	mov a,c ! out p$fddrive ! lxi h,dphsd ! ret

settrk:
	mov a,b ! out p$fdtrackh ! mov a,c ! out p$fdtrackl ! ret

setsec:
	mov a,c ! out p$fdsector ! ret

setdma:
	mov a,b ! out p$dmahigh ! mov a,c ! out p$dmalow ! ret

read:
	mvi a,0 ! out p$fdcmd ! in p$fdstat ! ret

write:
	ret

listst:
	ret

sectrn:
	mov l,c ! mov h,b
	xchg ! dad b ! mov l,m ! mvi h,0
	ret

conost:
	ret

auxist:
	ret

auxost:
	ret

devtbl:
	ret

?cinit:
	ret

getdrv:
	ret

multio:
	ret

flush:
	ret

?move:
        xchg                    ; we are passed source in DE and 
dest in HL
        ldir                    ; use Z80 block move instruction
        xchg                    ; need next address in same regs
	ret

?time:
	ret

bnksel:
	ret

setbnk:
	ret

?xmove:
	ret

	; disk parameter header

dphsd 	dw	trans		; translate table address
	db	0,0,0,0,0,0,0,0,0 ; BDOS scratch area
	db	0		; media flag
	dw	dpbsd		; disk parameter block
	dw	csv		; checksum vector
	dw	alv		; allocation vector
	dw	dirbcb		; DIRBCB
	dw	0FFFFh		; DTABCB
	dw	0FFFFh		; HASH
	db	0		; HASH bank

csv 	ds	16		; checksum vector
alv 	ds	31		; allocation vector

	; disk parameter block

dpbsd 	dpb	128,26,77,1024,64,2

	; sector translate table

trans	skew 26,6,1

	; directory buffer control block

dirbcb 	db	0FFh		; disk drive
	ds	3		; record position
	ds	1		; write buffer flag
	ds	1		; BDOS scratch byte
	ds	2		; track
	ds	2		; sector
	dw	dirb		; directory buffer

	; directory buffer

dirb 	ds	128

	end
