	title	'Diskette and hard drive driver for the Modular CP/M 3 BIOS'

;	CP/M-80 Version 3	-- Modular BIOS
;	Disk I/O Module for Z80-Simulator
;	Version 1.1
;	Copyright (C) 1989-95 by Udo Munk

	dseg

	; disk drive dispatching tables for linked BIOS

	public	fd0,fd1,hd0,hd1

	; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk

	; System Control Block variables

	extrn	@ermde		; BDOS error mode

	; Utility routines in standard BIOS

	extrn	?wboot		; warm boot vector
	extrn	?pmsg		; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec		; print binary number in <A> from 0 to 99
	extrn	?pderr		; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status
        extrn   ?bank           ; select bank in <A>

	; Port Address Equates

	maclib	ports

	; CP/M 3 Disk definition macros

	maclib	cpm3

	; Z80 macro library instruction definitions

	maclib	z80

	; common control characters

cr	equ	13
lf	equ	10
bell	equ	7

	; Extended Disk Parameter Headers (XDPHs)

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	0,0		; relative drive zero
fd0	dw	trans		; translate table address
	db	0,0,0,0,0,0,0,0,0 ; BDOS scratch area
	db	0		; media flag
	dw	dpbfd		; disk parameter block
	dw	0FFFFh		; checksum vector
	dw	0FFFEh		; allocation vector by GENCPM
	dw	0FFFEh		; DIRBCB allocated by GENCPM
	dw	0FFFFh		; DTABCB do not use data buffer
	dw	0FFFEh		; HASH allocated by GENCPM
	db	0		; HASH bank
;
	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	1,0		; relative drive one
fd1	dw	trans		; translate table address
	db	0,0,0,0,0,0,0,0,0 ; BDOS scratch area
	db	0		; media flag
	dw	dpbfd		; disk parameter block
	dw	0FFFFh		; checksum vector
	dw	0FFFEh		; allocation vector by GENCPM
	dw	0FFFEh		; DIRBCB allocated by GENCPM
	dw	0FFFFh		; DTABCB do not use data buffer
	dw	0FFFEh		; HASH allocated by GENCPM
	db	0		; HASH bank
;
	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	2,0		; relative drive two
hd0	dw	transhd		; translate table address
	db	0,0,0,0,0,0,0,0,0 ; BDOS scratch area
	db	0		; media flag
	dw	dpbhd		; disk parameter block
	dw	0FFFFh		; checksum vector
	dw	0FFFEh		; allocation vector by GENCPM
	dw	0FFFEh		; DIRBCB allocated by GENCPM
	dw	0FFFFh		; DTABCB do not use data buffer
	dw	0FFFEh		; HASH allocated by GENCPM
	db	0		; HASH bank
;
	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init0
	db	3,0		; relative drive three
hd1	dw	transhd		; translate table address
	db	0,0,0,0,0,0,0,0,0 ; BDOS scratch area
	db	0		; media flag
	dw	dpbhd		; disk parameter block
	dw	0FFFFh		; checksum vector
	dw	0FFFEh		; allocation vector by GENCPM
	dw	0FFFEh		; DIRBCB allocated by GENCPM
	dw	0FFFFh		; DTABCB do not use data buffer
	dw	0FFFEh		; HASH allocated by GENCPM
	db	0		; HASH bank
;

	cseg	;DPB must be resident

dpbfd	dpb	128,26,77,1024,64,2,8000h

dpbhd   dpb     128,32,1024,2048,256,0,8000h

	dseg	;this may be banked

trans	skew	26,6,1

transhd skew    32,1,1

	; Disk I/O routines for standardized BIOS interface

	; Initialization entry point.
	;	called for first time initialization

fd$init0:
	ret			; no init code needed for Z80-Simulator

	; This entry is called when a logical drive is about to
	; be logged into for the purpose of density determination.
	; It may adjust the parameters contained in the disk
	; parameter header pointed at by <DE>.

fd$login:
	ret	; we have nothing to do in
		;	simple single density only environment

	; Disk READ and WRITE entry points.
	;	these entries are called with the following arguments:
	;		relative drive number in @rdrv (8 bits)
	;		absolute drive number in @adrv (8 bits)
	;		disk transfer address in @dma (16 bits)
	;		disk transfer bank    in @dbnk (8 bits)
	;		disk track address    in @trk (16 bits)
	;		disk sector address   in @sect (16 bits)
	;		pointer to XDPH       in <DE>

fd$read:
	lxi h,read$msg		; point at " Read "
	mvi a,0			; read fdc command
	jmp rw$common

fd$write:
	lxi h,write$msg		; point at " Write "
	mvi a,1			; write fdc command
	jmp rw$common

	cseg	;rest must be resident

rw$common:
	shld operation$name	; save message for errors
	sta disk$command	; save fdc command
	lda @adrv ! out p$fddrive 	; select drive
	lhld @trk			; select track
	mov a,h ! out p$fdtrackh
	mov a,l ! out p$fdtrackl
	lda @sect ! out p$fdsector	; select sector
	lhld @dma			; select DMA address
	mov a,h ! out p$dmahigh
	mov a,l ! out p$dmalow
	lda @dbnk ! call ?bank   	; select DMA bank
	lda disk$command ! out p$fdcmd	; start data transfer
	mvi a,0 ! call ?bank      	; reselect bank 0
	in p$fdstat			; get status
	ora a ! rz		; check status and return to BDOS if no error

	; suppress error message if BDOS is returning errors to application...

	lda @ermde ! cpi 0FFh ! jz hard$error

	; Had permanent error, print message like:
	;	BIOS Err on d: T-nn, S-mm, <operation>

	call ?pderr				; print message header
	lhld operation$name ! call ?pmsg	; last function
hard$error:
	mvi a,l ! ret		; return error to BDOS

disk$command	ds	1	; current fdc command
operation$name	dw	read$msg
read$msg	db	', Read',0
write$msg	db	', Write',0

	end
