	REM THIS IS A DEMONSTRATION PROGRAM FOR
	REM CBASIC GRAPHICS EXTENSIONS
	REM
	REM PROGRAM NAME: DEMOGRAF
	REM
		%INCLUDE GRAPHCOM.BAS

	DEF PAUSE
	REM UTILITY TO SUSPEND PROGRAM EXECUTION UNTIL CHARACTER IS
	REM ENTERED AT CONSOLE, STOPPING PROGRAM IF CTRL-C IS ENTERED,
	REM OTHERWISE RETURNING INTEGER VALUE OF CHARACTER ENTERED.
	REM CHARACTER IS NOT DISPLAYED.

	INTEGER PAUSE,CHOICE

		CHOICE = INKEY
		IF CHOICE = 3 THEN STOP
		PAUSE = CHOICE
	FEND

		GRAPHIC OPEN 1
		CLEAR

	BEEM:	GRAPHIC PRINT AT (0,.9): "BEAM STATEMENT"
		SET BEAM "OFF"
		PLOT (0,1),(1,1),(1,0),(0,0)
		KEY% = PAUSE 		REM WAIT FOR CONSOLE INPUT
		CLEAR
		SET BEAM "ON"
		PLOT (0,1),(1,1),(1,0),(0,0)
		KEY% = PAUSE

	REM ILLUSTRATE TECHNIQUE OF SQUARING A DISPLAY

	BOWNDS:	CLEAR
		GRAPHIC PRINT AT (0,.9): "BOUNDS STATEMENT"
		ASK DEVICE X.AXIS,Y.AXIS
		PRINT "THE ASPECT RATIO IS = ";Y.AXIS;"/";X.AXIS
		KEY% = PAUSE
		PLOT (0,0),(0,1),(1,1),(1,0),(0,0)
		KEY% = PAUSE
		CLEAR
		SET BOUNDS Y.AXIS,X.AXIS
		PLOT (0,0),(0,1),(1,1),(1,0),(0,0)
		SET BOUNDS 1,1
		KEY% = PAUSE

	REM DEMONSTRATE CONTROL OF GRAPHIC CHARACTER HEIGHT
	REM AND MINIMUM HEIGHT FOR GRAPHIC CHARACTERS

	HIGH:	CLEAR
		SET CHARACTER HEIGHT 0
		GRAPHIC PRINT AT (0,.9): "CHARACTER HEIGHT STATEMENT"
		SET CHARACTER HEIGHT .1
		GRAPHIC PRINT AT (0,.7): "10 PERCENT"
		KEY% = PAUSE
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 15
		GRAPHIC PRINT AT (0,40): "15 PERCENT"
		KEY% = PAUSE
		SET CHARACTER HEIGHT 0
		ASK CHARACTER HEIGHT CH
		PRINT "MINIMUM CHARACTER HEIGHT IS = "; CH
		GRAPHIC PRINT AT (0,20): "MINIMUM HEIGHT"

	REM DISPLAY SEVERAL RANDOM LINES ON SCREEN, THEN MAKE
	REM THEM DISAPPEAR VIA "CLEAR" STATEMENT

		INPUT ""; LINE SEED$
		RANDOMIZE
	CLR:	CLEAR 
		GRAPHIC PRINT AT (0,90): "CLEAR STATEMENT"
		SET WINDOW 0,1,0,1
		FOR I.INT% = 1 TO 10
			PLOT (RND,RND),(RND,RND)
		NEXT I.INT%
		KEY% = PAUSE
		CLEAR

	REM ILLUSTRATE EFFECT OF AUTOMATIC CLIPPING WHEN FIGURE
	REM EXCEEDS ALLOWABLE BOUNDARIES

	CLP:	SET WINDOW 0,100,0,100
		GRAPHIC PRINT AT (0,90): "CLIP STATEMENT"
		PLOT (25,10),(50,150),(75,10),(25,10)
		KEY% = PAUSE

	REM DRAW BORDER IN EACH AVAILABLE COLOR (NUMBER OF
	REM COLORS VARIES WITH RESOLUTION)

	COLR:	CLEAR
		GRAPHIC PRINT AT (0,90): \
			"COLOR AND COLOR COUNT STATEMENTS"
		SET WINDOW 0,1,0,1
		ASK COLOR COUNT CT%
		FOR I.INT% = 1 TO CT%
			SET COLOR I.INT%
			PLOT (0,0),(0,1),(1,1),(1,0),(0,0)
			KEY% = PAUSE
		NEXT I.INT%

	REM RETRIEVE AND DISPLAY SPECIFICATIONS FOR CURRENT DEVICE

	DEVC:	CLEAR
		SET CHARACTER HEIGHT 0
		SET COLOR 1
		GRAPHIC PRINT AT (0,.8): "DEVICE STATEMENT"
		ASK DEVICE X.AXIS,Y.AXIS
		PRINT "THE VERTICAL AXIS IS "; \
			Y.AXIS*100.0/X.AXIS;"PERCENT OF THE";
		PRINT " HORIZONTAL AXIS"
		PRINT "X= ";X.AXIS;"  Y= ";Y.AXIS
		KEY% = PAUSE

	REM MENTION "GRAPHIC CLOSE" STATEMENT

	GCLOSE:	CLEAR
		GRAPHIC PRINT AT (0,.9): "GRAPHIC CLOSE STATEMENT"
		GRAPHIC PRINT AT (0,.5): "GRAPHIC CLOSE HAS NO DEMO"
		KEY% = PAUSE

	REM ILLUSTRATE GRAPHIC INPUT VIA CURSOR POSITIONING

	GIN:	CLEAR
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		GRAPHIC PRINT AT (0,80): "GRAPHIC INPUT STATEMENT"
		GRAPHIC PRINT AT (0,25): "OPTION 1 ."
		SET COLOR 2
		GRAPHIC PRINT AT (0,50): "OPTION 2 ."
		SET COLOR 3
		GRAPHIC PRINT AT (0,75): "OPTION 3 ."
		GRAPHIC INPUT X.AXIS,Y.AXIS,A$
		N = INT((Y.AXIS+5)/25)
		IF N = 0 THEN N = 1	REM NO OPTION ZERO
		IF N > 3 THEN N = 3	REM ONLY THREE OPTIONS
		PRINT "THE CURSOR WAS POSITIONED AT: "; X.AXIS,Y.AXIS
		PRINT "YOU SELECTED OPTION:          "; N
		PRINT "THE TERMINATING KEY WAS:      "; A$
		KEY% = PAUSE

	REM MENTION "GRAPHIC OPEN" STATEMENT

	GOPEN:	CLEAR
		SET COLOR 1
		SET CHARACTER HEIGHT 0
		GRAPHIC PRINT AT (0,90): "GRAPHIC OPEN STATEMENT"
		GRAPHIC PRINT AT (0,50): \
			"THE GRAPHIC OPEN HAS NO DEMONSTRATION"
		KEY% = PAUSE

	REM DEMONSTRATE CENTERING AND JUSTIFICATION

	GPRT:	CLEAR
		SET WINDOW 0,1,0,1
		SET CHARACTER HEIGHT 0
		GRAPHIC PRINT AT (0,.9): "GRAPHIC PRINT STATEMENT"
		SET JUSTIFY 0,0
		GRAPHIC PRINT AT (.5,.5): "BEGINS AT CENTER"
		KEY% = PAUSE
		SET JUSTIFY .5,0
		GRAPHIC PRINT AT (.5,.3): "THIS IS CENTERED"
		KEY% = PAUSE
		SET JUSTIFY .5,.5
		GRAPHIC PRINT AT (.5,.3): "THIS IS CENTERED"
		KEY% = PAUSE
		SET JUSTIFY 1.0,1.0
		GRAPHIC PRINT AT (.5,.5): "ENDS AT CENTER"
		KEY% = PAUSE
	JUST:	CLEAR
		SET JUSTIFY 0,0
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		GRAPHIC PRINT AT (0,90): "JUSTIFY STATEMENT"
		PLOT (20,80),(20,20),(80,20)
		PLOT (15,40),(20,40)
		PLOT (15,60),(20,60)
		PLOT (15,80),(20,80)
		PLOT (40,15),(40,20)
		PLOT (60,15),(60,20)
		PLOT (80,15),(80,20)
		SET JUSTIFY 1,.5
		GRAPHIC PRINT AT (14,20): "20"
		GRAPHIC PRINT AT (14,40): "40"
		GRAPHIC PRINT AT (14,60): "60"
		GRAPHIC PRINT AT (14,80): "80"
		SET JUSTIFY .5,1
		GRAPHIC PRINT AT (20,14): "20"
		GRAPHIC PRINT AT (40,14): "40"
		GRAPHIC PRINT AT (60,14): "60"
		GRAPHIC PRINT AT (80,14): "80"
		KEY% = PAUSE

	REM EXHIBIT VARIATION OF LINE STYLE

	STYL:	CLEAR
		SET JUSTIFY 0,0
		SET WINDOW 0,1,0,1
		GRAPHIC PRINT AT (0,.9): "LINE STYLE STATEMENT"
		SET LINE STYLE 3
		SET JUSTIFY 1,0
		GRAPHIC PRINT AT (.5,.5): "Sign here"
		PLOT (0.5,0.5),(0.8,0.5)
		KEY% = PAUSE

	REM ILLUSTRATE VARIATION IN SIZE OF MARKERS

	MHIGH:	CLEAR
		SET WINDOW 0,1,0,1
		SET CHARACTER HEIGHT 0
		SET LINE STYLE 1
		SET JUSTIFY 0,0
		GRAPHIC PRINT AT (0,.9): "MARKER HEIGHT STATEMENT"
		DIM MX(5)
		DIM MY(5)
		MX(0) = .3 : MY(0) = .7
		MX(1) = .7 : MY(1) = .7
		SET MARKER HEIGHT .1
		MAT MARKER 1: MX,MY
		SET WINDOW 0,100,0,100
		MX(0) = 30 : MY(0) = 50
		MX(1) = 70 : MY(1) = 50
		SET MARKER HEIGHT 15
		MAT MARKER 1: MX,MY
		SET MARKER HEIGHT 0
		ASK MARKER HEIGHT MK
		PRINT "MINIMUM MARKER HEIGHT IS = "; MK
		KEY% = PAUSE

	REM DEMONSTRATE ALL MARKER SHAPES

	MTYPE:	CLEAR
		SET WINDOW 0,1,0,1
		SET MARKER HEIGHT 0
		GRAPHIC PRINT AT (0,.9): "MARKER TYPE STATEMENT"
		MX(0) = .5 : MY(0) = .7
		FOR I.INT% = 1 TO 5
			SET MARKER TYPE I.INT%
			MAT MARKER 0: MX,MY
			MY(0) = MY(0) - .1
		NEXT I.INT%
		KEY% = PAUSE

	REM DEMONSTRATE FILLED POLYGON

	MFILL:	CLEAR
		SET LINE STYLE 1
		SET JUSTIFY 0,0
		GRAPHIC PRINT AT (0,.9): "MAT FILL STATEMENT"
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		SET COLOR 1
		DIM X.ARRAY(10)
		DIM Y.ARRAY(10)
		X.ARRAY(0) = 40 : Y.ARRAY(0) = 10
		X.ARRAY(1) = 35 : Y.ARRAY(1) = 25
		X.ARRAY(2) = 50 : Y.ARRAY(2) = 40
		X.ARRAY(3) = 65 : Y.ARRAY(3) = 25
		X.ARRAY(4) = 60 : Y.ARRAY(4) = 10
		MAT FILL 4: X.ARRAY,Y.ARRAY
		KEY% = PAUSE

	REM ILLUSTRATE POSITIONING OF MARKERS VIA AN ARRAY

	MMARK:	CLEAR
		SET WINDOW 0,100,0,100
		GRAPHIC PRINT AT (0,90): "MAT MARKER STATEMENT"
		SET MARKER HEIGHT 0
		SET MARKER TYPE 1
		SET COLOR 1
		MAT MARKER 4: X.ARRAY,Y.ARRAY
		KEY% = PAUSE

	REM DEMONSTRATE DRAWING POLYGON OUTLINE VIA AN ARRAY

	MPLOT:	CLEAR
		GRAPHIC PRINT AT (0,90): "MAT PLOT STATEMENT"
		SET COLOR 1
		SET WINDOW 0,1,0,1
		SET CHARACTER HEIGHT 0
		FOR I.INT% = 0 TO 4
			X.ARRAY(I.INT%) = .01 * X.ARRAY(I.INT%)
			Y.ARRAY(I.INT%) = .01 * Y.ARRAY(I.INT%)
		NEXT I.INT%
		X.ARRAY(5) = .40 : Y.ARRAY(5) = .10
		SET BEAM "OFF"
		MAT PLOT 4: X.ARRAY,Y.ARRAY
		KEY% = PAUSE
		CLEAR
		MAT PLOT 5: X.ARRAY,Y.ARRAY
		KEY% = PAUSE

	REM DO POLYGON VIA "PLOT" STATEMENTS

	PLT:	CLEAR
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		SET COLOR 1
		GRAPHIC PRINT AT (0,90): "PLOT STATEMENT"
		PLOT (40,10),(35,25);
		SET COLOR 2
		PLOT (35,25),(50,40);
		SET LINE STYLE 2
		PLOT (50,40),(65,25);
		SET LINE STYLE 1
		SET COLOR 3
		PLOT (65,25),(60,10),(40,10)
		KEY% = PAUSE

	REM EXERCISE ARBITRARY POSITIONING OF GRAPHIC BEAM

	POSIT:	CLEAR
		GRAPHIC PRINT AT (0,90): "POSITION STATEMENT"
		SET BEAM "OFF"
		SET POSITION 50,50
		SET POSITION 50,100
		SET BEAM "ON"
		SET POSITION 0,0
		SET POSITION 50,50
		KEY% = PAUSE

	REM SHOW ALL LINE STYLES

	STCNT:	CLEAR
		GRAPHIC PRINT AT (0,90): "STYLE COUNT STATEMENT"
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		ASK STYLE COUNT ST%
		PRINT "THE NUMBER OF LINE STYLES IS: "; ST%
		FOR I.INT% = 1 TO ST%
			SET LINE STYLE I.INT%
			SET BEAM "OFF"
			PLOT (10*I.INT%,10),(10*I.INT%,90)
		NEXT I.INT%
		KEY% = PAUSE
		SET LINE STYLE 1

	REM DEMONSTRATE ROTATION OF TEXT

	ANGEL:	CLEAR
		GRAPHIC PRINT AT (0,90): "TEXT ANGLE STATEMENT"
		SET WINDOW 0,1,0,1
		SET CHARACTER HEIGHT 0
		PI = 3.1415926
		RAD = PI*2
		DEG = RAD/360
			FOR I.INT% = 90 TO 360 STEP 90
			SET TEXT ANGLE I.INT%*DEG
			GRAPHIC PRINT AT (.5,.5): "ROTATE ME"
		NEXT I.INT%
		KEY% = PAUSE
		SET TEXT ANGLE 0

	REM ILLUSTRATE EFFECT OF VARYING VIEWPORT

	VYOU:	CLEAR
		GRAPHIC PRINT AT (0,.9): "VIEWPORT STATEMENT"
		X.ARRAY(0) = 0   : Y.ARRAY(0) = 0
		X.ARRAY(1) = 0   : Y.ARRAY(1) = 100
		X.ARRAY(2) = 100 : Y.ARRAY(2) = 100
		X.ARRAY(3) = 100 : Y.ARRAY(3) = 0
		X.ARRAY(4) = 0   : Y.ARRAY(4) = 0
		SET VIEWPORT 0,1,0,1
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		MAT PLOT 4: X.ARRAY,Y.ARRAY
		SET VIEWPORT .1,.9,.1,.9
		MAT PLOT 4: X.ARRAY,Y.ARRAY
		SET VIEWPORT .2,.8,.2,.8
		MAT PLOT 4: X.ARRAY,Y.ARRAY
		SET VIEWPORT .3,.5,.3,.5
		MAT PLOT 4: X.ARRAY,Y.ARRAY
		SET VIEWPORT .5,.7,.5,.7
		MAT PLOT 4: X.ARRAY,Y.ARRAY
		KEY% = PAUSE

	REM ILLUSTRATE EFFECT OF VARYING WINDOW

	WINDW:	CLEAR
		SET VIEWPORT 0,1,0,1
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		GRAPHIC PRINT AT (0,90): "WINDOW STATEMENT"
		PLOT (0,0),(60,60),(60,0),(0,0)
		SET WINDOW 0,200,0,200
		SET CHARACTER HEIGHT 0
		PLOT (0,0),(60,60),(60,0),(0,0)
		SET VIEWPORT 0,.5,.5,1.0
		PLOT (0,0),(60,60),(60,0),(0,0)
		KEY% = PAUSE

	REM FINISH DEMONSTRATION AND END PROGRAM

	FIN:	CLEAR
		SET WINDOW 0,100,0,100
		SET CHARACTER HEIGHT 0
		SET VIEWPORT 0,1,0,1
		SET COLOR 1
		FOR I.INT% = 1 TO CT%
			SET COLOR I.INT%
			MAT PLOT 5: X.ARRAY,Y.ARRAY
			SET VIEWPORT .01*I.INT%,1-(I.INT%*.01), \
				.01*I.INT%,1-(I.INT%*.01)
		NEXT I.INT%
		SET JUSTIFY .5,.5
		SET COLOR 1
		SET VIEWPORT 0,1,0,1
		GRAPHIC PRINT AT (50,50): "THANKS FOR THE VIEWING"
		KEY% = PAUSE
		STOP
		END
	