;
; *** Listing 14-13 ***
;
; Demonstrates that it's much slower to scan a table
; in a loop than to use REP SCASW; look-up tables should
; be designed so that repeated string instructions can be
; used.
;
	jmp	Skip
;
; Branches to the routine corresponding to the key code in
; AX. Simply returns if no match is found.
;
; Input:
;	AX = 16-bit key code, as returned by the BIOS
;
; Output: none
;
; Registers altered: CX, DI, ES
;
; Direction flag cleared
;
; Table of 16-bit key codes this routine handles, each
; paired with the address to jump to if that key code is
; found.
;
KeyLookUpTable	label	word
	dw	1e41h, HandleA_Z, 3042h, HandleA_Z	;A-B
	dw	2e43h, HandleA_Z, 2044h, HandleA_Z	;C-D
	dw	1245h, HandleA_Z, 2146h, HandleA_Z	;E-F
	dw	2247h, HandleA_Z, 2347h, HandleA_Z	;G-H
	dw	1749h, HandleA_Z, 244ah, HandleA_Z	;I-J
	dw	254bh, HandleA_Z, 264ch, HandleA_Z	;K-L
	dw	324dh, HandleA_Z, 314eh, HandleA_Z	;M-N
	dw	184fh, HandleA_Z, 1950h, HandleA_Z	;O-P
	dw	1051h, HandleA_Z, 1352h, HandleA_Z	;Q-R
	dw	1f53h, HandleA_Z, 1454h, HandleA_Z	;S-T
	dw	1655h, HandleA_Z, 2f56h, HandleA_Z	;U-V
	dw	1157h, HandleA_Z, 2d58h, HandleA_Z	;W-X
	dw	1559h, HandleA_Z, 2c5ah, HandleA_Z	;Y-Z
KEY_LOOK_UP_TABLE_LEN_IN_ENTRIES equ (($-KeyLookUpTable)/4)
;
VectorOnKey	proc	near
	mov	di,cs
	mov	es,di
	mov	di,offset KeyLookUpTable
			;point ES:DI to the table of keys
			; we handle, which is in the same
			; code segment as this routine
	mov	cx,KEY_LOOK_UP_TABLE_LEN_IN_ENTRIES
			;# of entries to scan
	cld
VectorOnKeyLoop:
	scasw
	jz	VectorOnKeyJump	;we've found the key code
	inc	di		;point to the next entry
	inc	di
	loop	VectorOnKeyLoop
	ret			;the key code is not in the
				; table, so we're done
VectorOnKeyJump:
	jmp	word ptr cs:[di]
			;jump to the routine for this key
HandleA_Z:
	ret
VectorOnKey	endp
;
Skip:
	call	ZTimerOn
	mov	ax,1e41h
	call	VectorOnKey	;look up 'A'
	mov	ax,1749h
	call	VectorOnKey	;look up 'I'
	mov	ax,1f53h
	call	VectorOnKey	;look up 'S'
	mov	ax,2c5ah
	call	VectorOnKey	;look up 'Z'
	mov	ax,0
	call	VectorOnKey	;finally, look up a key
				; code that's not in the
				; table
	call	ZTimerOff
