		NAME	HDDRV
		TITLE	'HARD DISK ROM DRIVER'
		PAGE	58,132
	SUBTTL	"COMMENT"
		PAGE
		COMMENT \

FIXED DISK I/O INTERFACE.

	THIS INTERFACE PROVIDES ACCESS 5 1/4" FIXED DISKS THROUGH THE
	FIXED DISK CONTROLLER.
	THE BIOS ROUTINES ARE MEANT TO BE ACCESSED THROUGH SOFTWARE
	INTERRUPTS ONLY. ANY ADDRESS PRESENT IN THE LISTING ARE INCLUDED
	ONLY FOR COMPLETENESS, NOT FOR REFERENCE. APPLICATIONS WHICH
	REFERENCE ABSOLUTE ADDRESS WITHIN THE "ROM" SEGMENT VIOLATE THE
	STRUCTURE AND DESIGH BIOS.

PARAMETERS

 INPUT	(AH = HEX VALUE)
	AH = COMMAND AND OPTION
		OPTION (BIT 7--4)
			BIT 5 : ERROR RETRY
				0 = RETRY 8 TIMES
				1 = NOT RETRY
			BIT 7,6,4 : NOT USED

		COMMAND (BIT 3--0)
			0 = NO OPERATION
			1 = VERIFY DATA
			2 = READ DIAGNOSTIC
			3 = INTTIALIZE
			4 = SENSE
			5 = WRITE DATA
			6 = READ DATA
			7 = RECAIBRATE
			8 = NO OPERATION
			9 = WRITE DELETED DATA
			A = READ ID
			B = NO OPERATION
			C = READ DELETED DATA
			D = WRITE ID
			E = NO OPERATION
			F = RETRACT

	AL = DEVICE DRIVE UNIT AND OPTION
		OPTION (BIT 7--4)
			BIT 7 : RELATIVE SECTOR ACCESS
			BIT 6 : NOT USED
			BIT 5,4 : DISK TYPE
				01 = 5 1/4" FIXED DISK
		UNIT NUMBER (BIT 3--0)

	BX = DATA BYTE LENGTH (512 BYTE BOUNDARY)
	CX = CYLINDER NUMBER / RELATIVE SECTOR NUMBER LOW
	DL = SECTOR	NUMBER / RELATIVE SECTOR NUMBER HIGH
	DH = HEAD	NUMBER / 0
	ES:BP = DATA BUFFER POINTER

OUTPUT	(AH = HEX VALUE)

	C-FLAG = FIRST STATUS
		0 = SUCCESSFUL END	(AH < 20H)
		1 = UNSUCCESSFUL END	( AH >= 20H)
	AH = SECOND STATUS
		BIT 7,6,5,4 : ACCESS STATUS
			0 = NORMAL END
			1 = CONTROL MARK
			2 = DMA BOUNDARY
			3 = END OF CYLINDER
			4 = NOT READY
			5 = NOT WRITABLE
			6 = EQUIPMENT CHECK
			7 = EQUIPMENT CHECK SEEK
			8 = OVER RUN
			9 = TIME OUT
			A = DATA ERROR (ID)
			B = DATA ERROR (DATA)
			C = NO DATA
			D = BAD CYLINDER
			E = MISSING ADDRESS MARK (ID)
			F = MISSING ADDRESS MARK (DATA)
		BIT 1,0 : HARD DISK CAPACITY
			0 = 5 MB
			1 = 10MB
			2 = 15MB
			3 = 20MB

HISTORY
	MAR/21/84	PROCEDUE.
	APR/05/84	LINK FDROM
	apr/18/84	del bug
	APR/20/84	DEL BUG
	APR/23/84
	APR/26/84	DEL BUG	(BOOT LOADER)
	MAY/08/84	SUPPORT 20MB HD
	MAY/10/84	INC WAIT TIME
		\				; END COMMENT
	SUBTTL	"DEFINE"
		PAGE
;************************************************
;*						*
;*	EXTERNAL/PUBLIC SYMBOL			*
;*						*
;************************************************
;*
;**	PUBLIC
;*
		PUBLIC	H5_INIT			; H/D INTIALIZE
		PUBLIC	H5_ENTR			; H/D REQUEST
;*
;**	EXTRN
;*
		EXTRN	DISK_EXIT:NEAR	;------INS--------APR/05/84-
		PAGE
;************************************************
;*						*
;*	DEFINE CONSTANT AND INITIAL VALUE	*
;*						*
;************************************************
;****************************************
;*	MACRO				*
;****************************************
@WAITOF		MACRO	?PORT,?BIT,?BADR	; WAIT UNTIL BIT OF I/O PORT OFF
		LOCAL	X
			XOR	CX,CX
X:
			IN	AL,?PORT
			TEST	AL,?BIT
			LOOPNZ	X
			JNZ	?BADR
		ENDM

@WAITON		MACRO	?PORT,?BIT,?BADR	; WAIT UNTIL BIT OF I/O PORT ON
		LOCAL	X
			XOR	CX,CX
X:
			IN	AL,?PORT
			TEST	AL,?BIT
			LOOPZ	X
			JZ	?BADR
		ENDM

@OUT		MACRO	?PORT,?DATA		; DATA OUTPUT TO I/O PORT
			MOV	AL,?DATA
			OUT	?PORT,AL
		ENDM

@IN		MACRO	?PORT,?DATA		; DATA INPUT FROM I/O PORT
			IN	AL,?PORT
			MOV	?DATA,AL
		ENDM

@WAITPH		MACRO	?PHASE,?BADR
		LOCAL	X
			XOR	CX,CX
X:
			IN	AL,DSK_CSR
			AND	AL,PHASE_MASK
			CMP	AL,?PHASE
			LOOPNZ	X
			JNZ	?BADR
		ENDM

@PUSH		MACRO	?A
		IRP	?B,<?A>
			PUSH	?B
		ENDM
		ENDM

@POP		MACRO	?A
		IRP	?B,<?A>
			POP	?B
		ENDM
		ENDM
		PAGE
;****************************************
;*	STRUCTURE			*
;****************************************
STACREG		STRUC
HDUADA		DB	?		; DEVICE KIND / UNIT NUMBER (AL)
HDCMD		DB	?		; COMMAND CODE / RETURN INF. (AH)
HDLNG		DW	?		; DATA BYTE LENGTH (BX)
HDCYL		DW	?		; CYLINDER NUMBER	(CX)
HDSEC		DB	?		; SECTOR	NUMBER	(CL)
HDHED		DB	?		; HEADER	NUMBER	(DH)
HDADR		DD	?		; DATA STORE ADDRESS (ES:BP)
		DW	?		; (DI)
		DW	?		; (SI)
		DW	?		; (DS)
		DD	?		; RETURN ADDRESS (CS:IP)
HDFLG		DW	?		;
STACREG		ENDS

DCBLOCK		STRUC
DCBCMD		DB	?		; COMMAND CLASS / OPCODE
DCBHED		DB	?		; DRIVE / HEAD NUMBER
DCBSEC		DB	?		; CYLINDER HIGH / SECTOR NUMBER
DCBCYL		DB	?		; CYLINDER LOW
DCBRNO		DB	?		; INTERLEAVE OR BLOCK COUNT
DCBRTY		DB	?		; CONTROL FIELD
DCBLOCK		ENDS

HDGET		STRUC
HDSTATUS	DB	?		; STATUS
HDSENSE		DB	4 DUP (?)	; SENSE BYTE
HDGET		ENDS
;----------------------------------------------------INSERT MAY/08/84--
HD_PARM		STRUC
P_CAP		DB	?		; CAPACITY OF HD
P_CYL		DW	?		; MAX CYLINDER NUMBER
P_HED		DB	?		; MAX HEAD	NUMBER
P_PWR		DW	?		; ELEMENT POWER
HD_PARM		ENDS
;----------------------------------------------------------------------
		PAGE
;****************************************
;*	SYMBOL AND LABEL		*
;****************************************
;
;*	I/O PORT
;
DSK_CCR		EQU	82H		; COMMAND	REG.(CPU-->FARM)
DSK_CSR		EQU	82H		; STATUS	REG.(FARM-->CPU)
DSK_IDR		EQU	80H		; INPUT DATA	REG.(FARM==>CPU)
DSK_ODR		EQU	80H		; OUTPUT DATA	REG.(CPU==>FARM)
;*
;**	RETURN INF./ ERROR CODE
;*
ERR_NONE	EQU	00H		; NORMAL END
ERR_CM		EQU	10H		; CONTROL MARK
ERR_DMA_B	EQU	20H		; DMA BOUNDARY
ERR_EOC		EQU	30H		; END OF CYLI
ERR_NR		EQU	40H		; NOT READY
ERR_WP		EQU	50H		; WRITE PROTECT
ERR_EC		EQU	60H		; EQIPMENT CHECK
ERR_ECS		EQU	70H		; EQIPMENT CHECK ON SEEK
ERR_OR		EQU	80H		; OVER RUN
ERR_TO		EQU	90H		; TIME OUT
ERR_ID		EQU	0A0H		; DATA ERROR (ID)
ERR_DATA	EQU	0B0H		; DATA ERROR (DATA)
ERR_ND		EQU	0C0H		; NO DATA
ERR_BC		EQU	0D0H		; BAD CYLINDER
ERR_MAMID	EQU	0E0H		; MISSING ADDRESS MARK (ID)
ERR_MAMDATA	EQU	0F0H		; MISSING ADDRESS MARK (DATA)
;*
;**	OPCODE OF H/D CONTROLLER
;*
OP_DRDY		EQU	00H		; TEST DEVICE READY
OP_RCAL		EQU	01H		; RECALIBRATE
OP_SENS		EQU	03H		; REQUEST SENSE STATUS
OP_FMTD		EQU	04H		; FORMAT DRIVE
OP_VRFY		EQU	05H		; READY VERIFY
OP_FMTT		EQU	06H		; FORMAT TRACK
OP_FMTB		EQU	07H		; FORMAT BAD TRACK
OP_READ		EQU	08H		; READ
				;
OP_WRIT		EQU	0AH		; WRITE
OP_SEEK		EQU	0BH		; SEEK
OP_INIT		EQU	0CH		; INITIALIZE DRIVE
OP_RECC		EQU	0DH		; READ ECC BURST ERROR LENGTH
OP_RBUF		EQU	0EH		; READ DATA FROM RAM BUFFER
OP_WBUF		EQU	0FH		; WRITE DATA TO RAM BUFFER
OP_RAMD		EQU	0E0H		; RAM DIAGNOSTIC
OP_ROMD		EQU	0E4H		; ROM DIAGNOSTIC
				;
OP_DRVD		EQU	0E3H		; DRIVE DIAGNOS
;*
;**	DMA MODE
;*
DMA_READ	EQU	44H
DMA_WRIT	EQU	48H
DMA_VRFY	EQU	40H
;*
;**	BIT OF CHANEL CONTROL REGISTER
;*
CCR_INTE	EQU	00000001B	; INT ENABLE
CCR_DMAE	EQU	00000010B	; DMA ENABLE
CCR_RST		EQU	00001000B	; RESET
CCR_SEL		EQU	00100000B	; SELECT
;*
;**	BIT OF CHANEL STATUS
;*
CSR_INT		EQU	00000001B	; INTERRUPT
CSR_IN		EQU	00000100B	; DATA FORM ADAPTER TO HOST
CSR_CMD		EQU	00001000B	; COMMAND/DATA
CSR_MSG		EQU	00010000B	; MESSAGE
CSR_BSY		EQU	00100000B	; BUSY
CSR_REQ		EQU	10000000B	; DATA I/O REQUEST
COMMAND_PHASE	EQU	CSR_REQ+CSR_BSY+CSR_CMD
DATAOUT_PHASE	EQU	CSR_REQ+CSR_BSY
DATAIN_PHASE	EQU	CSR_REQ+CSR_BSY	+CSR_IN
STATUS_PHASE	EQU	CSR_REQ+CSR_BSY+CSR_CMD+CSR_IN
FREE_PHASE	EQU	0
PHASE_MASK	EQU	CSR_REQ+CSR_BSY+CSR_CMD+CSR_IN
;*
;**	BIT OF INTERRUPT
;*
HD_MASK		EQU	02H		; H/D INTERRUPT MASK
;*
;**
;*
MAX_CYL1	EQU	310		; END OF CYLINDER NUMBER (MAY/08/84)
MAX_CYL2	EQU	612		; END OF CYLINDER NUMBER (MAY/08/84)
MAX_HED		EQU	4		; NUMBER OF HEADS
MAX_SEC		EQU	17		; NUMBER OF SECTORS IN TRACK
SEC_SIZE	EQU	512		; SECTOR BYTE LENGTH
SEC_SHIFT	EQU	9		; LOG(2)512
INTERLIEVE	EQU	1		;
STEP_OPTION	EQU	0		;
HD_TYPE10	EQU	01B		; KIND OF H/D	(10MB)
HD_TYPE20	EQU	11B		; KIND OF H/D	(20MB)---MAY/08/84
HD_INT		EQU	11H		; HD INTERRUPT VECTOR

INCLUDE B:EQCOM.LIB
		PAGE
;************************************************
;*						*
;*	OTHOR SEGMENT				*
;*						*
;************************************************

;****************************************
;*	INTERRUPT VECTOR		*
;****************************************
INTVEC		SEGMENT AT 0000H	;
		ORG	HD_INT*4	; H/D HARDWARE INTERRUPT
HD_OFFSET	DW	?
HD_SEGMENT	DW	?
INTVEC		ENDS
;****************************************
;*	DATA SEGMENT			*
;****************************************
INCLUDE B:SYSCOM.LIB
;-----------------------------------------------------DELETE APR/23/84-
	SUBTTL	"CONSTANT DATA"
		PAGE
;************************************************
;*						*
;*		PROGRAM SEGMENT			*
;*						*
;************************************************
ROM		SEGMENT WORD PUBLIC
		ASSUME	CS:ROM,DS:SYSCOM,ES:SYSCOM,SS:ROM
;****************************************
;*	CONSTANT DATA			*
;****************************************
;*
;**	COMMAND BRANCH TABLE
;*
CMD_BRANCH	LABEL	WORD
		DW	HD_NOP		; NO OPERATION
		DW	HD_VRFY		; VERIFY DATA
		DW	HD_DIAG		; READ DIAGNOSTIC
		DW	INIT_CMD	; INITIALIZE------MAY/08/84----
		DW	HD_SENS		; SENSE
		DW	HD_WRIT		; WRITE DATA
		DW	HD_READ		; READ DATA
		DW	HD_RCAL		; RECALIBRATE
		DW	HD_NOP		; NO OPERATION
		DW	HD_WRIT		; WRITE DELETED DATA
		DW	HD_NOP		; READ ID
		DW	HD_NOP		; NO OPERATION
		DW	HD_READ		; READ DELETED DATA
		DW	HD_FORM		; WRITE ID
		DW	HD_NOP		; NO OPERATION
		DW	HD_RTRC		; RETRACT
;*
;**	INITIAL COMMAND DATA
;*
;---------------------------------------------------INSERT MAY/08/84---
INIT_DATA1	LABEL	BYTE
		DB	HD_TYPE10
		DB	HIGH MAX_CYL1	; MAX CYLINDER (HIGH)
		DB	LOW  MAX_CYL1	; MAX CYLINDER (LOW)
		DB	MAX_HED		; MAX HEAD
		DB	128		; START CYLINDER (HIGH)
		DB	0		; START CYLINDER (LOW)
INIT_DATAC	LABEL	BYTE
		DB	0		; START PRECOMPENSATION CYLINDER (HIGH)
		DB	0		; START PRECOMPENSATION CYLINDER (LOW)
		DB	0BH		; MAX ECC ERROR BURST LENGTH
INIT_DATA2	LABEL	BYTE
		DB	HD_TYPE20
		DB	HIGH MAX_CYL2	; MAX CYLINDER (HIGH)
		DB	LOW  MAX_CYL2	; MAX CYLINDER (LOW)
		DB	MAX_HED		; MAX HEAD
		DB	0		; START CYLINDER (HIGH)
		DB	1		; START CYLINDER (LOW)
;----------------------------------------------------------------------
;****************************************
;*	SENSE BYTE ---> ERROR CODE	*
;****************************************
ERR_TABLE	LABEL	BYTE	; TYPE 0
		DB	ERR_NONE	; NORMAL END
		DB	ERR_EC		; NO INDEX SIGNAL
		DB	ERR_EC		; NO SEEK COMPLETE
		DB	ERR_EC		; WRITE FAULT
		DB	ERR_NR		; DRIVE NOT READY
		DB	ERR_EC		; DEVICE NOT SELECTED
		DB	ERR_EC		; 0 TRACK
		DB	ERR_EC

		DB	ERR_ECS		; SEEK IN PROGRESS
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
;				; TYPE 1
		DB	ERR_ID		; ID READ ERROR
		DB	ERR_DATA	; UNCORRECTABLE DATA ERROR DURING READ
		DB	ERR_MAMID	; ADDRESS MARK NOT FOUND
		DB	ERR_EC		;
		DB	ERR_ND		; SECTOR NOT FOUND
		DB	ERR_ECS		; SEEK ERROR
		DB	ERR_EC
		DB	ERR_EC

		DB	ERR_CM		; CORRECTABLE DATA ERROR
		DB	ERR_BC		; BAD TRACK
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
;				; TYPE 2
		DB	ERR_EC		; INVALID COMMAND
		DB	ERR_ND		; ILLEGAL DISK ADDRESS
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC

		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
;				; TYPE 3
		DB	ERR_EC		; RAM ERROR
		DB	ERR_EC		; PROGRAM MEMORY CHECKSUM ERROR
		DB	ERR_EC		; ECC POLYNOMINAL ERROR
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC

		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
		DB	ERR_EC
	SUBTTL	"PROGRAM"
		PAGE
;************************************************************************
;*									*
;*	MODULE		INTIARIZE					*
;*									*
;*	FUNCTION	INITIARIZATION OF H/D DEVICE,CONTROLLER,DRIVER. *
;*									*
;*	INPUT		NONE						*
;*									*
;*	OUTPUT		NONE						*
;*									*
;*	REMARK		THIS ROUTINE CALLED FROM "BOOT START"		*
;*			FOR INTIARIZATION BEFORE READ BOOT SECTOR.	*
;*									*
;*									*
;************************************************************************
H5_INIT		PROC	NEAR
;
;	SET INITIAL VALUE TO WORK AREA
;
		MOV	AX,INTVEC
		MOV	DS,AX
		ASSUME	DS:INTVEC
						; SET INTERRUPT VECTOR
		MOV	[HD_OFFSET],OFFSET HD_INTR
		MOV	[HD_SEGMENT],CS
		MOV	AX,SYSCOM
		MOV	DS,AX
		ASSUME	DS:SYSCOM
						; RESET INTERRUPT HAPPEN
		AND	BYTE PTR [DISK_INT+1],0F0H
		AND	BYTE PTR [DISK_EQUIP+1],0F0H
;------------------------------------------------------INSERT MAY/08/84
;
;*	SET INITIAL VALUE OF PARAMETER
;
		PUSH	DS
		POP	ES
		PUSH	CS
		POP	DS
		MOV	SI,OFFSET INIT_DATA1
		MOV	DI,OFFSET HD_PARAM0
;		IN	AL,PORTA
;		TEST	AL,04H
;		JZ	HD_RST05
;		MOV	SI,OFFSET INIT_DATA2
HD_RST05:
		MOV	CX,SIZE HD_PARM
		REP	MOVSB

		MOV	SI,OFFSET INIT_DATA1
		MOV	DI,OFFSET HD_PARAM1
;		TEST	AL,08H
;		JZ	HD_RST06
;		MOV	SI,OFFSET INIT_DATA2
HD_RST06:
		MOV	CX,SIZE HD_PARM
		REP	MOVSB

		PUSH	ES
		POP	DS
;----------------------------------------------------------------------
;
;	RESET H/D DEVICE, ADAPTER, DMA
;
		CALL	HD_INIT
		JNZ	HD_RST30		; IF NOT CONNECT (APR/18/84)
;
;	CHECK H/D DEVICE READY
;
		MOV	[HD_DCB.DCBHED],0
		MOV	[HD_DCB.DCBRTY],STEP_OPTION
		CALL	HD_RCAL			; UNIT 0 RECALIBRATE
		JNZ	HD_RST10		; UNIT 0 ERROR ?
		OR	BYTE PTR [DISK_EQUIP+1],01H
HD_RST10:
		MOV	[HD_DCB.DCBHED],1 SHL 5
		CALL	HD_RCAL			; UNIT 1 RECALIBRATE
		JNZ	HD_RST20		; UNIT 1 ERROR ?
		OR	BYTE PTR [DISK_EQUIP+1],02H
HD_RST20:
		MOV	AH,ERR_NONE
HD_RST30:
		RET
H5_INIT		ENDP
		PAGE
;************************************************************************
;*									*
;*	MODULE		HARDWARE INTERRUPT				*
;*									*
;*	FUNCTION	H/D HARDWARE INTERRUPT RESET			*
;*									*
;*	INPUT		NONE						*
;*									*
;*	OUTPUT		NONE						*
;*									*
;*	REMARK		H/D INTERRUPT HAPPENED FROM H/D CONTROLLER	*
;*			BY COMMAND COMPLET.				*
;*									*
;************************************************************************
HD_INTR		PROC	FAR
;
;	END OF INTERRUPT
;
		@PUSH	<AX,CX,DS>
		MOV	AX,SYSCOM
		MOV	DS,AX
		@OUT	INTS_O2,EOI		; OUTPUT EOI (SLAVE)
		@OUT	INTS_O3,0BH
		IN	AL,INTS_IS		; ISR READ
		TEST	AL,0FFH			; SLAVE EMPTY ?
		JNZ	HD_INTR20
		@OUT	INTM_O2,EOI		; OUTPUT EOI (MASTER)
HD_INTR20:
;
;	COMMAND COMPLETE
;
		STI
;		IN	AL,DSK_CSR		; INTERRUPT HAPPEN ?
;		TEST	AL,CSR_INT
;		JZ	HD_INTR50
		@WAITPH STATUS_PHASE,HD_INTR50
;
		@IN	DSK_IDR,[HD_DCB.DCBCMD]	; READ HDC STATUS
;
		OR	BYTE PTR [DISK_INT+1],01H
						; SET INTERRUPT HAPPEN
HD_INTR50:
		@POP	<DS,CX,AX>
		IRET
HD_INTR		ENDP
		PAGE
;************************************************************************
;*									*
;*	MODULE		MAIN ROUTINE					*
;*									*
;*	FUNCTION	PROCEDURE I/O REQUEST FROM HOST ROUTINE.	*
;*									*
;*	INPUT		SS:BP=PARAMETER ADDRESS IN STACK		*
;*									*
;*									*
;*	OUTPUT		NONE						*
;*									*
;*									*
;*	REMARK		HOST ROUTINE CALL BY INT 1DH.			*
;*									*
;************************************************************************
H5_ENTR		LABEL	NEAR
HD_MAIN		PROC	NEAR
		MOV	BX,SYSCOM		; SET SEGMENT REG.
		MOV	DS,BX
		MOV	ES,BX
		CALL	SET_DCB			; MAKE DATA CONTROL BLOCK
		MOV	BL,[BP.HDCMD]		; BX= COMMAND CODE * 2
		MOV	BH,00H
		AND	BL,0FH
		SHL	BL,1
		CALL	CS:CMD_BRANCH[BX]	; BRANCH ANY ROUTINE

		MOV	AL,[BP.HDCMD]
		AND	AL,0FH
		CMP	AL,04H			; SENSE COMMAND
		JNZ	HD_MAIN50
;-------------------------------------------------INSERT MAT/08/84----
		MOV	AL,[HD_PARAM0.P_CAP]
		TEST	[BP.HDUADA],01H		; UNIT#0 ?
		JZ	HD_MAIN40		; Y
		MOV	AL,[HD_PARAM1.P_CAP]
HD_MAIN40:
		OR	AH,AL			; SET HD TYPE
;---------------------------------------------------------------------
HD_MAIN50:
		JMP	DISK_EXIT
HD_MAIN		ENDP
;-----------------------------------------------DEL APR/05/84---------


HD_NOP		PROC	NEAR
		MOV	AH,ERR_NONE		; NORMAL END
		RET
HD_NOP		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		INITIALIZE COMMAND			*
;*								*
;*	FUNCTION	INITIALIZE H/D DEVICE AND CONTROLLER.	*
;*								*
;*	INPUT		SS:BP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE			*
;*								*
;*								*
;****************************************************************
HD_INIT		PROC	NEAR
;
;	H/D CONTROLLER RESET
;
		@OUT	DSK_CCR,CCR_RST 	; RESET H/D ADAPTER
		PUSH	AX			; TIME DELAY (10US)
		POP	AX
		@OUT	DSK_CCR,0
		@WAITPH FREE_PHASE,HD_INIT9
;
;	INTERRUPT ENABLE
;
		CLI				; CHG APR/18/84
		IN	AL,INTS_I2		; OPEN INTERRUPT MASK OF H/D
		AND	AL,NOT HD_MASK
		OUT	INTS_O1,AL
		STI
;----------------------------------------------------DELETE MAY/10/84--
		AND	[HD_DCB.DCBHED],NOT (1 SHL 5)
		CALL	INIT_CMD
		OR	[HD_DCB.DCBHED],1 SHL 5
		CALL	INIT_CMD		; INITIALIZE HD ADAPTER AND DEVICE
HD_INIT8:
		TEST	AH,AH			; SET ZF (INS APR/18/84)
		RET
HD_INIT9:
		MOV	AH,ERR_TO
		JMP	HD_INIT8
HD_INIT		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		SENSE COMMAND				*
;*								*
;*	FUNCTION	SENSE H/D STATUS AND H/D TYPE.		*
;*								*
;*	INPUT		SS:BP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE AND H/D CAPACITY	*
;*								*
;*								*
;****************************************************************
HD_SENS		PROC	NEAR
		MOV	AH,OP_DRDY
		JMP	SHORT NO_DATA_CMD
HD_SENS		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		RECALIBRATE COMMAND			*
;*								*
;*	FUNCTION	HEAD RETURN TO HOME POSITION.		*
;*			(0 CYLINDER)				*
;*								*
;*	INPUT		SS:BP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE			*
;*								*
;*								*
;****************************************************************
HD_RCAL		PROC	NEAR
		MOV	AH,OP_RCAL
		JMP	SHORT NO_DATA_CMD
HD_RCAL		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		WRITE ID COMMAND			*
;*								*
;*	FUNCTION	FORMAT ONE TRACK.			*
;*								*
;*	INPUT		SS:BP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE			*
;*								*
;*								*
;****************************************************************
HD_FORM		PROC	NEAR
		MOV	AH,OP_FMTT		; MAKE FORMAT COMMAND BLOCK
		AND	[HD_DCB.DCBSEC],NOT 1FH
		MOV	[HD_DCB.DCBRNO],INTERLIEVE
		JMP	SHORT NO_DATA_CMD
HD_FORM		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		RETRACK COMMAND				*
;*								*
;*	FUNCTION	HEAD MOVE TO CYLINDER OF READ OR WRITE	*
;*			DISABLE.				*
;*								*
;*	INPUT		SS:BP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE			*
;*								*
;****************************************************************
HD_RTRC		PROC	NEAR
		MOV	AH,OP_SEEK		; MAKE SEEK COMMAND BLOCK
		AND	[HD_DCB.DCBHED],NOT 1FH
;------------------------------------------------------CHANGE MAY/08/84
		MOV	CX,[HD_PARAM0.P_CYL]
		TEST	[BP.HDUADA],01H		; UNIT#0 ?
		JZ	HD_RTRC2
		MOV	CX,[HD_PARAM1.P_CYL]
HD_RTRC2:
		ADD	CX,30			; GET RETACT POSITION
		MOV	[HD_DCB.DCBCYL],CL	; SET CYLINDER NUMBER (LOW)
		MOV	CL,6
		SHL	CH,CL
		MOV	[HD_DCB.DCBSEC],CH	; SET CYLINDER NUMBER (HIGH)
;----------------------------------------------------------------------
		JMP	SHORT NO_DATA_CMD
HD_RTRC		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		HD DIAGNOSTIC			*
;*							*
;*	FUNCTION	HARD DISK ADAPTER DIAGNOSTIC	*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		AH =	ERROR CODE		*
;*							*
;********************************************************
HD_DIAG		PROC	NEAR
		MOV	[HD_DCB.DCBHED],0
		MOV	[HD_DCB.DCBRTY],STEP_OPTION
		MOV	AH,OP_RAMD
		CALL	NO_DATA_CMD
		JNZ	HD_DIAG80
		MOV	AH,OP_ROMD
		CALL	NO_DATA_CMD
		JNZ	HD_DIAG80
		MOV	AH,OP_DRVD
		CALL	NO_DATA_CMD
HD_DIAG80:
		RET
HD_DIAG		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		VERIFY COMMAND				*
;*								*
;*	FUNCTION	SCAN DATA AT SECTOR OF H/D		*
;*								*
;*	INPUT		SS:BP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE			*
;*								*
;*								*
;****************************************************************
HD_VRFY		PROC	NEAR
		MOV	AH,OP_VRFY
		JMP	SHORT NO_DATA_CMD
HD_VRFY		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		WRITE COMMAND				*
;*								*
;*	FUNCTION	WRITE DATA TO SECTOR OF H/D.		*
;*								*
;*	INPUT		SS:SP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE			*
;*								*
;*								*
;****************************************************************
HD_WRIT		PROC	NEAR
		MOV	AH,OP_WRIT
		MOV	AL,DMA_WRIT
		JMP	SHORT WITH_DMA_CMD
HD_WRIT		ENDP
		PAGE
;****************************************************************
;*								*
;*	MODULE		READ COMMAND				*
;*								*
;*	FUNCTION	READ DATA FROM SECTOR OF H/D		*
;*								*
;*	INPUT		SS:SP=PARAMETER ADDRESS IN STACK	*
;*								*
;*	OUTPUT		AH =	ERROR CODE			*
;*								*
;*								*
;****************************************************************
HD_READ		PROC	NEAR
		TEST	[HD_DCB.DCBRTY],80H	; RETRY ENABLE ?
		JZ	HD_READ20
		OR	[HD_DCB.DCBRTY],40H	; ECC ERROR CORRECTION
HD_READ20:
		MOV	AH,OP_READ
		MOV	AL,DMA_READ
		JMP	SHORT WITH_DMA_CMD
HD_READ		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		COMMAND COMMON WITHIN DMA	*
;*							*
;*	FUNCTION	REQUEST COMMAND WITHIN DMA	*
;*			TO HD-ADAPTER.			*
;*							*
;*	INPUT		ES:BP=PARAMETER ADDRESS		*
;*			AL = DMA MODE			*
;*			AH = OPERATE CODE		*
;*							*
;*	OUTPUT		AH = ERROR CODE			*
;*							*
;********************************************************
WITH_DMA_CMD	PROC	NEAR
		MOV	[HD_DCB.DCBCMD],AH	; SET OPERATE CODE TO DCB
		CALL	SET_DMA			; SET DMA
		MOV	AL,CCR_INTE+CCR_DMAE	; AL = SELECT MODE
		JMP	SHORT CMD_COMMON
WITH_DMA_CMD	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		COMMAND COMMON WITHOUT DATA	*
;*							*
;*	FUNCTION	REQUEST COMMAND WITHOUT DATA	*
;*			TO HD-ADAPTER.			*
;*							*
;*	INPUT		ES:BP=PARAMETER ADDRESS		*
;*			AH =	OPERATE CODE		*
;*							*
;*	OUTPUT		AH =	ERROR CODE		*
;*							*
;********************************************************
NO_DATA_CMD	PROC	NEAR
		MOV	[HD_DCB.DCBCMD],AH	; SET OPERATE CODE TO DCB
		MOV	AL,CCR_INTE		; AL = SELECT MODE
NO_DATA_CMD	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		COMMAND COMMON			*
;*							*
;*	FUNCTION	REQUEST COMMAND TO HD-ADAPTER	*
;*							*
;*	INPUT		AL =	SELECT MODE		*
;*			BIT 0 = INT ENABLE		*
;*			BIT 1 = DMA ENABLE		*
;*							*
;*	OUTPUT		AH =	ERROR CODE		*
;*							*
;********************************************************
CMD_COMMON	PROC	NEAR
		CALL	CMD_OUT			; SELECT AND COMMAND OUT
		JNZ	CMD_C10
		CALL	WAIT_INTR		; WAIT COMMAND COMPLETE INTERRUPT
CMD_C10:
;		JMP	SHORT ERR_CHECK
CMD_COMMON	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		ERROR CHECK			*
;*							*
;*	FUNCTION	REQUEST SENSE COMMAND.		*
;*			RESET HD-ADAPTER.		*
;*							*
;*	INPUT		SS:BP =	PARAMETER ADDRESS	*
;*	OUTPUT		AH =	ERROR CODE		*
;*							*
;********************************************************
ERR_CHECK	PROC	NEAR
;
;	ERROR CHECK
;
		CMP	AH,ERR_NONE		; ERROR FOUND ?
		JNZ	ERR_CHK70
		TEST	[HD_DCB.DCBCMD],02H	; ERROR END ?
		JZ	ERR_CHK90
;
;	STATUS SENSE FOR ERROR SORT
;
		MOV	[HD_DCB.DCBCMD],OP_SENS ; MAKE SENSE DCB
		MOV	AL,0
		CALL	CMD_OUT			; OUTPUT COMMAND
		JNZ	ERR_CHK70
		MOV	DI,OFFSET HD_DCB.HDSENSE
		MOV	CX,4
ERR_CHK40:
		CALL	DATA_IN			; READ SENSE BYTE
		JNZ	ERR_CHK70
		@WAITPH STATUS_PHASE,ERR_CHK70	; WAIT COMMAND COMPLETE
		@IN	DSK_IDR,[HD_DCB.DCBCMD] ; INPUT STATUS
;		@WAITON DSK_CSR,CSR_MSG,ERR_CHK70
;		IN	AL,DSK_IDR
;		@WAITPH FREE_PHASE,ERR_CHK70
;
;	SENSE BYTE CONVERT TO ERROR CODE
;
		MOV	BX,OFFSET ERR_TABLE
		MOV	AL,[HD_DCB.HDSENSE]	;---CHG APR/20/84------
		AND	AL,3FH
;---------------------------------------------------INSET APR/20/84----
		CMP	AL,21H			; ILLEGAL ADDRESS ?
		JNZ	ERR_CHK60
		MOV	AH,[BP.HDCMD]
		AND	AH,0FH
		CMP	AH,0FH			; RETRACT ?
		JNZ	ERR_CHK60
		MOV	AL,0			; NOT ERROR
ERR_CHK60:
;---------------------------------------------------------------------
		XLAT	CS:[BX]			; AL=ERR_TABLE[AL] = ERROR CODE
		MOV	AH,AL
;
;	RESET HD ADAPTER
;
ERR_CHK70:	CMP	AH,ERR_TO		; ADAPTER ERROR ?
		JNZ	ERR_CHK90
		@OUT	DSK_CCR,CCR_RST 	; RESET
		PUSH	AX
		POP	AX
		@OUT	DSK_CCR,0
ERR_CHK90:
		RET
ERR_CHECK	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		COMMAND OUTPUT			*
;*							*
;*	FUNCTION	SELECT. (SELECT PHASE)		*
;*			OUT PUT CONTROL BLOCK 6BYTES.	*
;*			(COMMAND PHASE)			*
;*	INPUT		AL =	SELECT MODE		*
;*			BIT 0 = DMA ENABLE		*
;*			BIT 1 = INT ENABLE		*
;*							*
;*	OUTPUT		Z-FLAG	ON = ERROR FOUND	*
;*				OFF= NORMAL END		*
;*							*
;*			AH =	ERROR CODE		*
;*							*
;********************************************************
CMD_OUT		PROC	NEAR
		MOV	AH,AL
;
;	SELECT HD ADAPTER
;
		@WAITOF DSK_CSR,CSR_BSY,CMD_OUT90
						; WAIT BUSY OFF
		@OUT	DSK_ODR,01H		; OUT CONTROLLER #
		@OUT	DSK_CCR,CCR_SEL		; SELECT
;----------------------------------------------------INSERT MAY/10/84--
		MOV	DL,8*3+1		; WAIT COUNT = 3 SEC.
CMD_OUT10:
		DEC	DL
		JZ	CMD_OUT90
		@WAITON	DSK_CSR,CSR_BSY,CMD_OUT10
;----------------------------------------------------------------------
		@OUT	DSK_CCR,0		; SELECT OUT
		MOV	SI,OFFSET HD_DCB
		MOV	DL,6
CMD_OUT30:
		@WAITPH COMMAND_PHASE,CMD_OUT90	; WAIT REQUEST
		LODSB
		OUT	DSK_ODR,AL		; COMMAND OUT
		DEC	DL
		JNZ	CMD_OUT30
;----------------------------------------------------MOVE APR/20/84----
		TEST	AH,CCR_DMAE
		JZ	CMD_OUT60
		@OUT	DMA_SMR,0		; DMA START
CMD_OUT60:
		@OUT	DSK_CCR,AH
;----------------------------------------------------------------------
CMD_OUT70:
		MOV	AH,ERR_NONE
CMD_OUT80:
		TEST	AH,AH
		RET
CMD_OUT90:
		MOV	AH,ERR_TO
		JMP	CMD_OUT80
CMD_OUT		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		WAIT COMMAND COMPLETE.		*
;*							*
;*	FUNCTION	WAIT H/D INTERRUPT.		*
;*			COMMAND COMPLETE.		*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		Z-FLAG	ON =ERROR FOUND		*
;*				OFF=NORMAL END		*
;*							*
;*			AH =	ERROR CODE		*
;*							*
;********************************************************
WAIT_INTR	PROC	NEAR
		MOV	DL,5*15			; DL = LOOP COUNTER (15SEC)
		TEST	BYTE PTR [BIOS_FLAG+1],80H
						; 8MHZ CPU ?
		JNZ	WAIT20
		MOV	DL,8*15			;------CHANGE MAY/10/84
WAIT20:
		XOR	CX,CX
WAIT30:						; INTERRUPT HAPPEN ?
		TEST	BYTE PTR [DISK_INT+1],01H
		LOOPZ	WAIT30
		JNZ	WAIT50
		DEC	DL
		JNZ	WAIT20			; TIME OUT ?
		JMP	SHORT WAIT90
WAIT50:
						; RESET FLAG
		AND	BYTE PTR [DISK_INT+1],NOT 01H
;		@WAITON DSK_CSR,CSR_MSG,WAIT90
;		IN	AL,DSK_IDR
;		@WAITPH FREE_PHASE,WAIT90
		@OUT	DMA_SMR,04H		; DMA RESET
		MOV	AH,ERR_NONE
WAIT80:
		TEST	AH,AH
		RET
WAIT90:
		MOV	AH,ERR_TO
		JMP	WAIT80
WAIT_INTR	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		INITIALIZE COMMAND		*
;*							*
;*	FUNCTION	REQUEST INITIALISE COMMAND TO	*
;*			HD-ADAPTER			*
;*							*
;*	INPUT		NONE				*
;*							*
;*	OUTPUT		AH =	ERROR CODE		*
;*							*
;********************************************************
INIT_CMD	PROC	NEAR
		MOV	[HD_DCB.DCBCMD],OP_INIT	; MAKE INIT DCB
		MOV	AL,0
		CALL	CMD_OUT			; OUTPUT COMMAND
		JNZ	INIT_CMD70
;--------------------------------------------------CHANGE MAY/08/84----
		MOV	SI,OFFSET HD_PARAM0.P_CYL
		TEST	[HD_DCB.DCBHED],20H	; UNIT#0 ?
		JZ	INIT_CMD20		; Y
		MOV	SI,OFFSET HD_PARAM1.P_CYL
INIT_CMD20:
		MOV	CX,5
		CALL	DATA_OUT		; OUTPUT PARAMETER
		JNZ	INIT_CMD70
		PUSH	DS
		PUSH	CS
		POP	DS
		MOV	SI,OFFSET INIT_DATAC
		MOV	CX,3
		CALL	DATA_OUT		; OUTPUT PARAMETER
		POP	DS
		JNZ	INIT_CMD70
;----------------------------------------------------------------------
		@WAITPH STATUS_PHASE,INIT_CMD70	; WAIT COMMAND COMPLETE
		@IN	DSK_IDR,[HD_DCB.DCBCMD]	; STATUS INPUT
;		@WAITON DSK_CSR,CSR_MSG,INIT_CMD70
;		IN	AL,DSK_IDR
;		@WAITPH FREE_PHASE,INIT_CMD70
		MOV	AH,ERR_NONE
INIT_CMD70:
		RET
INIT_CMD	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		OUTPUT DATA			*
;*							*
;*	FUNCTION	OUTPUT DATA TO HD-ADAPTER.	*
;*							*
;*	INPUT		DS:SI=DATA STORE ADDRESS	*
;*			CX =	DATA BYTE LENGTH	*
;*							*
;*	OUTPUT		AH =	RETURN CODE		*
;*							*
;********************************************************
DATA_OUT	PROC	NEAR
		MOV	AH,ERR_TO
		MOV	DX,CX
DATA_OUT30:
		@WAITPH DATAOUT_PHASE,DATA_OUT80
						; WAIT REQUEST
		LODSB
		OUT	DSK_ODR,AL		; OUTPUT TO HD ADAPTER
		DEC	DX
		JNZ	DATA_OUT30
		MOV	AH,ERR_NONE
DATA_OUT80:
		TEST	AH,AH
		RET
DATA_OUT	ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		INPUT DATA			*
;*							*
;*	FUNCTION	INPUT DATA FROM HD-ADAPTER	*
;*							*
;*	INPUT		ES:DI=DATA STORE ADDRESS	*
;*			CX =	DATA BYTE LENGTH	*
;*							*
;*	OUTPUT		Z-FLAG	ON =ERROR FOUND		*
;*				OFF=NORMAL END		*
;*							*
;*			AH =	ERROR CODE		*
;*							*
;********************************************************
DATA_IN		PROC	NEAR
		MOV	AH,ERR_TO
		MOV	DX,CX
DATA_IN30:
		@WAITPH DATAIN_PHASE,DATA_IN80	; WAIT REQUEST
		IN	AL,DSK_IDR		; INPUT FROM HD ADAPTER
		STOSB
		DEC	DX
		JNZ	DATA_IN30
		MOV	AH,ERR_NONE
DATA_IN80:	TEST	AH,AH
		RET
DATA_IN		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		SET DMA				*
;*							*
;*	FUNCTION	SET DMA.			*
;*			START DMA.			*
;*							*
;*	INPUT		SS:BP=PARAMETER ADDRESS		*
;*			AL =	DMA MODE		*
;*							*
;*	OUTPUT		Z-FLAG	ON =ERROR FOUND		*
;*				OFF=NORMAL END		*
;*							*
;*			AH =	ERROR CODE		*
;*							*
;********************************************************
SET_DMA		PROC	NEAR
;
;	CHECK DMA BOUNDARY
;
						; BX=SEGMENT ADDRESS
		MOV	BX,WORD PTR [BP+HDADR+2]
		MOV	CL,4
		ROL	BX,CL
		MOV	DX,BX
		AND	DL,0FH			; DL= BX*16/65536
		AND	BX,0FFF0H		; BX= BX/16
		ADD	BX,WORD PTR [BP+HDADR+0]
		ADC	DL,0			; DL = DMA BANK
;						; BX = DMA ADDRESS
		MOV	CX,[BP.HDLNG]		; CX=DATA BYTE LENGTH
		DEC	CX
		ADD	BX,CX			; 64KB BOUNDARY
		JC	SET_DMA90
		SUB	BX,CX
;
;	DMA START
;
		@OUT	DMA_BPTR,AL		; RESET F/F
		@OUT	DMA_MOD,AL		; SET MODE
		@OUT	DMA_ADR0,BL		; SET ADDRESS
		@OUT	DMA_ADR0,BH
		@OUT	DMA_BNK0,DL		; SET BANK ADDRESS
		@OUT	DMA_CNT0,CL		; SET DATA COUNTER
		@OUT	DMA_CNT0,CH
;		@OUT	DMA_SMR,0		; DMA START
		MOV	AH,ERR_NONE
SET_DMA80:
		TEST	AH,AH
		RET
SET_DMA90:
		MOV	AH,ERR_DMA_B
		JMP	SET_DMA80
SET_DMA		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		SET DATA CONTROL BLOCK		*
;*							*
;*	FUNCTION	SET DATA CONTROL BLOCK		*
;*							*
;*	INPUT		SS:BP=PARAMETER ADDRESS		*
;*							*
;*	OUTPUT		NONE				*
;*							*
;********************************************************
SET_DCB		PROC	NEAR
		MOV	CX,[BP.HDCYL]
		MOV	DH,[BP.HDHED]
		MOV	DL,[BP.HDSEC]
		MOV	BX,[BP.HDLNG]
		MOV	AL,[BP.HDUADA]
		MOV	AH,[BP.HDCMD]
		CALL	IDR_CNV
		MOV	[HD_DCB.DCBCYL],CL	; SET CYLINDER
		AND	AL,0FH			; AL=DRIVE NUMBER
		MOV	CL,5
		SHL	AL,CL
		OR	DH,AL
		MOV	[HD_DCB.DCBHED],DH	; SET HEAD & DRIVE
		MOV	CL,6			; CH=CYLINDER NUMBER HIGH
		SHL	CH,CL
		OR	DL,CH
		MOV	[HD_DCB.DCBSEC],DL	; SET SECTOR & CYLINDER
		MOV	CL,SEC_SHIFT
		SHR	BX,CL
		MOV	[HD_DCB.DCBRNO],BL	; SET BLOCK COUNT
		MOV	AL,STEP_OPTION
		TEST	AH,20H			; RETRY ENABLE ?
		JZ	SET_DCB60
		OR	AL,80H
SET_DCB60:
		MOV	[HD_DCB.DCBRTY],AL	; SET CONTROL FEELD
		RET
SET_DCB		ENDP
		PAGE
;********************************************************
;*							*
;*	MODULE		RELATIVE ADDRESS CONVERT	*
;*							*
;*	FUNCTION	RELATIVE SECTOR NUMBER CONVERT	*
;*			TO CYLINDER, HEAD AND SECTOR	*
;*			NUMBER.				*
;*							*
;*	INPUT		CX=RELATIVE SECTOR NUMBER LOW	*
;*			DX=RELATIVE SECTOR NUMBER HIGH	*
;*							*
;*	OUTPUT		CX=CYLINDER NUMBER		*
;*			DH=HEAD NUMBER			*
;*			DL=SECTOR NUMBER		*
;*							*
;********************************************************
IDR_CNV		PROC	NEAR
		@PUSH	<AX,BX>
		TEST	AL,80H			; RELATIVE ADDRESS ? APR/26/84
		JZ	IDR_CNV70		;--------------------APR/26/84
;----------------------------------------------CHANGE MAY/08/84--------
		MOV	BX,OFFSET HD_PARAM0.P_HED
		TEST	[BP.HDUADA],01H		; UNIT#0 ?
		JZ	IDR_CNV20		; Y
		MOV	BX,OFFSET HD_PARAM1.P_HED
IDR_CNV20:
		MOV	AX,CX			; DX,AX=RELATIVE ADDRESS
		AND	DX,0001H
		MOV	CX,MAX_SEC		; DEVIDE BY BUMBER OF SECTORS
		DIV	CX
		MOV	CL,[BX]
		MOV	CH,0			; DIVIDE BY NUMBER OF HEADS
		MOV	BL,DL			; SAVE SECTOR NUMBER TO BL REG.
		MOV	DX,0
		DIV	CX

		MOV	CX,AX			; SET CYLINDER	NUMBER
		MOV	DH,DL			; SET HEAD	NUMBER
		MOV	DL,BL			; SET SECTOR	NUMBER
;----------------------------------------------------------------------
IDR_CNV70:
		INC	DL
		@POP	<BX,AX>
		RET
IDR_CNV		ENDP
;-----------------------------------------------+
;		PROGRAM END			;
;-----------------------------------------------+
ROM		ENDS
		END

