	PAGE 58,132
	TITLE		'A1 DKROM 11-05-1983'
;------------------------------------------------------------------
; HISTORY :
;	11-18-1983	DELETE AI FLAG PROC. AT SENSE COMMAND.
;			ADD SETTING OF AI FLAG TO DISK_AI AREA.
;	11-23-1983	FIX BUG. (ON HARDDISK PROC.,
;			INCORRECT CONDITINAL JMP FOR REL/ABS
;			SECTOR ADDRESSING RECOGNITION.)
;	11-26-1983	FIX BUG. (ON SENSE COMMAND FOR 5FD,
;			INCORRECT BIT PATTERN IS RETURNED
;			WHEN DEVICE IS NOT READY.)
;	11-29-1983	HEAD LOAD TIME 48->4 MSEC
;			HEAD UNLOAD TIME 192->480 MSEC
;			MOTOR ON 1->.5 SEC
;	12-09-1983	SAVE XROMPTR ON BOOT FROM HARD DISK
;	12-13-1983	HEAD LOAD TIME 4->48 MSEC
;	04-05-1984	DEVIDE HD DRIVER AND FD DRIVER.
;			AND RENAME "FDROM" AND "HDROM"
;	04-13-84	CHANGE BOOT LOADER
;------------------------------------------------------------------
	INCLUDE	B:EQCOM.LIB
;----------------------------------------------------------
;
;	EXTRNAL/PUBLICS
;
;----------------------------------------------------------
;
	PUBLIC	DISK_IO		; DISK BIOS MAIN ENTRY
;
;  THESE ARE FOR BOOTROM
;
	PUBLIC	DS_INIT0
	PUBLIC	DS_INIT1
	PUBLIC	DS_BOOT
	PUBLIC	DISK_EXIT	;----------------APR/05/84

	EXTRN	H5_ENTR:NEAR	; HD ENTRY POINT APR/05/84
	EXTRN	H5_INIT:NEAR	; HD INITIAL ENTRY APR/05/84
	PAGE
;-----------------------------------------------------------
;
;	DATA SEGMENT (MUST BE IN RAM)
;
;-----------------------------------------------------------
;
	INCLUDE B:SYSCOM.LIB
;
;----------------------------------------INS--APR/13/84---------------
BOOT_SEG	SEGMENT	AT 01FC0H
JMP_CODE	DB	?
	ORG	510
DISCERN		DW	?
BOOT_SEG	ENDS
;-------------------------------------------------------------------
	PAGE
;-------------------------------------------
;
;	CODE SEGMENT
;
;-------------------------------------------
;
ROM	SEGMENT	WORD PUBLIC
	ASSUME	CS:ROM,DS:SYSCOM,ES:SYSCOM,SS:SYSCOM
;
;-------------------------------------------------------
;
;	FD/HD BASIC I/O ROUTINE		10-31-1983
;
;
;-------------------------------------------------------
;	ORIGINAL DEFINITION
;-------------------------------------------------------
BIO_REG	STRUC
BIO_UNT	DB	?		;AL
BIO_CMD	DB	?		;AH
BIO_DTL	DW	?		;BX
BIO_CYL	DB	?		;CL
BIO_NUM	DB	?		;CH
BIO_SEC	DB	?		;DL
BIO_HED	DB	?		;DH
BIO_DTA	DW	?		;BP
BIO_DTS	DW	?		;ES
	DB	10 DUP (?)
BIO_FLG	DB	?		;FLAG
BIO_REG	ENDS

BIO_REG2	STRUC
BIO_ACC	DW	?		;AX
	DB	?
BIO_BLK	DB	?		;BH
BIO_CYW	DW	?		;CX
	DB	2 DUP (?)
BIO_DD	DD	?		;ES:BP
	DB	10 DUP (?)
	DW	?
BIO_REG2	ENDS
;----------------------------------------------------
;
;	NO OBJECT 5" HARD DISK
;
;----------------------------------------------------
;
C_HARD		EQU	01   
;
;---------------------------------------------------------------------
;
;	IN CODE, BIO_XXX CHANGED AS [BP.BIO_XXX], ETC.
;
;---------------------------------------------------------------------
;
;----------------------------------------------------------
;
;	ADDED 11-15-1983, TO REPLACE 'INT 1BH' TO
;	'INT DISK_BIOS'
;
;-----------------------------------------------------------
;
DISK_BIOS	EQU	1DH	; DISK_IO BIOS ENTRY
;
	PAGE
;
;	FD/HD INITIALIZE
;
DS_INIT0:				;STAGE 0
 	CMP	BYTE PTR DISK_XROM+0,0
 	JNE	DS_INIT0_1		
	CALL	F5_INI0
DS_INIT0_1:
	IF	C_HARD
 	CMP	BYTE PTR DISK_XROM+2,0
 	JNE	DS_INIT0_2
 	CALL	H5_INIT         	;NO 5" HARD
DS_INIT0_2:
	RET
	ENDIF
DS_INIT1:				;STAGE 1
 	CMP	BYTE PTR DISK_XROM+0,0
 	JNE	DS_INIT1_1
	CALL	F5_INI1
DS_INIT1_1:
	RET
	PAGE
;****************************************************************
;*								*
;*	ENTRY AND EXIT OF DISK ROM BIOS				*
;*								*
;*	FUNCTION						*
;*								*
;*		BRANCH ANY MODULE AND RETURN BACK		*
;*			"F5_ENTR"	(FD BIOS)		*
;*			"H5_ENTR"	(HD BIOS)		*
;*								*
;*			XX00:0018	(EXTRA ROM)		*
;*								*
;*	WITH PARAMETER WHEN BRANCH				*
;*								*
;*		BP = PARAMETER STORE ADDRESS			*
;*								*
;*	WITH PARAMETER WHEN RETURN				*
;*								*
;*		BP = SAME AS WHEN BRANCH			*
;*		AH = STATUS (WITH ERROR CODE)			*
;*								*
;****************************************************************
DISK_IO:
	STI
	CLD
	PUSH	DS
	PUSH	SI
	PUSH	DI
	PUSH	ES
	PUSH	BP
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX
	MOV	BP,SYSCOM
	MOV	DS,BP
	MOV	BP,SP			;TOP OF STACK
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	AND	AL,07H
	MOV	BX,OFFSET DISK_XROM
	XLAT	AL
	CMP	AL,0
	JE	DS_MAIN
	MOV	AH,AL
	XOR	AL,AL
	MOV	XROM_SEGMENT,AX
	MOV	XROM_OFFSET,3*8
	JMP	DWORD PTR XROM_PTR	;TO XROM
DS_MAIN:
 	IF	C_HARD
	TEST	[BP.BIO_UNT],10H
	JZ	F5_ENTR
	JMP	H5_ENTR
	ELSE	
	JMP	F5_ENTR
	ENDIF
;---------------------------------------------------APR/05/84-------
DISK_EXIT:
	AND	[BP.BIO_FLG],0FEH	;RESET CF
	CMP	AH,20H			;ERROR ?
	JB	DISK_EXIT2
	OR	[BP.BIO_FLG],01H	;SET CF
DISK_EXIT2:
	MOV	[BP.BIO_CMD],AH		;SET STATUS

	POP	AX
	POP	BX
	POP	CX
	POP	DX
	POP	BP
	POP	ES
	POP	DI
	POP	SI
	POP	DS
	IRET				;RETURN TO CALLER
;---------------------------------------------------------------------
	PAGE
;
;	5" FLOPPY DISK 2D/2DD I/O ROUTINE
;
;
FDD_STA	EQU	0C8H
FDD_DAT	EQU	0CAH
FDD_WCN	EQU	0CCH
;
D_RED	EQU	46H+1			; DMA READ COMMAND
D_WRT	EQU	4AH+1			; DMA WRITE COMMAND
D_VRF	EQU	42H+1			; DMA VERIFY COMMAND
;
;
;	WRITE CONTROL
;
;	BIT	76543210
;		XX0XXX0X
;		II III I
;		II III 0:TIMER TRRIGER OFF
;		II III 1:TIMER TRRIGER ON
;		II II0:TIMER MASK
;		II II1:TIMER ENABLE
;		II I0:MOTOR OFF
;		II I1:MOTOR ON
;		II 0:DMA DISABLE
;		II 1:DMA ENABLE
;		I1:FORCE READY
;		1:RESET
;
C_TIMS	EQU	00000001B		;TIMER START
C_TIMT	EQU	00000101B		;TIMER TRRIGER
C_TIME	EQU	00000100B		;TIMER ENAMLE
C_MTON	EQU	00000000B		;MOTOR ON
C_MTOF	EQU	00000000B		;MOTOR OFF
C_DMAE	EQU	00010000B		;DMA ENABLE
C_DMAD	EQU	00000000B		;DMA DISABLE
C_RSET	EQU	11000000B		;RESET
C_FRDY	EQU	01000000B	 	;FORCE READY
C_ACCF	EQU	00100000B		;ACCESS ON
C_UNT0	EQU	00000010B		;UNIT #0
C_UNT1	EQU	00001000B		;UNIT #1     
C_AMON  EQU     00001010B		;ALL MOTOR ON
	PAGE
;
;	DISK PARAMETOR
;
F5_PARAM	DB	00H,00H,00H,00H,10H,07H,10H,1BH
		DB	10H,0EH,10H,33H,09H,0EH,09H,2AH
		DB	09H,2AH,09H,50H,05H,1BH,05H,3AH
		DB	05H,35H,05H,74H,00H,00H,00H,00H
	PAGE
;
;	I/O ENTRY
;
F5_ENTR:
	OR	F2DD_WORK,C_ACCF	;ACCESS FLAG ON
	MOV	DL,8			;BIO RETRY COUNT
F5_RETRY:
	CALL	F5_MAIN			;CALL MAIN ROUTINE
F5_EXIT:
	CMP	AH,20H			;ERROR ?
	JB	F5_EXIT0		;NO,
	CMP	AH,60H			;CAN BE RETRY ?
	JB	F5_EXIT0		;NO, EXIT
	TEST	[BP.BIO_CMD],20H	;NO RETRY ?
	JNZ	F5_EXIT0		;YES,
	DEC	DL			;DEC RETRY COUNT
	JNZ	F5_RETRY		;JUMP IF CONTINUE
F5_EXIT0:
;
	MOV	AL,[BP.BIO_UNT]
	TEST	AL,01H
	MOV	AL,F2DD_COUNT
	JNZ	F5_1EXIT
	MOV	F2DD_TIME0,AL
	JMP	F5_2EXIT
F5_1EXIT:
	MOV	F2DD_TIME1,AL
F5_2EXIT:
	MOV	AL,C_TIMS
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	MOV	AL,C_TIME
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	AND	F2DD_WORK,NOT C_ACCF
;
	JMP	DISK_EXIT		;------------APR/05/84---
	PAGE
;
;	INITILIZE ENTRY 0
;
F5_INI0:
	MOV	F2DD_WORK,C_AMON + C_ACCF
	MOV	AL,C_MTON
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	XOR	CX,CX			;WAIT MOTOR START UP
	LOOP	$
	LOOP	$
	LOOP	$
	LOOP	$
	LOOP	$
	TEST	BYTE PTR BIOS_FLAG+1,80H
	JZ	F5_INI01
	LOOP	$
	LOOP	$
	LOOP	$
F5_INI01:
	AND	BYTE PTR DISK_EQUIP+1,0FH
	MOV	F2DD_COUNT,20
	MOV	WORD PTR F2DD_POINTER+0,OFFSET F5_PARAM
	MOV	WORD PTR F2DD_POINTER+2,CS
	XOR	AX,AX
	PUSH	BP
	PUSH	AX
	MOV	BP,SP
	CALL	F5_INITL0
	POP	AX
	POP	BP
	RET
;
;	INITIALIZE ENTRY 1
;
F5_INI1:
	PUSH	BP
	PUSH	AX
	MOV	BP,SP
	CALL	F5_INITL1
	POP	AX
	POP	BP
	MOV	F2DD_TIME0,20
	MOV	F2DD_TIME1,20
	MOV	AL,C_TIMS
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	MOV	AL,C_TIME
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	AND	F2DD_WORK,0FFH - C_ACCF
	RET
	PAGE
;
;	MAIN
;
F5_MAIN:
	MOV	AH,[BP.BIO_UNT]
	TEST	AH,01
	JNE	F5_1MAIN
	OR	F2DD_WORK,C_UNT0
	MOV	AL,C_MTON
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	CMP	F2DD_TIME0,0
	JNE	F5_ENTM
	JMP	F5_WAIT
F5_1MAIN:
	OR	F2DD_WORK,C_UNT1
	MOV	AL,C_MTON
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	CMP	F2DD_TIME1,0
	JNE	F5_ENTM
F5_WAIT:
	MOV	CX,8000H		;MOTOR ON 1MSEC->.5MSEC
	LOOP	$			;----- 11-29-1983
	LOOP	$
	LOOP	$
	TEST	BYTE PTR BIOS_FLAG+1,80H
	JZ	F5_MAIN_RY
	MOV	CX,8000H
	LOOP	$
	LOOP	$
F5_MAIN_RY:
	MOV	AH,04H			;SENSE	UNIT STATUS COMMAND
	CALL	F5_FDCCMD
	MOV	AH,[BP.BIO_UNT]		;UNIT ADDRESS
	AND	AH,07H
	CALL	F5_FDCOUT
	CALL	F5_FDCIN
	TEST	AL,020H			;RY ?
	JNZ	F5_ENTM			;YES,
	MOV	CX,8000H
	LOOP	$
	LOOP	$
	LOOP	$
	TEST	BYTE PTR BIOS_FLAG+1,80H
	JZ	F5_ENTM
	MOV	CX,8000H
	LOOP	$
	LOOP	$
F5_ENTM:
	TEST	[BP.BIO_CMD],10H	; AFTER SEEK ?
	JZ	F5_MAIN1		; NO,
	CALL	F5_SEEK			; SEEK
	CMP	AH,20H
	JB	F5_MAIN1
	RET
;
F5_MAIN1:
	AND	[BP.BIO_CMD],0EFH
	MOV	BL,[BP.BIO_CMD]
	AND	BX,000FH
	SAL	BX,1
	JMP	WORD PTR CS:F5_VECT[BX]
;
;	JUMP VECTOR
;
F5_VECT:
	DW	F5_NOP
	DW	F5_VERIFY		;VERIFY
	DW	F5_READ
	DW	F5_INITLZ		;INITIALIZE
	DW	F5_SENSE		;SENSE	UNIT STATUS
	DW	F5_WRITE		;WRITE	DATA
	DW	F5_READ			;READ DATA
	DW	F5_RECAL		;RECALIBLATE
	DW	F5_NOP
	DW	F5_WRITE		;WRITE	DELETED	DATA
	DW	F5_READID		;READ ID
	DW	F5_NOP
	DW	F5_READ
	DW	F5_FORMAT		;WRITE	ID
	DW	F5_NOP
	DW	F5_NOP
	PAGE
;
;------	NO OPERATION
;
F5_NOP:
	MOV	AH,00H			;NORMAL END
	RET
;
;------	INITIALIZE
;
F5_INITLZ:
	MOV	F2DD_COUNT,20
	MOV	WORD PTR F2DD_POINTER+0,OFFSET F5_PARAM
	MOV	WORD PTR F2DD_POINTER+2,CS
F5_RESET:
	XOR	AX,AX
	PUSH	BP
	PUSH	AX
	MOV	BP,SP
	CALL	F5_INITL0
	CALL	F5_INITL1
	POP	AX
	POP	BP
	RET
	PAGE
;
;	INITILAIZE STAGE 0
;
F5_INITL0:
	CLI				;INT MASK
	IN	AL,0AH			;READ IMR
	OR	AL,04H
	OUT	0AH,AL
	STI
	MOV	DS:WORD PTR [0048H],OFFSET F5_INTR
	MOV	DS:WORD PTR [004AH],CS
	MOV	AL,C_RSET
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL		;RESET
	AND	BYTE PTR DISK_INT+1,0FH
	MOV	AL,C_FRDY		;FORCE READY
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL		;WRITE CONTROL
	MOV	AH,03H			;SPECIFY COMMAND
	CALL	F5_FDCCMD		;OUTPUT THE COMMAND
	MOV	AH,0D6H			;FIRST	BYTE PARM
	CALL	F5_FDCOUT		;TO THE FDC
	MOV	AH,018H			;SECOND BYTE PARM
	CALL	F5_FDCOUT		;TO THE FDC
	CALL	F5_ALL_RECAL		;RECALIBRATE ALL DRIVE
	CLI
	IN	AL,0AH			;READ IMR
	AND	AL,0FBH
	OUT	0AH,AL			;INT ENABLE
	STI
	RET
;
F5_ALL_RECAL:
	XOR	DH,DH	
F5_ALL_RECAL_LOOP:
	MOV	AH,07H			;RECALIBRATE COMMAND
	CALL	F5_FDCCMD		;OUTPUT THE COMMAND
	MOV	AH,DH
	CALL	F5_FDCOUT		;TO THE FDC
	INC	DH
	CMP	DH,4
	JB	F5_ALL_RECAL_LOOP
	RET
;
F5_ALL_WAIT:
	MOV	DH,5
	TEST	BYTE PTR BIOS_FLAG+1,80H
	JZ	F5_ALL_WAIT0
	MOV	DH,7 
F5_ALL_WAIT0:
	XOR	CX,CX
F5_ALL_WAIT1:
	MOV	AL,BYTE PTR DISK_INT+1
	NOT	AL
	TEST	AL,0F0H
	LOOPNZ	F5_ALL_WAIT1
	JNZ	F5_ALL_WAIT2
	RET
F5_ALL_WAIT2:
	DEC	DH
	JNZ	F5_ALL_WAIT0
	JMP	F5_FDC_TIME_OUT
	PAGE
;
;	INITILAIZE STAGE 0
;
F5_INITL1:
	CALL	F5_ALL_WAIT
	AND	BYTE PTR DISK_INT+1,0FH
	CLI				;INT MASK
	IN	AL,0AH			;READ IMR
	OR	AL,04H
	OUT	0AH,AL
	STI
	CALL	F5_ALL_RECAL		;RECALIBRATE ALL DRIVE
	CLI
	IN	AL,0AH			;READ IMR
	AND	AL,0FBH
	OUT	0AH,AL			;INT ENABLE
	STI
	CALL	F5_ALL_WAIT		;WAIT UNTIL I/O END
	CLD
	MOV	CX,4
	MOV	SI,OFFSET F2DD_RESULT+8
	MOV	DH,10H
F5_INIT30:
	LODSW	
	TEST	AX,0FFC0H		;NORMAL ?
	JNZ	F5_INIT35		;NO, INOPERABLE
	OR 	BYTE PTR DISK_EQUIP+1,DH
F5_INIT35:
	SAL	DH,1
	LOOP	F5_INIT30
	AND	BYTE PTR DISK_INT+1,0FH
	CLI				;INT MASK
	IN	AL,0AH			;READ IMR
	OR	AL,04H
	OUT	0AH,AL
	STI
	MOV	AH,03H			;SPACIFY
	CALL	F5_FDCCMD
	MOV	AH,0EFH			;HEAD UNLOAD 480M ---- 11-29-1983
	CALL	F5_FDCOUT
	MOV	AH,002H			;HEAD LOAD 4MSEC
	CALL	F5_FDCOUT
	MOV	AL,C_MTON		;MOTOR ON
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL
	CLI
	IN	AL,0AH			;READ IMR
	AND	AL,0FBH
	OUT	0AH,AL			;INT ENABLE
	STI
	MOV	AH,0
	RET
	PAGE
;
;------	SENSE UNIT STATUS
;
F5_SENSE:
	MOV	AH,04H			;SENSE	UNIT STATUS COMMAND
	CALL	F5_FDCCMD
	MOV	AH,[BP.BIO_UNT]		;UNIT ADDRESS
	AND	AH,07H
	CALL	F5_FDCOUT
	CALL	F5_FDCIN
	MOV	AH,040H			;NOT READY ----- 11-26-1983 (C) ---------- BUG FIX.
	TEST	AL,020H			;RY ?
	JZ	F5_SENSE3		;NO,
	MOV	AH,010H			;WRITE	PROTECTED
	TEST	AL,040H			;WP ?
	JNZ	F5_SENSE3		;YES,
	XOR	AH,AH
F5_SENSE3:
	MOV	CX,0103H
	AND	CL,[BP.BIO_UNT]
	SAL	CH,CL
	IN	AL,PORTA		;READ SYSTEM PORT A
	OR	AL,0CH
	TEST	AL,CH
	JZ	F5_SENSE5
	OR	AH,001H
F5_SENSE5:
;------------------- DELETED 11-18-1983 --------------------------
	RET
	PAGE
;
;------	VERIFY DATA
;
F5_VERIFY:
	MOV	AL,D_VRF		;VERIFY
	CALL	F5_DMAS			;SET UP THE DMA
	MOV	AL,C_DMAE		;DMA ENABLE
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL		;DMA ENABLE
	MOV	AH,[BP.BIO_CMD]
	AND	AH,0C0H
	OR	AH,026H
	JMP	SHORT	F5_RWOPN1
;
;------	WRITE DATA
;
F5_WRITE:
	MOV	AL,D_WRT		;WRITE
	JMP	SHORT	F5_RWOPN
;
;------	READ DATA
;
F5_READ:
	MOV	AL,D_RED		;READ
;
;------	READ / WRITE OPERATION
;
F5_RWOPN:
	CALL	F5_DMAS			;SET UP THE DMA
	JB	F5_BOUND		;BRANCH IF BOUNDALY ERROR
	MOV	AL,C_DMAE		;DMA ENABLE
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL		;DMA ENABLE
	MOV	AH,[BP.BIO_CMD]
	AND	AH,0DFH			;CLEAR RTY BIT
F5_RWOPN1:
	CALL	F5_FDCCMD		;COMMAND
	CALL	F5_HDUNIT		;SELECT HEAD/UNIT
	MOV	AH,[BP.BIO_CYL]
	CALL	F5_FDCOUT		;C
	MOV	AH,[BP.BIO_HED]
	CALL	F5_FDCOUT		;H
	MOV	AH,[BP.BIO_SEC]
	CALL	F5_FDCOUT		;R
	MOV	AH,[BP.BIO_NUM]
	CALL	F5_FDCOUT		;N
	LES	SI,DWORD PTR F2DD_POINTER
	MOV	BL,[BP.BIO_NUM]
	XOR	BH,BH
	SAL	BX,1
	SAL	BX,1
	SAL	BX,1
	ADD	SI,BX
	TEST	[BP.BIO_CMD],40H
	JNZ	F5_RWOPN2
	ADD	SI,4
F5_RWOPN2:
	CALL	F5_FDCPARM		;EOT
	CALL	F5_FDCPARM		;GPL
	MOV	AH,0FFH
	CALL	F5_FDCOUT		;DTL
	MOV	SI,OFFSET F2DD_RESULT
	CALL	F5_IOWAIT
	MOV	AL,07H
	OUT	DMA_SMR,AL
	MOV	AL,C_DMAD		;DMA DISABLE
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL		;DMA DISABLE
	RET
;
;------	DMA BOUNDARY ERROR
;
F5_BOUND:
	MOV	AL,07H
	OUT	DMA_SMR,AL
	MOV	AH,020H			;DMA BOUNDALY
	MOV	AL,C_DMAD		;DMA DISABLE
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL		;DMA DISABLE
	RET
	PAGE
;
;------	WRITE ID [FORMAT WRITE]
;
F5_FORMAT:
	MOV	AL,D_WRT		;WRITE
	CALL	F5_DMAS
	JB	F5_BOUND
	MOV	AL,C_DMAE		;DMA ENABLE
	OR	AL,F2DD_WORK
	OUT 	FDD_WCN,AL		;DMA ENABLE
	MOV	AH,[BP.BIO_CMD]
	AND	AH,0DFH
	CALL	F5_FDCCMD		;COMMAND
	CALL	F5_HDUNIT		;SELECT HEAD/UNIT
	MOV	AH,[BP.BIO_NUM]	
	CALL	F5_FDCOUT		;N
	LES	SI,DWORD PTR F2DD_POINTER
	MOV	BL,[BP.BIO_NUM]		;SECTOR LENGTH
	XOR	BH,BH
	SAL	BX,1			;SHIFT 3 TIMES
	SAL	BX,1
	SAL	BX,1
	LEA	SI,2[BX+SI]
	TEST	[BP.BIO_CMD],40H
	JNZ	F5_FORM1
	ADD	SI,4
F5_FORM1:
	CALL	F5_FDCPARM		;EOT
	CALL	F5_FDCPARM		;GPL
	MOV	AH,[BP.BIO_SEC]
	CALL	F5_FDCOUT		;D
	MOV	SI,OFFSET F2DD_RESULT
	CALL	F5_IOWAIT
	MOV	AL,07H
	OUT	DMA_SMR,AL
	MOV	AL,C_DMAD		;DMA DISABLE
	OR	AL,F2DD_WORK
	OUT	FDD_WCN,AL		;DMA DISABLE
	RET
	PAGE
;
;------	RECALIBRATE
;
F5_RECAL:
	MOV	AH,07H
	CALL	F5_FDCCMD		;RECALILATE COMMAND
	MOV	AH,[BP.BIO_UNT]
	AND	AH,03H
	CALL	F5_FDCOUT		;LAST PARM TO THE FDC
	MOV	SI,0003H
	AND	SI,[BP.BIO_ACC]
	SAL	SI,1
	ADD	SI,OFFSET F2DD_RESULT+8
	CALL	F5_IOWAIT
	MOV	AH,07H
	CALL	F5_FDCCMD		;RECALILATE COMMAND
	MOV	AH,[BP.BIO_UNT]
	AND	AH,03H
	CALL	F5_FDCOUT		;LAST PARM TO THE FDC
	MOV	SI,0003H
	AND	SI,[BP.BIO_ACC]
	SAL	SI,1
	ADD	SI,OFFSET F2DD_RESULT+8
	CALL	F5_IOWAIT
	MOV	CX,5555
	TEST	BYTE PTR BIOS_FLAG+1,80H
	JZ	F5_RECAL_5M
	MOV	CX,8888
F5_RECAL_5M:
	LOOP	$
	RET
	PAGE
;
;------	SEEK
;
F5_SEEK:
	MOV	BL,[BP.BIO_CYL]		;SAVE CYLINDER NUMBER
	MOV	CX,0103H		;JUDGE DRIVE TYPE
	AND	CL,[BP.BIO_UNT]
	SAL	CH,CL
	IN	AL,PORTA
	OR	AL,0CH
	TEST	AL,CH
	JNZ	F5_SEEK_2DD		;JUMP IF 2DD
	TEST	[BP.BIO_UNT],40H	;2DD ACCESS ?
	JNZ	F5_SEEK_ERROR		;YES, SEEK ERROR
	JMP	SHORT	F5_SEEK_CHECK	;EXEC SEEK
F5_SEEK_2DD:
	TEST	[BP.BIO_UNT],40H	;2DD ACCESS ?
	JNZ	F5_SEEK_CHECK		;YES,
	SAL	BL,1			;CYLINDER NUMBER * 2
F5_SEEK_CHECK:
	MOV	SI,0003H
	AND	SI,[BP.BIO_ACC]
	SAL	SI,1
	ADD	SI,OFFSET F2DD_RESULT+8	;POINT TO RESULT STATUS AREA
	TEST	BYTE PTR [SI],020H
	JZ	F5_SEEK_EXEC		;JUMP IF NOT SEEK END
	CMP	BYTE PTR 1[SI],BL	;SAME CYLINDER ?
	JNE	F5_SEEK_EXEC		;NO,
	XOR	AH,AH
	RET				;NO SEEK RETURN
F5_SEEK_EXEC:
	MOV	AH,0FH			;SEEK COMMAND TO THE FDC
	CALL	F5_FDCCMD
	CALL	F5_HDUNIT		;SELECT HEAD/UNIT
	MOV	AH,BL
	CALL	F5_FDCOUT		;LAST PARM TO THE FDC
	CALL	F5_IOWAIT		;WAIT I/O END
	RET
F5_SEEK_ERROR:
	MOV	AH,70H			;SET SEEK ERROR STATUS
	RET
	PAGE
;
;------	WAIT FOR FLLOWING INTERRUPT
;
F5_IOWAIT:
	MOV	BH,10H
	MOV	CL,03H
	AND	CL,[BP.BIO_UNT]
	SAL	BH,CL
	MOV	BL,5
	TEST	BYTE PTR BIOS_FLAG+1,80H
	JZ	F5_IOWAT5M
	MOV	BL,8
F5_IOWAT5M:
	XOR	CX,CX
F5_IOWAT0:
	TEST	BYTE PTR DISK_INT+1,BH
	LOOPZ	F5_IOWAT0
	JNZ	F5_IOWATX
	DEC	BL
	JNZ	F5_IOWAT5M
	JMP	F5_FDC_TIME_OUT
F5_IOWATX:
;
;------	STATUS HANDLING
;
	LODSB				;GET ST0
	MOV	AH,000H			;NORMAL TERMINATE
	TEST	AL,0C0H			;NT ?
	JNZ	F5_IOWAT1		;NO,
	TEST	AL,020H			;SEEK END ?
	JNZ	F5_IOWAT6		;YES,
	LODSB	
	LODSB				;GET ST2
	TEST	AL,040H			;CM ?
	JMP	SHORT	F5_IOWAT5
F5_IOWAT1:
	MOV	AH,060H			;EQUIPMENT CHECK
	TEST	AL,020H			;SEEK END ?
	JZ	F5_IOWAT2		;NO,
	OR	AH,010H			;EQUIPMENT CHECK [SEEK ERROR]
F5_IOWAT2:
	TEST	AL,010H			;EC ?
	JNZ	F5_IOWAT6		;YES,
	MOV	AH,040H			;NOT READY
	TEST	AL,008H			;NR ?
	JNZ	F5_IOWAT6		;YES,
	LODSB				;GET ST1
	MOV	AH,030H			;END OF CYLINDER
	SAL	AL,1
	JB	F5_IOWAT6
	MOV	AH,0A0H			;DATA ERROR
	SAL	AL,1
	SAL	AL,1			;DE ?
	JNB	F5_IOWAT3		;NO,
	LODSB				;GET ST2
	TEST	AL,020H			;DD ?
	JMP	SHORT	F5_IOWAT5
F5_IOWAT3:
	MOV	AH,080H			;OVER RUN
	SAL	AL,1			;OR ?
	JB	F5_IOWAT6		;YES,
	MOV	AH,0C0H			;NO DATA
	SAL	AL,1
	SAL	AL,1			;ND ?
	JNB	F5_IOWAT4		;NO,
	LODSB				;GET ST2
	TEST	AL,002H			;BC ?
	JMP	SHORT	F5_IOWAT5
F5_IOWAT4:
	MOV	AH,050H			;NOT WRITABLE
	SAL	AL,1			;NW ?
	JB	F5_IOWAT6		;YES,
	MOV	AH,0E0H			;MISSING ADDRESS MARK
	LODSB				;GET ST2
	TEST	AL,001H			;MD ?
F5_IOWAT5:
	JZ	F5_IOWAT6		;NO,
	OR	AH,010H
F5_IOWAT6:
	XOR	BYTE PTR DISK_INT+1,BH
	RET
	PAGE
;
;------	READ ID
;
F5_READID:
	MOV	AH,[BP.BIO_CMD]		;COMMAND
	AND	AH,0DFH
	CALL	F5_FDCCMD
	CALL	F5_HDUNIT		;SELECT HEAD/UNIT
	MOV	SI,OFFSET F2DD_RESULT
	CALL	F5_IOWAIT
	MOV	SI,OFFSET F2DD_RESULT+3
	LODSB	
	MOV	[BP.BIO_CYL],AL
	LODSB	
	MOV	[BP.BIO_HED],AL
	LODSB	
	MOV	[BP.BIO_SEC],AL
	LODSB	
	MOV	[BP.BIO_NUM],AL
	RET
	PAGE
;
;------	OUTPUT COMMAND
;
F5_FDCCMD:
	XOR	CX,CX
F5_FDCCMD_BUSY:
	IN	AL,FDD_STA		;READ FDC STATUS
	TEST	AL,10H			;BUSY ?
	LOOPNZ	F5_FDCCMD_BUSY		;YES,
	JNZ	F5_FDC_TIME_OUT		;TIME OUT
;
;------	OUTPUT PARM BYTE TO THE FDC
;
F5_FDCOUT:
	XOR	CX,CX
F5_FDCOUT_BUSY:
	IN	AL,FDD_STA		;READ FDC STATUS
	TEST	AL,80H			;READY	?
	LOOPZ	F5_FDCOUT_BUSY		;NO,
	JZ	F5_FDC_TIME_OUT		;TIME OUT
	TEST	AL,40H
	JNZ	F5_FDC_TIME_OUT		;TIME OUT
	MOV	AL,AH
	OUT	FDD_DAT,AL
	RET
;
;------	TIME OUT
;
F5_FDC_TIME_OUT:
	LEA	SP,-2[BP]
	CMP	[BP.BIO_CMD],0
	JE	F5_TIME_OUT
	CALL	F5_RESET
F5_TIME_OUT:
	MOV	AH,90H
	RET
;
;------	OUTPUT HD / US TO THE FDC
;
F5_HDUNIT:
	MOV	AH,[BP.BIO_HED]		;HEAD #
	SAL	AH,1
	SAL	AH,1
	XOR	AH,[BP.BIO_UNT]		;UNIT SELECT
	AND	AH,07H
	JMP	SHORT	F5_FDCOUT
;
;------	OUTPUT GPL / EOT TO THE	FDC
;
F5_FDCPARM:
	XOR	CX,CX
F5_FDCPARM_BUSY:
	IN	AL,FDD_STA
	TEST	AL,80H
	LOOPZ	F5_FDCPARM_BUSY
	TEST	AL,40H
	JNZ	F5_FDC_TIME_OUT
	LODS	BYTE PTR (ES:[DI])
	OUT	FDD_DAT,AL
	RET
;
;------	INPUT RESULT DATA FROM THE FDC
;
F5_FDCIN:
	XOR	CX,CX
F5_FDCIN_BUSY:
	IN	AL,FDD_STA
	TEST	AL,80H
	LOOPZ	F5_FDCIN
	JZ	F5_FDC_TIME_OUT		;TIME OUT
	TEST	AL,40H
	JZ	F5_FDC_TIME_OUT
	IN	AL,FDD_DAT
	RET
	PAGE
;
;------	SET UP THE DMA
;
F5_DMAS:
	OUT	DMA_BPTR,AL		;SET THE FIRST/LAST F/F
	NOP
	OUT	DMA_MOD,AL		;OUTPUT THE MODE BYTE
	MOV	AX,[BP.BIO_DTS]		;DATA SEGMENT
	MOV	CL,4			;SHIFT	COUNT
	ROL	AX,CL			;ROTATE LEFT
	MOV	CH,AL			;GET HIGHEST NYBLE TO CH
	AND	AL,0F0H			;ZERO THE LOW NYBLE FROM SEGMENT
	ADD	AX,[BP.BIO_DTA]
	ADC	CH,0
	PUSH	AX			;SAVE ADDRESS
	OUT	DMA_ADR3,AL		;OUTPUT LOW ADDRESS
	MOV	AL,AH
	OUT	DMA_ADR3,AL		;OUTPUT HIGH ADDRESS
	MOV	AL,CH			;GET HIGH 4 BITS
	AND	AL,0FH
	OUT	DMA_BNK3,AL		;OUTPUT THE HIGH 4 BITS TO BANK
	MOV	AX,[BP.BIO_DTL]		;DATA LENGTH
	DEC	AX
	OUT	DMA_CNT3,AL		;OUTPUT THE LOW BYTE OF LENGTH
	XCHG	AL,AH
	OUT	DMA_CNT3,AL		;OUTPUT THE HIGH BYTE OF LENGTH
	XCHG	AL,AH
	POP	CX			;RESTORE ADDRESS
	ADD	AX,CX
	MOV	AL,03H
	OUT	DMA_SMR,AL		;INITIALIZE THE FLOPPY	DISK CHANNEL
	RET
	PAGE
;
;------	INTERRUPT
;
F5_INTR:
F5_INTRPT:
	PUSH	AX
	MOV	AL,EOI
	OUT	INTS_O2,AL
	MOV	AL,0BH
	OUT	INTS_O3,AL
	NOP
	IN	AL,INTS_IS
	TEST	AL,0FFH
	JNZ	F5_INTR10
	MOV	AL,EOI
	OUT	INTM_O2,AL
F5_INTR10:
	STI				;ENABLE INTRRUPT
	PUSH	ES
	PUSH	DI
	PUSH	CX
	XOR	DI,DI
	MOV	ES,DI			;SYSTEM DATA SEGMENT
	CLD
F5_INTR20:
	IN	AL,FDD_STA
	TEST	AL,10H			;BUSY ?
	JNZ	F5_INTR_RW		;YES, R/W RESULT PHASE
	XOR	CX,CX
F5_INTR_SS:				;SENSE	INTERRUPT STATUS COMMAND
	IN	AL,FDD_STA		;READ FDC STATUS
	TEST	AL,80H			;READY	?
	LOOPZ	F5_INTR_SS		;NO,
	JZ	F5_INTR_TOUT		;TIME OUT
	TEST	AL,40H
	JNZ	F5_INTR_TOUT		;TIME OUT
	MOV	AL,08H
	OUT	FDD_DAT,AL
	CALL	F5_INTR_SUB
	JZ	F5_INTR_TOUT
	CMP	AL,80H			;INVALID COMMAND ?
	JE	F5_INTR_EXIT		;YES,
	MOV	DI,0003H
	AND	DI,AX
	SAL	DI,1
	ADD	DI,OFFSET F2DD_RESULT+8
	JMP	SHORT	F5_INTR30
;
;------	MOTOR TURN OFF
;
F5_INTR_TOUT:				;TIME OUT 
F5_INTR_EXIT:
	TEST	ES:F2DD_WORK,C_ACCF
	JNZ	F8_INTR29
	CALL	F5_INTR_S1
;
;------	EXIT
;
F8_INTR29:
	POP	CX
	POP	DI
	POP	ES
	POP	AX
	IRET
F5_INTR_RW:
	CALL	F5_INTR_SUB
	JZ	F5_INTR_TOUT
	MOV	DI,OFFSET F2DD_RESULT
F5_INTR30:
	MOV	CL,03H			;DECODE UNIT NUMBER
	MOV	AH,10H
	AND	CL,AL
	SAL	AH,CL
	TEST	AL,80H			;ATTENTION INTERRRUPT ?
	JZ	F5_INTR40		;NO,
;------------------------- CHANGED 11-18-1983 FROM HERE ---------
	OR	ES:BYTE PTR DISK_AI,AH	; SET AI FLAG TO COMMON AR.
;;;;; -----------------------------------------
;	THIS FLAG MUST BE CLEARED BY
;	UPPER LEVEL ROUTINE. ROM BIOS 
;	ONLY SET IT WHENEVER A INT. OCCURS.
;;;;;------------------------------------------
;-------------------------- CHANGED 11-18-1983 TO HERE ----------
F5_INTR35:
	CALL	F5_INTR_SUB
	JNZ	F5_INTR35
	JMP	SHORT	F5_INTR20
F5_INTR40:
	OR	ES:BYTE	PTR DISK_INT+1,AH
F5_INTR50:
	STOSB	
	CALL	F5_INTR_SUB
	JNZ	F5_INTR50
	JMP	F5_INTR20
;
;	STATUS READ SUBROUTINE
;
F5_INTR_SUB:
	XOR	CX,CX
F5_INTR_LOOP:
	IN	AL,FDD_STA
	TEST	AL,80H
	LOOPZ	F5_INTR_LOOP
	JZ	F5_INTR_ERR
	TEST	AL,40H
	JZ	F5_INTR_ERR
	IN	AL,FDD_DAT
F5_INTR_ERR:
	RET
;
F5_INTR_S1:
	CMP	ES:F2DD_TIME0,0
	JE	F5_INTR_S2
	DEC	ES:F2DD_TIME0
	JNZ 	F5_INTR_S2
	XOR	ES:F2DD_WORK,C_UNT0
F5_INTR_S2:
	CMP	ES:F2DD_TIME1,0
	JE	F5_INTR_S3
	DEC	ES:F2DD_TIME1
	JNZ	F5_INTR_S3
	XOR	ES:F2DD_WORK,C_UNT1
F5_INTR_S3:
	MOV	AL,C_MTON
	TEST	ES:F2DD_WORK,C_AMON
	JZ	F5_INTR_S4
	MOV	AL,C_TIMT
	OR	AL,ES:F2DD_WORK
	OUT	FDD_WCN,AL
	MOV	AL,C_TIME
F5_INTR_S4:
	OR	AL,ES:F2DD_WORK
	OUT	FDD_WCN,AL
	RET
;-------------------------------------------------DELETE APR/05/84------
		PAGE
;
;	BOOT STRAP LOADER
;
DS_BOOT:
	CMP	AL,02H			; 5"FD ?
	JE	F5_BOOT			; YES,
	CMP	AL,03H			; 5"FD ?
	JE	F5_BOOT			; YES,
	IF	C_HARD       		; NO 5_HARD DISK     
	CMP	AL,0AH			; 5"HD UNIT#0 ?
	JE	H5_BOT0			; YES,
	CMP	AL,0BH			; 5"HD UNIT#1 ?
	JE	H5_BOT1			; YES,
	ENDIF				; END NO 5" HARD DISK
DS_BOTX:
	RET
;
;	5"HD BOOT
;
H5_BOT0:
	IF	C_HARD      		; NO 5" HARD
	TEST	BYTE PTR DISK_EQUIP+1,01H
	JZ	DS_BOTX
	MOV	AL,10H
	PUSH	XROM_SEGMENT		;------12-13-1983
	PUSH	XROM_OFFSET		; SAVE XROM_PTR
	CALL	H5_BOTS
	POP	XROM_OFFSET
	POP	XROM_SEGMENT
	RET
H5_BOT1:
	TEST	BYTE PTR DISK_EQUIP+1,02H
	JZ	DS_BOTX
	MOV	AL,11H
	PUSH	XROM_SEGMENT		;------12-13-1983
	PUSH	XROM_OFFSET		; SAVE XROM_PTR
	CALL	H5_BOTS
	POP	XROM_OFFSET
	POP	XROM_SEGMENT
	RET
	ENDIF				;END NO 5" HARD
	PAGE
;
;-----	BOOT
;
F5_BOOT:
	TEST	BYTE PTR DISK_EQUIP+1,0F0H
	JZ	F5_BTRT
;
	MOV	AL,BYTE PTR DISK_EQUIP+1
	MOV	BX,6
	PUSH	BX
F5_BTLP:
	MOV	BX,1000H
F5_BTCK:
	TEST	AL,BH
	JNZ	F5_BTAV
	SHL	BH,1
	INC	BL
	JMP	SHORT	F5_BTCK
F5_BTAV:
	XOR	AL,BH
	PUSH	AX
	MOV	AL,BL
	PUSH	XROM_SEGMENT
	PUSH	XROM_OFFSET
	CALL	F5_BTSB
	POP	XROM_OFFSET
	POP	XROM_SEGMENT
	POP	AX
	TEST	AL,0F0H
	JNZ	F5_BTLP
	POP	BX
	DEC	BX
	JZ	F5_BTRT
	PUSH	BX
	MOV	AL,BYTE PTR DISK_EQUIP+1
	XOR	CX,CX
	LOOP	$
	LOOP	$
	LOOP	$
	LOOP	$
	LOOP	$
	TEST	BYTE PTR BIOS_FLAG+1,80H
	JZ	F5_BTLP
	LOOP	$
	LOOP	$
	LOOP	$
	JMP	SHORT	F5_BTLP
F5_BTRT:
	RET
F5_BTSB:
	MOV	CX,10
F5_BTS1:
	PUSH	CX
	MOV	AH,27H
	INT	DISK_BIOS		; CALL DISK_IO
	MOV	DH,0
	MOV	AH,2AH
	INT	DISK_BIOS		; CALL DISK_IO
	JB	F5_BTS2
	MOV	BX,512
	MOV	SI,1FE0H
	MOV	AH,06H
	JMP	SHORT	F5_BTS3
F5_BTS2:
	MOV	DH,0
	MOV	AH,6AH
	INT	DISK_BIOS		; CALL DISK_IO
	JB	F5_BTS4
	MOV	BX,1024
	MOV	SI,1FC0H
	MOV	AH,46H
F5_BTS3:
	MOV	CL,0
	MOV	DX,1
	MOV	ES,SI
	XOR	BP,BP
	INT	DISK_BIOS		; CALL DISK_IO
	JB	F5_BTS4
	MOV	DISK_BOOT,AL		; READ IPL FROM DISK_BOOT
	MOV	XROM_OFFSET,BP
	MOV	XROM_SEGMENT,ES
	CALL	DWORD PTR XROM_PTR
F5_BTS4:
	POP	CX
	LOOP	F5_BTS1
	RET
	PAGE
;
;	BOOT SUBROUTINE
;
;--------------------------------------------------CHANGE APR/13/84----
	ASSUME	CS:ROM,DS:SYSCOM,ES:BOOT_SEG,SS:NOTHING
;
BOOT_ADR	DD	JMP_CODE
;
H5_BOTS:
	IF	C_HARD      		; NO 5" HARD
	LES	BP,[BOOT_ADR]		; ES:BP=BOOT SECTOR LOAD ADDRESS
	MOV	BX,512			; LENGTH
	MOV	CX,0			; SECTOR ADDRESS
	MOV	DX,0
H5_BOTRR:
	MOV	DI,8			; RETRY COUNTER
H5_BOTR:
	MOV	AH,07H			; RECALIBRATE
	INT	DISK_BIOS		; CALL DISK_IO
	JB	H5_BOTE			; ERROR
	MOV	AH,06H			; READ
	INT	DISK_BIOS		; CALL DISK_IO
	JB	H5_BOTE

	MOV	AH,[JMP_CODE]
	CMP	AH,0E9H			; JUMP NEAR ?
	JZ	H5_BOT4
	CMP	AH,0EBH			; JUMP SHORT ?
	JNZ	H5_BOTX
H5_BOT4:
	CMP	[DISCERN],055AAH	; INVALID ?
	JNZ	H5_BOTX
;
	MOV	[DISK_BOOT],AL		; SET DEVICE OF BOOT DEVICE
	CALL	[BOOT_ADR]		; JUMP TO BOOT SECTOR
;
;
H5_BOTE:
	DEC	DI			; COUNTER END ?
	JNZ	H5_BOTR
	ADD	CX,17			; TRACK UP
	CMP	CX,17
	JZ	H5_BOTRR
;----------------------------------------------------------------------
H5_BOTX:
	MOV	AH,0FH
	INT	DISK_BIOS		; CALL DISK_IO
	RET
	ENDIF
;
ROM	ENDS
	END
5

