.XLIST
;
;-------------------------------------------------------------------
;
;	A1 ROM BIOS WORK AREA 
;
;-------------------------------------------------------------------
;-------------------------------------------------------------------
; History :
;	11-18-1983	Add DISK_AI (attention) flag 1 byte.
;	11-23-1983	Move DISK_XROM for future expansion.
;	11-26-1983	Add COPY_FLAG (to avoid further request
;			during hard copy. Refered in HARD_COPY.)
;			Add CR_DEFAULT_ATTR (default attribute).
;	11-29-1983	Move DISK_AI from 501h.
;			(For CREF's bug, which destroys this area
;			 when a fatal IO error occurs.
;	01-11-1984	Add F2DD_COUNT for motor on/off time counter
;	02-16-1984	Update CRTROM module for 640 x 400 support.
;	03-12-1984	Add GRAPHIC module for slave GDC support.
;	03-20-1984	Add SYS_SEL (boot unit/volume selection).
;	03-27-1984	Revised version for A1 fisrt release.
;
;-------------------------------------------------------------------
;

SYSCOM		SEGMENT	  AT  40H

;	----------------
;	STARTING  40:00H
;	----------------
	ORG	00H
;
;
BIOS_FLAG	DW	?	; System H/W information 1.
				; bit      15 = boot up type.
				;		0 : cold boot.
				;		1 : warm boot.
				; bit 14 - 13 = Not use.
				; bit      12 = Color Board Option.
				;		0 : None.
				;		1 : Attached.
				; bit      11 = VSYNC Sense.
				;		0 : None.
				;		1 : Sensed.
				; bit 10 -  8 = Not use.
				; bit       7 = CPU Clock.
				;		0 : 5 MHz
				;		1 : 8 MHz.
				; bit  6 -  3 = Not use.
				; bit  2 -  0 = Memory Size.
				;		0,0,0 : 128 KB
				;		0,0,1 : 256 KB
				;		0,1,0 : 384 KB
				;		0,1,1 : 512 KB
				;		1,0,0 : 640 KB
DISK_BOOT	DB	?	; Boot disk address (DA/UA).
		                ; bit 7 - 4 = Device Address.
				;	bit 7 = Access Type.
				;		0 : Absolute Sector.
				;		1 : Relative Sector.
				;	bit 6 = 5" Floppy Disk Type.
				;		0 : 2D
				;		1 : 2DD
				;	bit 5 = Not use. 0.
				;	bit 4 = Disk Type.
				;		0 : Floppy Disk.
				;		1 : Hard Disk.
		                ; bit 3 - 0 = Unit   Address.(0-16)
BIOS_BREAK	DB	?	; If 80h, BREAK key has beed depressed.
;
;----------------------------------------
;	BOOT ROM WORK
;----------------------------------------
XROM_ID		DB	8 DUP (?)	; Extended ROM ID.
				; bit 7 = Extended ROM Option.
				;	  0 : None.
				;	  1 : Attached.
				; bit 6 = Jump Table Option.
				;	  0 : None.
				;	  1 : Attached.
				; bit 5 - 0 = ID number.
XROM_PTR	DW	?	; Extended ROM Entry Offset.
		DW	?	; Extended ROM Entry Segment.
;
XROM_OFFSET	EQU	WORD PTR XROM_PTR	; BOOTROM Reference.
XROM_SEGMENT	EQU	WORD PTR XROM_PTR+2	; BOOTROM Reference.
;
;----------------------------------------
;	KEYBOARD ROM WORK
;----------------------------------------
KB_FLAG		DB	?	; Keyboard Status.
		                ; bit 7 = Insert state.
		                ; bit 6 = Caps  lock state.
		                ; bit 5 = Grph1 lock state.
		                ; bit 4 = Grph2 lock state.
		                ; bit 3 = Alt  shift key state.
		                ; bit 2 = Ctrl shift key state.
		                ; bit 1 = Shift      key state.
		                ; bit 0 = Fnc  shift key state.
KB_FLAG1	DB	?	; Keyboard Second Status.
ALT_INPUT	DB	?	; Storage for Alternate.
KB_RETRY	DB	?	; Retry Counter.
BUFFER_HEAD	DW	?	; Pointer to head of Keyboard Buffer.
BUFFER_TAIL	DW	?	; Pointer to Tail of Keyboard Buffer.
KB_BUFFER	DW	16 DUP (?)	; Keyboard Buffer for 15 Entries.
KB_BUFFER_END	LABEL	WORD	; End of Keyboard Buffer.
;
;----------------------------------------
;	CRT ROM WORK
;----------------------------------------
		DB	28 DUP (?)	; Reserve.
CRT_MODE	DB	?	; Current CRT Mode.
CRT_COLS	DB	?	; Number of Columns on Screen.
CURSOR_POSN	DW	?	; Cursor Position of 0 Page.
		DW	?	; Cursor Position of 1 Page.
CURSOR_MODE	DW	?	; Current Cursor Type.
ACTIVE_PAGE	DB	?	; Current Displaying Page.
DRAW_PAGE	DB	?	; Current Drawing Page.
CRT_ENTRY	DW	?	; Dispatching Offset.
DOT_MODIFY_MODE	DB	?	; Dot Modify Mode.
PALETTE01	DB	?	; Buffer of Palette Register 01.
PALETTE23	DB	?	; Buffer of Palette Register 23.
PALETTE45	DB	?	; Buffer of Palette Register 45.
PALETTE67	DB	?	; Buffer of Palette Register 67.
CRT_COLOR	DB	?	; Color Mode Flag.
DRAW_PAGE_SETTING DB	?	; Next Access Page.
		DB	?	; Reserve.
CHAR_BUF	DB	8 * 6 DUP (?)	; Character Image Buffer.
CSRW_P1		DB	?	; CSRW Parameter for GDC.
CSRW_P2		DB	?	;
CSRW_P3		DB	?	;
CSRW_P1_1	DB	?	;
CSRW_P2_1	DB	?	;
CSRW_P3_1	DB	?	;
CSRW_P1_2	DB	?	;
CSRW_P2_2	DB	?	;
CSRW_P3_2	DB	?	;
CSRW_P1_3	DB	?	;
CSRW_P2_3	DB	?	;
CSRW_P3_3	DB	?	;
		DB	?	; Reserve.
VECTW_P1	DB	?	; VECTW Parameter for GDC.
VECTW_P2	DB	?	;
VECTW_P3	DB	?	;
VECTW_P4	DB	?	;
VECTW_P5	DB	?	;
VECTW_P6	DB	?	;
VECTW_P7	DB	?	;
VECTW_P8	DB	?	;
VECTW_P9	DB	?	;
VECTW_P10	DB	?	;
VECTW_P11	DB	?	;
		DB	56 DUP (?)	; Reserve.
;
;----------------------------------------
; 	AUX ROM WORK (RS232-C)
;----------------------------------------
RS_OFST_ADR	DW	?	; Receive Buffer Offset.
RS_SEG_ADR	DW	?	; Receive Buffer Segment.
RS_SIFT		DB	?	; Shift Status for NEC ODA Printer.
				; bit 7 - 3 = Not use.
				; bit     2 = Interrupt.
				; bit     1 = Shift State.
				; bit     0 = Shift Side.
				;	      0 : SO State.
				;	      1 : SI State.
RS_S_FLAG	DB	?	; Shift Status on Receive.
				; bit 7,6,5 = Code conversion by SI/SO.
				;	bit 7 for ch 0.
				;	bit 6 for ch 1.
				;	bit 5 for ch 2.
				; bit 4,3,2 = Shift State. Default SI.
				;	bit 4 for ch 0.
				;	bit 3 for ch 1.
				;	bit 2 for ch 2.
				; bit 1 - 0 = Not use.
RS_D_FLAG	DB	?	; DEL Code Operation.
				; bit 7 - 3 = not used.
				; bit 2 = for ch 2.
				; bit 1 = for ch 1.
				; bit 0 = for ch 0.
;
;----------------------------------------
;	FOR HARD COPY ROUTINE
;----------------------------------------
COPY_FLAG	DB	?	; Means During Hard Copy Process.
				;   0 : Ready.
				;   1 : Busy.
;
;----------------------------------------
;	DISK ROM WORK
;----------------------------------------
DISK_EQUIP	DW	?	; Connected Disk Type.
				; bit 15 -  6 = Not use.
				; bit	    5 = 5" Floppy Disk Unit #1.
				; bit	    4 = 5" Floppy Disk Unit #0.
				; bit  3 -  2 = Not use.
				; bit       1 = 5" Hard Disk Unit # 1.
				; bit	    0 = 5" Hard Disk Unit # 0.
DISK_INT	DW	?	; Disk Interrupt Flag.
				; bit 15 - 6 : not used.
				; bit  5 = 5" Floppy Disk Unit # 1.
				; bit  4 = 5" Floppy Disk Unit # 0.
				; bit  3 - 2 = Not use.
				; bit 0 = 5" Hard Disk Unit #0 or #1.
F2DD_COUNT	DB	?	; Time Out Counter for Motor On/Off of FD.
F2DD_WORK	DB	?	; Motor On/Off Control.
F2DD_TIME0	DB	?	; Time Out Count for Unit # 0.
F2DD_TIME1	DB	?	; Time Out Count fot Unit # 1.
DISK_POINTER	DW	?	; Pointer to HD parameter. Offset.
		DW	?	; Pointer to HD parameter. Segment.
DISK_STATUS	DB	?	; Complete Status Byte of HDC.
				; bit 7 - 5 = LVN.
				; bit 4 - 2 = Not use.
				; bit     1 = Error.
				; bit     0 = Parity Error.
DISK_SENSE	DB	?	; Sense Status Byte from HD Unit # 0.
		DB	?	; Sense Status Byte from HD Unit # 1.
		DB	?	; Reserve.
		DB	?	; Reserve.
;---------------------------------------------------------------------
;	Microsoft's CREF command destroys this memory(00:501) 1 byte
;	when a fatal IO error occured.
CREF_BUG	DB	?	; Can Not Be Used.Because of CREF's Bug.
;
;
;---------------------------------------------------------------------
F2DD_POINTER	DW	?	; Pointer to FDC parameter. Offset.
		DW	?	; Pointer to FDC parameter. Segment.
F2DD_RESULT	DB	16 DUP (?)	; Physical IO Status.
DISK_AI		DB	?	; Floppy Disk Attention Interrupt Flag.
				; bit 7 - 6 = Not use.
				; bit     5 = Floppy Disk Unit # 1.
				; bit     4 = Floppy Disk Unit # 0.
				; bit 3 - 0 = not used.
SYS_SEL		DB	?	; Boot unit/volume selection.
				; (At cold boot, ITFROM senses KB, and
				;  sets this byte as follows : )
				;
				;  If depressed key is :   then SYS_SEL is :
				;  		Fnc		80h
				;		PF1		1
				;		PF2		2
				;		PF3		3
				;		PF4		4
				;		PF5		5
				;		PF6		6
				;		PF7		7
				;		PF8		8
				;		PF9		9
				;		PF10		10
				;		PF11		11
				;		PF12		12
				;		no key		0
				;
				; Note : If no key is depressed, use CMOS
				;        and previous boot time value.
;
CA_TIM_CNT	DW	?	; Interval time counter.
		DW	?	; Interval time counter work.
		DW	?	; Reserve.
		DW	?	; Reserve.
;
;--------------------------------
;	FOR EXTENDED ROM
;--------------------------------
;
DISK_XROM	DB	8 DUP (?)	; Segment Number for Extended ROM.
					; (Only upper 2 digits -- XX00)
;
;----------------------------------------------------------------------
;	Reserved as Intra-Application Communication Area for
;	Any Application. (50:F0h - 50:FFh  16 bytes)
;----------------------------------------------------------------------
		ORG	05F0H
		DB	16 DUP (?)
SYSCOM_END	LABEL	WORD		; SYSCOM End + 1.
SYSCOM		ENDS
.LIST
