	PAGE	60,132
	TITLE	'FDRAM'
;
;
;************************************************
;*						*
;*	MODULE NAME	'FDRAM'			*
;*						*
;*	5" FLOPPY DRIVE ROUTINE			*
;*						*
;*		FEB. 02 1984			*
;*						*
;************************************************
;	MAR/27/84
;	APR/10/84	CHANGE DCB FOR HD
;	APR/12/84	CHANGE DCB
;	JUN/04/84	FIXED BUG
;	JUN/05/84
;		IF (TRAND ADDR + DATA LENGTH) = 64K BOUNDARY, ERROR
;	JUN/12/84	FIXED BUG
;		(1) IF LENGTH 64KB OVER, ABORT RUN
;		(2) IF TRANSFER ADDRESS = 0:FFFF, ABORT RUN
;	JUN/14/84	CHANGE INITIAL VALUE OF HD BPB
;
	INCLUDE	B:SYSCOM.ASM
;
CODE	SEGMENT WORD PUBLIC 'CODES'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
;
;
;
;========================================
;	EXTERNAL REFERENCE
;========================================
;
	EXTRN	ENTRY:NEAR
	EXTRN	NORMAL_EXIT:NEAR
	EXTRN	ERROR_EXIT:NEAR
	EXTRN	CMDERR_EXIT:NEAR
	EXTRN	PTRSAV:DWORD
	EXTRN	FD_DSK_DEV:NEAR
	EXTRN	MSGL:NEAR		; MESSAGE OUT TO CRT
;
;========================================
;	EXTERNAL DEFINITION
;========================================
;
	PUBLIC	FD_DSK_INT
	PUBLIC	DSK_BUF
	PUBLIC	FD_DCB_TBL
	PUBLIC	HDCB0
	PUBLIC	HDCB1
	PAGE
;************************************************
;*						*
;*	STRUCTURE DEFINITION			*
;*						*
;************************************************
;
;	PACKET TABLE
;
IODAT		STRUC
CMDLEN	DB	?			; COMMAND LENGTH
UNIT	DB	?			; LOGICAL UNIT NO.
CMD	DB	?			; COMMAND CODE
STATUS	DW	?			; STATUS
	DB	8 DUP (?)		; DEVICE NAME
MEDIA	DB	?			; MEDIA DESCRIPTOR
TRANS	DD	?			; TRANS BUFFER ADRS
COUNT	DW	?			; TRANS SECTOR
START	DW	?			; TRANS START SECTOR
IODAT	ENDS
;
;
;	5"FD DEVICE CONTROL BLOCK
;
F5_DCB	STRUC
SEN	DB	?			; SENSE STATUS
BCMD	DB	?			; ROM BIOS COMMAND
DAUA	DB	?			; DA/UA
CN	DB	?			; CYLINDER NUMBER
HN	DB	?			; HEAD NUMBER
SN	DB	?			; SECTOR NUMBER
SL	DB	?			; SECTOR LENGTH
DTL	DW	?			; DATA TRANSFER LENGTH
DTA	DW	?			; DATA TRANSFER BUFFER  (OFFSET)
DTS	DW	?			;			(SEGMENT)
STS	DB	?			; BIOS COMMAND RETURN STATUS
	DB	?
	DB	?
CNE	DB	?			; MAXIMUM CYLINDER NUMBER
HNE	DB	?			; MAXIMUM HEAD NUMBER
SNE	DB	?			; MAXIMUM SECTOR NUMBER
	DB	7 DUP (?)
BPB	DB	13 DUP(?)		; BPB INFORMATION SAVE AREA
	DB	?
F5_DCB	ENDS
	PAGE
;************************************************
;*						*
;*	EQUATION BLOCK				*
;*						*
;************************************************
;
;	SENSE STATUS FLAG
;
F_WP	EQU	10H			; WRITE PROTECT FLAG
F_ATN	EQU	08H			; ATTENTION FLAG
F_2DD	EQU	01H			; 2DD DRIVE UNIT
;
;	DA/UA FLAG
;
F_DBL	EQU	40H			; DOUBLE DENSITY FLAG
;
;	ROM BIOS INTERRUPT VECTOR
;
FD_ROM	EQU	1DH			; FD ROM BIOS
KB_ROM	EQU	18H			; KB ROM BIOS
KB_FNC_RDND	EQU	1		; FUNCTION OF READ NON DESTROY
KB_FNC_READ	EQU	0		; FUNCTION OF READ FROM KB
;
;	ASCII CODE
;
CR	EQU	0DH
LF	EQU	0AH
;
MAXUN	EQU	2			; MAXIMUM UNIT NO.
;
;	DISK DEVICE TABLE
;
	PAGE
;*****************************************
;*
;*	DEVICE CONTROL BLOCK
;*
;*****************************************
;
;	OPTION
;
CURSING_DISK	DB	0		; CURRENT DRIVE NUMBER FOR SINGLE DRIVE
CURSING_UNIT	DB	0		; CURRENT UNIT  NUMBER FOR SINGLE DRIVE
UNITS	DB	MAXUN			; NUMBER OF DRIVES
NPHY0	DB	MAXUN - 1		; NUMBER OF UNIT - 1
;
;	5"FD (#0) DCB	(2DD)
;
FD_DCB_TBL	LABEL	NEAR
FDCB0:
	DB	00001001B		; SENSE STATUS
	DB	0			; BIOS COMMAND
	DB	01000000B		; DEVICE ADRS / UNIT ADRS
	DB	0			; CURRENT CYLINDER
	DB	0			; CURRENT HEAD
	DB	0			; CURRENT SECTOR
	DB	2			; SECTOR LENGTH
	DW	512			; BYTE / SECTOR
	DD	0			; TRANS DATA BUFF ADRS
	DB	0			; BIOS RETURN STATUS
	DB	0
	DB	0
	DB	79			; END OF CYLINDER
	DB	1			; END OF HEAD
	DB	8			; END OF SECTOR
	DB	7 DUP (0)
;					; BPB SAVE AREA
	DW	512			; BYTE / SECTOR
	DB	2			; ALOCATION UNIT NO.
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	112			; DIRECTORY NO.
	DW	80*9*2			; TOTAL SECTOR NO.
	DB	0F9H			; MEDIA DESCRIPTOR
	DW	3			; SECTOR / FAT
	DB	0
;
;	5"FD (#1) DCB	(2DD)
;
FDCB1:
	DB	00001001B		; SENSE STATUS
	DB	0			; BIOS COMMAND
	DB	01000001B		; DEVICE ADRS / UNIT ADRS
	DB	0			; CURRENT CYLINDER
	DB	0			; CURRENT HEAD
	DB	0			; CURRENT SECTOR
	DB	2			; SECTOR LENGTH
	DW	512			; BYTE / SECTOR
	DD	0			; TRANS DATA BUFF ADRS
	DB	0			; BIOS RETURN STATUS
	DB	0
	DB	0
	DB	79			; END OF CYLINDER
	DB	1			; END OF HEAD
	DB	8			; END OF SECTOR
	DB	7 DUP (0)
;					; BPB SAVE AREA
	DW	512			; BYTE / SECTOR
	DB	2			; ALOCATION UNIT NO.
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	112			; DIRECTORY NO.
	DW	80*9*2			; TOTAL SECTOR NO.
	DB	0F9H			; MEDIA DESCRIPTOR
	DW	3			; SECTOR / FAT
	DB	0
;
;
;	5"HD (#0) DCB
;
HD_DCB_TBL LABEL	NEAR
HDCB0:
	DB	00001011B		; SENSE STATUS
	DB	0			; BIOS COMMAND
	DB	10010000B		; DA/UA
	DD	0			; CURRENT REL. SECTOR
	DW	512			; BYTE / SECTOR   APR/10/84
	DD	0			; TRANS BUFF ADRS
	DB	0			; BIOS RETURN STATUS
	DB	0
	DB	0
	DD	0			; START OFFSET REL. SECTOR
	DD	0			; LAST REL. SECTOR
	DB	1			; MS-DOS CAPACITY
	DB	0
;					; BPB SAVE AREA
	DW	512			; BYTE / SECTOR	APR/10/84
	DB	16			; ALOCATION UNIT NO.	APR/12/84
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	512/32*17		; DIRECTORY NO. APR/10/84
	DW	(4*310-3)*17		; TOTAL SECTOR NO.	APR/10/84
	DB	0FFH			; MEDIA DESCRIPTOR
	DW	8			; SECTOR / FAT
	DB	0
;
;	5"HD (#1) DCB
;
HDCB1:
	DB	00001011B		; SENSE STATUS
	DB	0			; BIOS COMMAND
	DB	10010001B		; DA/UA
	DD	0			; CURRENT REL. SECTOR
	DW	512			; BYTE / SECTOR	APR/10/84
	DD	0			; TRANS BUFF ADRS
	DB	0			; BIOS RETURN STATUS
	DB	0
	DB	0
	DD	0			; START OFFSET REL. SECTOR
	DD	0			; LAST REL. SECTOR
	DB	3			; MS-DOS CAPACITY
	DB	0
;					; BPB SAVE AREA
	DW	512			; BYTE / SECTOR	APR/10/84
	DB	16			; ALOCATION UNIT NO.	APR/12/84
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	272			; DIRECTORY NO.	APR/10/84
	DW	(4*620-3)*17		; TOTAL SECTOR NO.	APR/10/84
	DB	0FFH			; MEDIA DESCRIPTOR
	DW	8			; SECTOR / FAT	APR/10/84
	DB	0
	PAGE
;
;================================================
;
;	5"FD BPB INFORMATION TABLE
;
;================================================
;
BPB_TBL:
BPB_1D8:
	DW	512			; BYTE / SECTOR
	DB	1			; SECTOR / ALLOCATION
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	64			; DIRECTORY NO.
	DW	40*8			; TOTAL SECTOR NO.
	DB	0FEH			; MEDIA DESCRIPTOR
	DW	1			; SECTOR / FAT
;
BPB_1D9:
	DW	512			; BYTE / SECTOR
	DB	1			; SECTOR / ALLOCATION
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	64			; DIRECTORY NO.
	DW	40*9			; TOTAL SECTOR NO.
	DB	0FCH			; MEDIA DESCRIPTOR
	DW	2			; SECTOR / FAT
;
BPB_2D8:
	DW	512			; BYTE / SECTOR
	DB	2			; SECTOR / ALLOCATION
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	112			; DIRECTORY NO.
	DW	40*8*2			; TOTAL SECTOR NO.
	DB	0FFH			; MEDIA DESCRIPTOR
	DW	1			; SECTOR / FAT
;
BPB_2D9:
	DW	512			; BYTE / SECTOR
	DB	2			; SECTOR / ALLOCATION
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	112			; DIRECTORY NO.
	DW	40*9*2			; TOTAL SECTOR NO.
	DB	0FDH			; MEDIA DESCRIPTOR
	DW	2			; SECTOR / FAT
;
BPB_2DD8:
	DW	512			; BYTE / SECTOR
	DB	2			; SECTOR / ALLOCATION
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	112			; DIRECTORY NO.
	DW	80*8*2			; TOTAL SECTOR NO.
	DB	0FBH			; MEDIA DESCRIPTOR
	DW	2			; SECTOR / FAT
;
BPB_2DD9:
	DW	512			; BYTE / SECTOR
	DB	2			; SECTOR / ALLOCATION
	DW	1			; RESERVE SECTOR
	DB	2			; FAT NO.
	DW	112			; DIRECTORY NO.
	DW	80*9*2			; TOTAL SECTOR NO.
	DB	0F9H			; MEDIA DESCRIPTOR
	DW	3			; SECTOR / FAT
	PAGE
;
;==================================
;
;	WORK AREA
;
;==================================
;
;
C_RCBL	DB	0			; RECALIBRATE COUNTER
C_RTRY	DB	0			; RETRY COUNTER
UN	DB	0			; UNIT NO.
	EVEN
P_DCB	DD	0			; DCB	POINTER
;
C_SECT	DW	0			; LOGICAL SECTOR COUNTER
C_TRNS	DW	0			; TRANS SECTOR COUNTER
;
DSK_BUF_ADR	LABEL	DWORD
	DD	DSK_BUF			; BUFFER FOR DMA BOUNDARY
;
DSK_BUF:
	DB	512 DUP(?)		;------CHANGE JUN/05/84-------
;
	PAGE
;************************************************
;*						*
;*	DESPATCH TABLE FOR DEVICE		*
;*						*
;************************************************
;
FD_DSK_TBL	LABEL	WORD
	DW	FD_DSK_INIT		; 0 -- INITIALIZE
	DW	FD_MEDIA_CHK		; 1 -- MEDIA CHECK
	DW	FD_GET_BPB		; 2 -- BUILD BPB
	DW	CMDERR_EXIT		; 3 -- IO CTRL INPUT
	DW	FD_DSK_READ		; 4 -- DESTRUCTIVE READ
	DW	CMDERR_EXIT		; 5 -- NON-DESTRUCTIVE READ
	DW	CMDERR_EXIT		; 6 -- INPUT STATUS
	DW	CMDERR_EXIT		; 7 -- FLUSH INPUT BUFFER
	DW	FD_DSK_WRIT		; 8 -- WRITE
	DW	FD_DSK_WRTV		; 9 -- WRITE WITH VERIFY
	DW	CMDERR_EXIT		; 10-- WRITE STATUS
	DW	CMDERR_EXIT		; 11-- OUTPUT STATUS
	DW	CMDERR_EXIT		; 12-- IOCTL OUTPUT
	PAGE
;************************************************
;*						*
;*	MODULE NAME	DSK_INT			*
;*						*
;*	FUNCTION	DISK I/O CONTROL	*
;*						*
;*	INPUT/OUTPUT	NONE			*
;*						*
;************************************************
;
;
FD_DSK_INT	PROC	FAR
	PUSH	SI			; ALL REGISTER SAVE
	MOV	SI,OFFSET FD_DSK_TBL
	JMP	ENTRY
FD_DSK_INT	ENDP
	PAGE
;*****************************************
;*
;*	DISK INITIALIZE
;*
;*		COMMAND CODE (0)
;*
;*****************************************
;
FD_DSK_INIT:
	MOV	AL,0			; UN=0
	MOV	[NPHY0],AL		; 
DSK_INIT1:
	PUSH	AX
	CALL	SLCT_DCB		; SELECT DCB TABLE
	JC	DSK_INIT2		; JUMP IF UNDEFINE
	CALL	INIT_DCB		; INITIALIZE DCB TABLE
	JC	DSK_INIT2		; JUMP IF NO CONNECT
	INC	[NPHY0]			; COUNT UNIT NUMBER
	MOV	AL,[UN]
	MOV	[CURSING_UNIT],AL	; SET ENABLE DISK UNIT
DSK_INIT2:
	POP	AX
	INC	AL			; NEXT LOGICAL NO.
	CMP	AL,MAXUN		; END OF LOOP ?
	JNE	DSK_INIT1		; NO,
;
	MOV	AL,[NPHY0]		; CONNECT UNIT NUMBER
	DEC	[NPHY0]			; ZERO ORIGIN
	JNZ	DSK_INIT4		; SINGLE DRIVE ?
	INC	AL			; DRIVE NUMBER UP
	MOV	[CURSING_DISK],0	; DEFAULT=A:
	MOV	SI,OFFSET FDCB0		; SAME DCB FD0 AND FD1
	MOV	DI,OFFSET FDCB1
	MOV	CX,SIZE F5_DCB
	PUSH	DS
	POP	ES
	TEST	[CURSING_UNIT],0
	JZ	DSK_INIT3
	XCHG	SI,DI
DSK_INIT3:
	REP	MOVSB
;
DSK_INIT4:
	MOV	[UNITS],AL		; SET DRIVE NUMBER
	MOV	DX,OFFSET BPB_ADR_TBL
	LDS	BX,[PTRSAV]		; SET PACKET ADRS
	MOV	[BX.MEDIA],AL		; SET DRIVE NUMBER
	MOV	[BX.COUNT],DX
	MOV	[BX.COUNT+2],CS
	JMP	NORMAL_EXIT
;
;===== BPB ADDRESS TABLE ======
;
BPB_ADR_TBL:
	DW	FDCB0.BPB,FDCB1.BPB		; 5"FD BPB ADDR.
	PAGE
;****************************************
;*
;*	MEDIA CHECK
;*
;*		COMMAND CODE (1)
;*
;****************************************
;
;
FD_MEDIA_CHK:
	CALL	SING_CHG		; CHECK SINGLE DRIVE
	CALL	SLCT_DCB		; SELECT DCB TABLE
	JC	MEDIA_CHK2		; BRANCH IF UNDEFINE
	CALL	M_CHK			; CHECK MEDIA CHANGE
	JC	MEDIA_CHK2		; BRANCH IF ERROR
	MOV	AL,1			; SET NO-CHANGE
	TEST	AH,F_ATN		; CHANGE ?
	JZ	MEDIA_CHK1		; NO,
	MOV	AL,0			; SET UNKNOWN
MEDIA_CHK1:
	LDS	BX,[PTRSAV]
	MOV	BYTE PTR [BX.TRANS],AL	; SET CHANGE/NO-CHANGE FLAG
	JMP	NORMAL_EXIT
;
MEDIA_CHK2:
	JMP	ERROR_EXIT
	PAGE
;****************************************
;*
;*	BUILD BPB
;*
;*		COMMAND CODE (2)
;*
;****************************************
;
;
FD_GET_BPB:
	CALL	SING_CHG		; CHECK SINGLE DRIVE
	CALL	SLCT_DCB		; SELECT DCB TABLE ADRS
	JC	GET_BPB1		; JUMP IF UNDEFINE
	CALL	BPB_IN			; BPB INPUT
	JC	GET_BPB1		; JUMP IF ERROR
	MOV	CL,[SI.BPB+10]		; GET MEDIA DESCRIPTOR
	LEA	AX,[SI.BPB]		; GET BPB OFFSET
	LDS	BX,[PTRSAV]		; SET PACKET ADRS
	MOV	[BX.MEDIA],CL		; SET MEDIA DESCRIPTOR
	MOV	[BX.COUNT],AX		; SAVE BPB ADRS
	MOV	[BX.COUNT+2],CS
	JMP	NORMAL_EXIT
;
GET_BPB1:
	JMP	ERROR_EXIT
	PAGE
;*****************************************
;*
;*	DISK READ
;*
;*		COMMAND CODE (4)
;*
;*****************************************
;
;
FD_DSK_READ:
	CALL	SING_CHG		; CHECK SINGLE DRIVE
	CALL	SLCT_DCB		; SELECT DCB TABLE
	JC	DSK_RD4			; JUMP IF UNDEFINE
	CALL	SET_UP			; SET UP PARAMETER
	JC	DSK_RD4			; JUMP IF ERROR
DSK_RD1:
	CMP	[C_SECT],0		; END OF COUNT ?
	JNE	DSK_RD2			; NO,
	JMP	NORMAL_EXIT		; NORMAL EXIT
DSK_RD2:
	CALL	SET_LENGTH		; SET TRANS LENGTH
	CALL	SCT_RD			; READ ONE LOGICAL SECTOR
	JC	DSK_RD3			; JUMP IF READ ERROR
	CALL	SCT_UP			; SECTOR COUNT UP
	JNC	DSK_RD1			; LOOP IF NOT ERROR
DSK_RD3:
	MOV	CX,[C_SECT]		; GET REMAIN COUNT
	LDS	BX,[PTRSAV]
	SUB	[BX.COUNT],CX		; SET TRANS COUNT
	JMP	ERROR_EXIT
DSK_RD4:
	LDS	BX,[PTRSAV]
	MOV	[BX.COUNT],0		; RESET TRANS COUNT
	JMP	ERROR_EXIT
	PAGE
;*****************************************
;*
;*	DISK WRITE
;*
;*		COMMAND CODE (8)
;*
;*****************************************
;
;
FD_DSK_WRIT:
	CALL	SING_CHG		; CHECK SINGLE DRIVE
	CALL	SLCT_DCB		; SELECT DCB TABLE ADRS
	JC	DSK_WR5			; JUMP IF UNDEFINE
	CALL	WP_CHK			; CHECK WRITE PROTECT
	JC	DSK_WR5			; JUMP IF ERROR
	CALL	SET_UP			; SET UP PARAMETER
	JC	DSK_WR5			; JUMP IF ERROR
DSK_WR2:
	CMP	[C_SECT],0		; END OF COUNT ?
	JNE	DSK_WR3			; NO,
	JMP	NORMAL_EXIT		; NORMAL EXIT
DSK_WR3:
	CALL	SET_LENGTH		; SET TRANS LENGTH
	CALL	SCT_WR			; WRITE ONE LOGICAL SECTOR
	JC	DSK_WR4			; JUMP IF ERROR
	CALL	SCT_UP			; SECTOR COUNT UP
	JNC	DSK_WR2			; LOOP IF NOT ERROR
DSK_WR4:
	MOV	CX,[C_SECT]		; GET REMAIN COUNT
	LDS	BX,[PTRSAV]
	SUB	[BX.COUNT],CX		; SET TRANS COUNT
	JMP	ERROR_EXIT
;
DSK_WR5:
	LDS	BX,[PTRSAV]
	MOV	[BX.COUNT],0		; RESET TRANS COUNT
	JMP	ERROR_EXIT
	PAGE
;****************************************
;*
;*	DISK WRITE WITH VERIFY
;*
;*		COMMAND CODE (9)
;*
;****************************************
;
;
FD_DSK_WRTV:
	CALL	SING_CHG		; CHECK SINGLE DRIVE
	CALL	SLCT_DCB		; SELECT DCB TABLE ADRS
	JC	DSK_WRV6		; JUMP IF UNDEFINE
	CALL	WP_CHK			; CHECK WRITE PROTECT
	JC	DSK_WRV6		; JUMP IF ERROR
	CALL	SET_UP			; SET UP PARAMETER
	JC	DSK_WRV6		; JUMP IF ERROR
DSK_WRV2:
	CMP	[C_SECT],0		; END OF COUNT ?
	JNE	DSK_WRV3		; NO,
	JMP	NORMAL_EXIT		; NORMAL EXIT
DSK_WRV3:
	CALL	SET_LENGTH		; SET TRANS LENGTH
	CALL	SCT_WR			; WRITE ONE LOGICAL SECTOR
	JC	DSK_WRV5		; JUMP IF ERROR
	CALL	VRFY			; VERIFY
	JC	DSK_WRV5
	CALL	SCT_UP			; SECTOR UP
	JNC	DSK_WRV2			; LOOP IF NOT ERROR
DSK_WRV5:
	MOV	CX,[C_SECT]		; GET REMAIN SECTOR
	LDS	BX,[PTRSAV]
	SUB	[BX.COUNT],CX		; SET TRANSFAR SECTOR
	JMP	ERROR_EXIT
;
DSK_WRV6:
	LDS	BX,[PTRSAV]
	MOV	[BX.COUNT],0		; RESET TRANSFAR SECTOR
	JMP	ERROR_EXIT
	PAGE
;****************************************************************
;*								*
;*		SUBROUTINES					*
;*								*
;*	BASIC INPUT/OUTPUT SEQUENCE				*
;*		INPUT	[DS:SI]	: DCB TABLE ADRS		*
;*		OUTPUT	[CF]=0	: NORMAL RETURN			*
;*			[CF]=1	: ERROR RETURN			*
;*			[AL]	: MS-DOS ERROR CODE		*
;*								*
;****************************************************************
;
;
;================================================
;	SELECT DEVICE CONTROL BLOCK
;		INPUT	[AL]	UNIT NO.
;			[AH]	DEVICE NO.
;		OUTPUT	[DS:SI]	DCB TABLE ADRS
;================================================
;
SLCT_DCB:
	PUSH	CS			; [DS] <== [CS]
	POP	DS
	MOV	[UN],AL			; SAVE UNIT NO.
;---------------------------------------------CHANGE JUN/12/84---------
	MOV	SI,OFFSET FDCB0
	CMP	AL,0
	JZ	SLCT_DCB0
	MOV	SI,OFFSET FDCB1
SLCT_DCB0:
;---------------------------------------------------------------------
	MOV	WORD PTR P_DCB,SI	; SAVE DCB POINTER
	MOV	WORD PTR P_DCB+2,DS
	CMP	[SI.SEN],-1		; DEVICE UNDEFINE ?
	JE	SLCT_DCB1		; YES,
	CLC				; [CF]=0
	RET
;
SLCT_DCB1:
	MOV	AL,01			; SET UNDEFINE DISK
	STC				; [CF]=1
	RET
;-----------------------------------DELETE DCB ADDRESS TABLE-JUN/12/84-
	PAGE
;
;=========================================
;
;	INITIALIZE DCB TABLE
;
;=========================================
;
INIT_DCB:
;-------------------------------------------------CHANGE JUN/12/84-----
	ASSUME	ES:SYSCOM
	MOV	BX,SYSCOM
	MOV	ES,BX
	MOV	CL,[UN]
	MOV	BX,1000H
	SHL	BX,CL
	TEST	BX,ES:[DISK_EQUIP]	; FD CONNECT ?
;----------------------------------------------------------------------
	JNZ	INIT_DCB1		; YES,
	ASSUME	ES:CODE
	MOV	[SI.SEN],-1		; SET UNDEFINE
	STC
	RET
;
INIT_DCB1:
	CALL	SENS			; SENSE COMMAND
	OR	AH,F_ATN		; MULTIPLEX ATTENTION FLAG
	MOV	[SI.SEN],AH		; SET SENSE STATUS
	AND	[SI.DAUA],NOT F_DBL	; RESET DOUBLE TRACK FLAG
	TEST	AH,F_2DD		; 2DD DRIVE ?
	JZ	INIT_DCB2		; NO,
	OR	[SI.DAUA],F_DBL		; SET DOUBLE TRACK FLAG
INIT_DCB2:
	CLC				; [CF]=0
	RET
;-----------------------------------DELETE EQUIP FLAG TABLE--JUN/12/84-
	PAGE
;
;==============================================
;
;	SINGLE DRIVE CHECK AND EXCHANGE DISK
;
;==============================================
;
SING_CHG	PROC	NEAR
;
	PUSH	AX			; SAVE REG.
	PUSH	BX
	PUSH	CX
;
	CMP	[NPHY0],0		; SINGLE DRIVE ?
	JNZ	SING8			; N
	CMP	AL,[CURSING_DISK]	; SAME DRIVE ?
	JZ	SING8			; Y
;
	MOV	[CURSING_DISK],AL	; EXCHANGE DRIVE NUMBER
	ADD	AL,'A'
	MOV	[DRIVE_CHR],AL
	MOV	BX,OFFSET SINGLE_MSG	; REQUEST EXCHANGE FLOPPY
	CALL	MSGL
;
SING2:
	MOV	AH,KB_FNC_RDND		; LOOP UNTIL KB FIFO EMPTY
	INT	KB_ROM			;	CHECK KB FIFO EMPTY
	JZ	SING3
	MOV	AH,KB_FNC_READ		;	GET DATA
	INT	KB_ROM
	JMP	SING2
SING3:
	MOV	AH,KB_FNC_RDND		; WAIT UNTIL KEY IN
	INT	KB_ROM
	JZ	SING3
;
	CMP	AL,03H			; CNTL-C ?
	JZ	SING5			; N
	MOV	AH,KB_FNC_READ		;	GET DATA
	INT	KB_ROM
SING5:
SING8:
	POP	CX			; RESTORE REG.
	POP	BX
	POP	AX
	RET
;
SINGLE_MSG	DB	CR,LF
		DB	'Insert disk drive '
DRIVE_CHR	DB	?,':',CR,LF
		DB	' and strike any key when ready'
		DB	CR,LF,0
SING_CHG	ENDP
	PAGE
;
;**********************************************
;
;	CHECK MEDIA CHANGE
;		OUTPUT	[AH] : SENSE STATUS
;
;**********************************************
;
M_CHK:
	CALL	SENS			; SENSE COMMAND
	JNC	M_CHK0			; JUMP IF NO ERROR
	OR	[SI.SEN],F_ATN		; SET ATTENTION FLAG
	JMP	ERROR
M_CHK0:
	MOV	AL,[SI.SEN]		; GET OLD STATUS
	AND	AL,F_ATN
	OR	AH,AL			; MULTIPLEX OLD ATTENTION
;
	MOV	AL,10H			; SET #0 AI
	MOV	CL,[SI.DAUA]
	AND	CL,0FH
	SHL	AL,CL			; SET #N AI FLAG
	PUSH	DS
;
	ASSUME	DS:SYSCOM
	MOV	BX,SYSCOM
	MOV	DS,BX
	TEST	DS:DISK_AI,AL		; ATTENTION INTERRUPT ?
	ASSUME	DS:CODE
	POP	DS
	JZ	M_CHK1			; NO,
	OR	AH,F_ATN		; SET ATTENTION FLAG
M_CHK1:
	MOV	[SI.SEN],AH		; SAVE NEW STATUS
	CLC				; [CF]=0
	RET
	PAGE
;
;**********************************************
;
;	BPB INPUT FROM DISK
;
;**********************************************
;
BPB_IN:
	LES	DI,[PTRSAV]
	LES	DI,ES:[DI.TRANS]	; GET FAT TABLE ADDRESS
	MOV	AL,ES:[DI]		; GET MEDIA DESCRIPTOR
	PUSH	AX			; SAVE IT
	CALL	BPB_CHK			; CHECK MEDIA DESCRIPTOR
	POP	AX
	JC	IBM2			; JUMP IF ERROR
	MOV	SI,OFFSET BPB_TBL	; SET BPB TABLE ADRS
	MOV	CX,6			; SET LOOP COUNT
IBM1:
	CMP	AL,[SI+10]		; EQUAL MEDIA DESCRIPTOR
	JE	BPB_IN0			; YES,
	ADD	SI,13			; NEXT BPB TABLE
	LOOP	IBM1
	MOV	AL,12			; SET DISK ERROR
IBM2:
	STC				; [CF]=1
	RET
BPB_IN0:
	LES	DI,[P_DCB]		; [ES:DI] <-- BPB SAVE ADRS
	ADD	DI,BPB
	MOV	CX,13			; [CX] <-- BPB SIZE
	CLD
	REP	MOVSB
;
	MOV	AL,10H			; SET #0 AI
	LDS	SI,CS:[P_DCB]		; RESTORE DCB PTR
	MOV	CL,[SI.DAUA]
	AND	CL,0FH
	SHL	AL,CL
	NOT	AL
	ASSUME	DS:SYSCOM
	MOV	BX,SYSCOM
	MOV	DS,BX
	AND	DS:DISK_AI,AL		; RESET ATTENTION INTERRUPT
	ASSUME	DS:CODE
	LDS	SI,CS:[P_DCB]		; RESTORE DCB PTR
	AND	[SI.SEN],NOT F_ATN	; RESET ATTENTION FLAG
	CLC				; [CF]=0
BPB_IN1:
	RET
;
BPB_IN2:
	JMP	ERROR
	PAGE
;
;*****************************************
;
;	CHECK BPB
;
;*****************************************
;
;
BPB_CHK:
	MOV	BX,OFFSET MEDIA_TBL	; SET MEDIA TYPE TABLE
	MOV	CL,6			; SET LOOP COUNT
BPB_CHK1:
	CMP	AL,[BX]			; EQUAL MEDIA TYPE ?
	JE	BPB_CHK3		; YES,
	ADD	BX,4
	DEC	CL			; END OF SEARCH ?
	JNZ	BPB_CHK1		; NO,
BPB_CHK2:
	MOV	AL,12			; SET DISK ERROR
	STC				; [CF]=1
	RET
;
BPB_CHK3:
	MOV	AH,[BX+1]		; GET (CNE),(HNE),(SNE)
	MOV	DX,WORD PTR [BX+2]
	TEST	[SI.SEN],F_2DD		; 2DD DEVICE ?
	JNZ	BPB_CHK5		; YES,
	CMP	AH,39			; 39 CYLINDER ?
	JNE	BPB_CHK2		; NO,
BPB_CHK4:
	MOV	[SI.CNE],AH		; SAVE (CNE),(HNE),(SNE)
	MOV	WORD PTR [SI.HNE],DX
	CLC				; [CF]=0
	RET
;
BPB_CHK5:
	CMP	AL,0FFH			; 2D(8) ?
	JE	BPB_CHK51		; YES,
	CMP	AL,0FDH			; 2D(9) ?
	JNE	BPB_CHK52		; NO,
BPB_CHK51:
	AND	[SI.DAUA],NOT F_DBL	; RESET DOUBLE TRACK FLAG
	JMP	BPB_CHK4
BPB_CHK52:
	CMP	AH,79			; 79 CYLINDER
	JNZ	BPB_CHK2		; NO,
	OR	[SI.DAUA],F_DBL		; SET DOUBLE TRACK FLAG
	JMP	BPB_CHK4
;
;
MEDIA_TBL:	; MD CN HN SN
	DB	0FEH,39,00,08		;  1D(8)
	DB	0FCH,39,00,09		;  1D(9)
	DB	0FFH,39,01,08		;  2D(8)
	DB	0FDH,39,01,09		;  2D(9)
	DB	0FBH,79,01,08		; 2DD(8)
	DB	0F9H,79,01,09		; 2DD(9)
	PAGE
;
;*********************************************
;
;	CHECK WRITE PROTECT
;
;*********************************************
;
;
WP_CHK:
	TEST	[SI.SEN],F_2DD		; 2DD DRIVE ?
	JZ	WP_CHK1			; NO,
	MOV	AL,10			; SET WRITE FAULT ERROR
	TEST	[SI.DAUA],F_DBL		; 2D DISK ?
	JZ	WP_CHK2			; YES,
WP_CHK1:
	CLC				; [CF]=0
	RET
;
WP_CHK2:
	STC				; [CF]=1
	RET
	PAGE
;*********************************************
;*
;*	SET UP PARAMETER
;*
;*********************************************
;
SET_UP:
	LDS	BX,[PTRSAV]		; SET PACKET ADRS
	LES	DI,[BX.TRANS]		; GET TRANS BUFFER ADRS
	MOV	CX,[BX.COUNT]		; GET TRANS COUNT
	MOV	AX,[BX.START]		; GET START ADRS
	LDS	SI,CS:P_DCB		; SET DCB ADRS6
	MOV	[SI.DTA],DI		; SAVE TRANS BUFF ADRS
	MOV	[SI.DTS],ES
	MOV	C_SECT,CX		; SAVE TRANS COUNT
;
;============================================
;	CONVERT TO PHYSICAL SECTOR
;============================================
;
;
CVT_SCT:
	MOV	CL,[SI.SNE]		; SET MAXIMUM SECTOR NUMBER
	DIV	CL			; (LOGICAL)/(SNE)
	INC	AH			; (SN)++
	XOR	CL,CL			; (HN):=0
	CMP	[SI.HNE],0		; DOUBLE SIDE ?
	JE	CVT_SCT1		; NO,
	SHR	AL,1			; (SN)/2
	RCL	CL,1			; SET (HN)
CVT_SCT1:
	CMP	AL,[SI.CNE]		; (CN) OVER	?
	JBE	CVT_SCT2		; NO,
	MOV	AL,8			; SET SECTOR OVER
	STC				; [CF]=1
	RET
;
CVT_SCT2:
	MOV	[SI.CN],AL		; SAVE (CN),(HN),(SN)
	MOV	[SI.HN],CL
	MOV	[SI.SN],AH
	MOV	[SI.SL],2
	CLC				; [CF]=0
	RET
	PAGE
;
;*******************************************
;
;	SET TRANS LENGTH
;
;*******************************************
;
SET_LENGTH:
;------------------------------------------------CHANGE JUN/12/84------
;===============GET REMAIN MEMORY TO 64KB BOUNDARY (SECTOR BOUNDARY)===
	MOV	AX,[SI.DTS]		; AX = (DTS)*16+(DTA)
	MOV	CL,4
	SHL	AX,CL
	ADD	AX,[SI.DTA]
	NEG	AX			; AX = 64KB - AX
	JNZ	SET_LENGTH1		; DECREMENT IF JUST 64KB
	DEC	AX			; AX=65535
SET_LENGTH1:
	MOV	DX,0
	DIV	WORD PTR [SI.BPB]	; DEVIDE SECTOR SIZE
;========================GET REMAIN SECTORS IN TRACK =========
	MOV	BL,[SI.SNE]
	INC	BL
	SUB	BL,[SI.SN]
	MOV	BH,0
;=======================SELECT SMALL VALUE ===========
	CMP	AX,BX			; 64KB BOUNDARY =< SAME TRACK SECTORS
	JBE	SET_LENGTH2		; YES,
	MOV	AX,BX
SET_LENGTH2:
	MOV	CX,[C_SECT]
	CMP	AX,CX			;    =< REMAIN SECTORS
	JBE	SET_LENGTH3		; YES,
	MOV	AX,CX
SET_LENGTH3:
	MOV	[C_TRNS],AX
	MUL	WORD PTR [SI.BPB]
	MOV	[SI.DTL],AX		; SET DATA LENGTH
;----------------------------------------------------------------------
	RET
	PAGE
;**************************************************
;	SECTOR UPDATE
;		UPDATE TRANS BUFF ADRS
;		DECREMENT LOGICAL SECTOR
;		INCREMENT PHYSICAL SECTOR
;**************************************************
;
SCT_UP:
	MOV	AX,[SI.DTL]
	ADD	[SI.DTA],AX		; (DTA):=(DTA)+(DTL)
;-----------------------------------------------INSERT JUN/12/84-------
	JNC	SCT_UP0
	ADD	[SI.DTS],1000H
SCT_UP0:
;----------------------------------------------------------------------
	MOV	AX,C_TRNS		; (SECT):=(SECT)-(TRNS)
	SUB	C_SECT,AX
	JNZ	SCT_UP1			; JUMP IF NOT END
	CLC				; [CF]=0
	RET
;
SCT_UP1:
	ADD	[SI.SN],AL		; (SN):=(SN)+(TRNS)
	MOV	AL,[SI.SNE]
	CMP	AL,[SI.SN]		; SECTOR OVER ?
	JAE	SCT_UP2			; NO,
	SUB	[SI.SN],AL		; (SN):=(SN)-(SNE)
	INC	[SI.HN]			; (HN)++
	MOV	AL,[SI.HN]
	CMP	AL,[SI.HNE]		; HEAD OVER ?
	JBE	SCT_UP2			; NO,
	MOV	[SI.HN],0		; (HN):=0
	INC	[SI.CN]			; (CN)++
	MOV	AL,[SI.CN]
	CMP	AL,[SI.CNE]		; (CN) OVER ?
	JBE	SCT_UP2			; NO,
	MOV	AL,8			; SET SECTOR OVER
	STC				; [CF]=1
	RET
;
SCT_UP2:
	CLC				; [CF]=0
	RET
	PAGE
;
;**********************************************
;
;	READ ONE LOGICAL SECTOR
;
;**********************************************
;
SCT_RD:
;----------------------------------------------CHANGE JUN/12/84----
	CMP	[C_TRNS],0		; 64KB BOUNDARY ?
	JZ	SCT_RD1			; YES,
;-------------------------------------------------------------------
	CALL	READ			; READ COMMAND
	JC	SCT_RD2
	RET
;
SCT_RD1:
;--------------------------------------------CHANGE JUN/12/84------
	INC	[C_TRNS]		; READ ONE TRACK
	MOV	CX,WORD PTR [SI.BPB]
	MOV	[SI.DTL],CX

	MOV	DI,[SI.DTA]
	AND	DI,000FH
	MOV	AX,[SI.DTA]
	MOV	CL,4
	SHR	AX,CL
	ADD	AX,[SI.DTS]
	MOV	ES,AX
;-------------------------------------------------------------------
	PUSH	ES
	PUSH	DI
	LES	DI,CS:[DSK_BUF_ADR]
	MOV	[SI.DTA],DI		; (DTA) <-- DSK_BUF
	MOV	[SI.DTS],ES
	CALL	READ			; READ COMMAND
	POP	DI
	POP	ES
	MOV	[SI.DTA],DI		; RESTORE (DTA)
	MOV	[SI.DTS],ES
	JC	SCT_RD2
	MOV	CX,[SI.DTL]		; SET DATA LENGTH
	LDS	SI,CS:[DSK_BUF_ADR]	; SET SOURCE ADRS
	CLD
	REP	MOVSB
	LDS	SI,CS:[P_DCB]		; RESTORE DCB POINTER
	CLC				; [CF]=0
	RET
;
SCT_RD2:
	JMP	ERROR
	PAGE
;
;********************************************
;
;	WRITE ONE LOGICAL SECTOR
;
;********************************************
;
SCT_WR:
;------------------------------------------------CHANGE JUN/12/84-----
	CMP	[C_TRNS],0		; 64KB BOUNDARY ?
	JZ	SCT_WR1
;---------------------------------------------------------------------
	CALL	WRIT			; WRITE COMMAND
	JC	SCT_WR2
	RET
;
SCT_WR1:
;----------------------------------------------CHANGE JUN/12/84-----
	INC	[C_TRNS]		; WRITE ONE TRACK
	MOV	CX,WORD PTR [SI.BPB]
	MOV	[SI.DTL],CX

	MOV	AX,[SI.DTA]
	MOV	CL,4
	SHR	AX,CL
	ADD	AX,[SI.DTS]
	MOV	CX,[SI.DTL]
	MOV	SI,[SI.DTA]
	AND	SI,000FH
	MOV	DS,AX
;-------------------------------------------------------------------
	LES	DI,CS:[DSK_BUF_ADR]	; TO DSK_BUF
	CLD
	REP	MOVSB
	LDS	SI,CS:[P_DCB]		; RESTORE DCB POINTER
	LES	DI,DWORD PTR [SI.DTA]	; SAVE (DTA)
	PUSH	ES
	PUSH	DI
	LES	DI,CS:[DSK_BUF_ADR]	; (DTA) <-- DSK_BUF
	MOV	[SI.DTA],DI
	MOV	[SI.DTS],ES
	CALL	WRIT			; WRITE COMMAND
	POP	DI
	POP	ES
	MOV	[SI.DTA],DI		; RESTORE (DTA)
	MOV	[SI.DTS],ES
	JC	SCT_WR2
	RET
;
SCT_WR2:
	JMP	ERROR
;---------------------------------------DELETE module "DBCHK" JUN/12/84
	PAGE
;***************************************************
;	CONVERT TO MS-DOS ERROR
;		INPUT	[AH] : ROM BIOS ERROR CODE
;		OUTPUT	[AL] : MS-DOS ERROR CODE
;***************************************************
;
ERROR:
	MOV	AL,AH
	MOV	CL,4
	SHR	AL,CL
	MOV	BX,OFFSET ERR_TBL	; SET ERROR TABLE
	XLAT	BYTE PTR CS:[BX]	; GET MS-DOS ERROR CODE
	STC				; [CF]=1
	RET
;
ERR_TBL:
	DB	12,12,12,12,02,00,12,12,12,12,04,04,06,08,08,08
	PAGE
;
;*******************************************
;
;	DISK I/O COMMAND
;
;*******************************************
;
;
READ:
	MOV	AH,76H			; SET READ COMMAND
	JMP	SHORT RTRY
WRIT:
	MOV	AH,75H			; SET WRITE COMMAND
	JMP	SHORT RTRY
VRFY:
	MOV	AH,71H			; SET VERIFY COMMAND
;
RTRY:
	MOV	[SI.BCMD],AH		; SAVE COMMAND CODE
	MOV	AL,[SI.DAUA]		; SET PARAMETER
	MOV	CL,[SI.CN]
	MOV	DH,[SI.HN]
	MOV	DL,[SI.SN]
	MOV	CH,[SI.SL]
	MOV	BX,[SI.DTL]
	LES	BP,DWORD PTR [SI.DTA]
;
	MOV	C_RCBL,3		; SET RECALIBRATE COUNT
RTRY1:
	MOV	C_RTRY,8		; SET RETRY COUNT
RTRY2: 
	MOV	AH,[SI.BCMD]		; SET COMMAND
	INT	FD_ROM
	MOV	[SI.STS],AH		; SAVE RETURN STATUS
	JNC	RTRY4			; JUMP IF NORMAL END
	CMP	AH,60H			; CANNOT RETRY ?
	JB	RTRY3			; YES,
	DEC	C_RTRY			; (RTRY)--
	JNZ	RTRY2
	DEC	C_RCBL			; (RCBL)--
	JZ	RTRY3
	MOV	AH,27H			; SET RECALIBRATE COMMAND
	INT	FD_ROM
	MOV	[SI.STS],AH		; SAVE RETURN STATUS
	JNC	RTRY1
RTRY3:
	STC				; [CF]=1
RTRY4:
	RET
;
SENS:
	MOV	AH,24H			; SET SENSE COMMAND
	MOV	[SI.BCMD],AH
	MOV	AL,[SI.DAUA]
	INT	FD_ROM
	MOV	[SI.STS],AH		; SAVE RETURN STATUS
	RET
;
;
CODE	ENDS
	END

