		PAGE	60,132
		TITLE	IPL_FD
		.LFCOND
;****************************************************************
;*
;*	IPL_FD
;*
;****************************************************************

DSKIO		EQU	1DH	; FD INT. VECTOR
DISK_BOOT	EQU	402H	; BOOTED DA/UA


CODE	SEGMENT	WORD PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:IPL,ES:IPL,SS:IPL

IPL_FD:

	JMP	IPL1

	DB	'NEC 2.00'		;OEM NAME

	;BPB
	; EXAMPLE 5"2DD(8)
	; REWRITE BY FORMOEM MODULE
	;
SEC_L	DW	512			;SECTOR LENGTH
	DB	2			;SECTOR / ALLOCATION UNIT
	DW	1			;RESERVE SECTOR
	DB	2			;FATS
	DW	112			;DIRECTORY ENTRY
	DW	8*2*80			;VOLUME SIZE
	DB	0FBH			;FAT ID
	DW	2			;SECTOR / FAT
	DW	8			;SECTOR / TRACK
	DW	2			;HEADS
	DW	0			;HIDDEN SECTOR

IPL1:

	XOR	BX,BX
	MOV	ES,BX
	MOV	ES:AX_IPL,AX
	MOV	AX,DS
	MOV	ES:DS_IPL,AX
	MOV	AX,SS
	MOV	ES:SS_IPL,AX
	MOV	ES:SP_IPL,SP
	MOV	AX,BX
	MOV	DS,AX

	MOV	SS,AX			;SS <- 0000H
	MOV	SP,OFFSET IPL_STACK	;SET STACK

	CLD
	MOV	SI,OFFSET SEC_L - OFFSET IPL_FD
	LODS	WORD PTR CS:[SI]	;GET SECTOR LENGTH
	JMP	SHORT NOT_81
DATA_DSK:

DSP_MSG:

;
;	ERROR RETURN
;
	XOR	AX,AX
	MOV	ES,AX
	MOV	AX,ES:DS_IPL
	MOV	DS,AX
	MOV	AX,ES:SS_IPL
	MOV	SS,AX
	MOV	SP,ES:SP_IPL
	MOV	AX,ES:AX_IPL
XXX	PROC	FAR
	RET
XXX	ENDP

IO_SYS		DB	'IO      SYS'
MS_DOS		DB	'MSDOS   SYS'

NOT_81:
	CMP	WORD PTR CS:[SI+13],1	;5"1D ?
	JE	DATA_DSK		;Y
	MOV	AL,DS:DISK_BOOT
	MOV	DISK_BOOT_D,AL
	TEST	BYTE PTR CS:[SI+08],00000100B
	JNZ	NOT_DD_ACC
	OR	BYTE PTR DISK_BOOT_D,40H	;SET DD ACCESS BIT
NOT_DD_ACC:
	MOV	AL,DS:DISK_BOOT_D	;GET BOOT DA/UA
	AND	AL,0F0H			;GET DA
	MOV	BX,512			;SET SECTOR LENGTH
	MOV	FST_SEC,0105H		;SET FIRST SECTOR OF DATA AREA
	MOV	DIR_SEC,0006H		;SET FIRST SECTOR OF DIRECTORY
	MOV	FST_L,512*4		;SET FIRST I/O LENGTH
	MOV	TRK_L,512*8		;SET TRACK LENGTH
	MOV	CH,2			;SET SECTOR LENGTH FOR ROM
	CMP	BYTE PTR CS:[SI+08],0F9H	;5"2DD(9) ?
	JNE	NOT_59			;N
	MOV	FST_SEC,0106H
	MOV	DIR_SEC,0008H
	MOV	TRK_L,512*9
NOT_59:
	CMP	AL,40H			;5"2DD ?
	JE	CMN_P			;Y
	MOV	FST_L,512*6
	MOV	DIR_SEC,0004H
	MOV	FST_SEC,0103H
	CMP	BYTE PTR CS:[SI+08],0FDH	; 5"2D(9) ?
	JNE	CMN_P
	MOV	DIR_SEC,0006H
	MOV	TRK_L,512*9
	MOV	FST_SEC,0104H
CMN_P:
	MOV	BP,OFFSET BUFF		;SET BUFFER ADDRESS
	MOV	CL,0			;SET CYLINDER #
	MOV	DX,DIR_SEC		;SET HEAD # & SECTOR #
	MOV	AL,DS:DISK_BOOT_D	;SET DA/UA
	CALL	READ			;READ DIRECTORY
	PUSH	DS
	PUSH	CS
	POP	DS			;DS <- CS
	PUSH	CX
	MOV	CX,11			;STRING LENGTH
	MOV	SI,OFFSET IO_SYS - OFFSET IPL_FD
	MOV	DI,OFFSET BUFF
	CMP	BYTE PTR ES:[DI+11],08H	;VOLUME LABEL ?
	JNE	NOT_VOL1		;N
	ADD	DI,32			;NEXT ENTRY
NOT_VOL1:
	REPE	CMPSB			;CHECK IO.SYS
	JE	MS_CHK
NOT_SYS:
	POP	CX
	POP	DS
	JMP	DSP_MSG
MS_CHK:
	MOV	DI,OFFSET BUFF + 32
	MOV	CX,11
	CMP	BYTE PTR ES:[DI-21],08H	;VOLUME LABEL ?
	JNE	NOT_VOL2		;N
	ADD	DI,32			;NEXT ENTRY
NOT_VOL2:
	REPE	CMPSB			;CHECK MSDOS.SYS
	JNE	NOT_SYS
	POP	CX
	POP	DS

	MOV	SI,1024*62		;READ LENGTH
	MOV	BX,FST_L		;SET TRANSFER LENGTH
	MOV	DX,FST_SEC		;SET HEAD # & SECTOR #
	MOV	BP,OFFSET BUFF		;SET BUFFER
	MOV	AL,DS:DISK_BOOT_D	;SET DA/UA
	CALL	READ
	MOV	DL,1			;SET SECTOR #1
L_READ:
	CALL	SET_UP1
	OR	SI,SI
	JZ	READ_DONE
	CALL	READ
	CALL	SET_UP2
	OR	SI,SI
	JZ	READ_DONE
	CALL	READ
	JMP	L_READ
READ_DONE:
	MOV	LEAP_ADR,0000H
	MOV	LEAP_ADR+2,0060H
	JMP	DWORD PTR LEAP_ADR

READ:
	MOV	RTRY_CNT,10
RTRY_R:
	MOV	AH,0F6H			;SET READ COMMAND
	INT	DSKIO			;CALL DSK BIOS
	JNC	R_RET
	DEC	RTRY_CNT
	JZ	IO_ERR
	MOV	AH,07H
	INT	DSKIO			;RECABLIRATE
	JMP	RTRY_R
R_RET:
	RET
IO_ERR:
	POP	AX			;DUMMY POP
	JMP	DSP_MSG

SET_UP1:
	INC	CL			;NEXT CYLINDER
SET_UP2:
	XOR	DH,1			;FLIP HEAD
	ADD	BP,BX
	SUB	SI,BX
	MOV	BX,TRK_L
	CMP	SI,BX
	JAE	LENG_OK
	MOV	BX,SI
LENG_OK:
	RET

	ORG	512 - 1
	DB	0		; IPL_FD SIZE must be 512 byte

CODE	ENDS

IPL	SEGMENT	AT 0000H
	ORG	200H
LEAP_ADR	DW	2 DUP(?)
FST_SEC		DW	?
DIR_SEC		DW	?
FST_L		DW	?
TRK_L		DW	?
RTRY_CNT	DB	?
DISK_BOOT_D	DB	?
	EVEN
		DW	64 DUP(?)
IPL_STACK	LABEL	WORD
DS_IPL		DW	?
SS_IPL		DW	?
SP_IPL		DW	?
AX_IPL		DW	?

	ORG	600H
BUFF	LABEL	BYTE

IPL	ENDS

	END
