;
BANG:	EQU	FALSE		;True enables BitBanger support
SMORG:	EQU	TRUE		;True enables System Support Board
INTER3:	EQU	TRUE		;True to include Interfacer 3 support
INTER1:	EQU	true		;True to include Interfacer 1 support
GBC10	EQU	FALSE		;True to include Disk 2 10 megabyte
GBC20	EQU	false		;True to include Disk 2 20 megabyte
GBC26	EQU	FALSE		;True to include Disk 2 26 megabyte
HARD	EQU	GBC10 OR GBC20 OR GBC26 ;True to include hard disk code
ORDER	EQU	0		;0 for floppy A,B hard C,D
				;1 for hard A,B floppy C,D
	if	@ldr = 0
HDRIVE	EQU	true		;True to include M-DRIVE/H support
	else
HDRIVE	EQU	FALSE
	endif
 GBCBIOS A86   j k              GBCBIOS0A86                    	PAGE
DELCNT:	EQU	5*1000		;Delay count for 8 mhz CPU

CR:	EQU	0Dh
LF:	EQU	0Ah
BELCHR:	EQU	07
EOS:	EQU	0
CLRSCR:	EQU	1AH	;TeleVideo clear screen code
K:	EQU	1024

BDOSINT	=	224	;BDOS Interrupt number
OPTS	=	40h	;board option switches (by Boot)

	ORG	408h
TICKH	DS	2	;Banger parameters
OPTSH	DS	1	;OPT_SW


ALIGN	MACRO	BITS
	ORG	(*+(%1)-1) / (%1) * (%1)
	ENDM


;	CP/M to host disk constants

HSTSIZ:	EQU	1024		;Blocking/Deblocking buffer size
CPMSIB:	EQU	1024/128	;Standard sectors in block
FPYSIB:	EQU	2048/128	;Sectors in floppy disk block
HMDSIB:	EQU	2048/128	;Sectors in Memory drive block
HRDSIB:	EQU	4096/128	;Sectors in hard disk block

;	CP/M disk control block equates which define the
;	disk types and maximum storage capability of each
;	disk type.

DSKS1:	EQU	0		;Single density, single sided.
DSKS2:	EQU	1		;Single density, double sided.
DSKD1:	EQU	2		;Double density, single sided.
DSKD2:	EQU	3		;Double density, double sided.
DSKD3:	EQU	4		;Double density, single sided
DSKD4:	EQU	5		;Double density, double sided
DSKD5:	EQU	6		;Double density, single sided
DSKD6:	EQU	7		;Double density, double sided
MAXFTP:	EQU	DSKD6		;Maximum floppy type
HMDTYP:	EQU	128		;M-DRIVE/H type (always 128 for MFORM)
	if	gbc20
DSK8F1:	EQU	8	;Fujitsu 20 megabyte first 8 megabytes
DSK8F2:	EQU	9	;Fujitsu 20 megabyte second 8 megabytes
DSK8F3:	EQU	10	;Fujitsu 20 megabytes last 4 megabytes
	endif
	if	gbc10
DSK8M1:	EQU	8	;Fujitsu 10 megabyte first 8 megabytes
DSK8M2:	EQU	9	;Fujitsu 10 megabyte second 8 megabytes
	ENDIF
	if	gbc26
DSK4S1:	EQU	8	;Shugart 26 megabyte first 8 megabytes
DSK4S2:	EQU	9	;Shugart 26 megabyte second 8 megabytes
DSK4S3:	EQU	10	;Shugart 26 megabytes third 8 megabytes
DSK4S4:	EQU	11	;Shugart 26 megabyte last 2 megabytes
	endif

S1DSM:	EQU	((77-2)*26)/CPMSIB
S2DSM:	EQU	((77-2)*2*26)/FPYSIB
D1DSM:	EQU	((77-2)*2*26)/FPYSIB
D2DSM:	EQU	((77-2)*2*2*26)/FPYSIB
D3DSM:	EQU	((77-2)*4*15)/FPYSIB
D4DSM:	EQU	((77-2)*2*4*15)/FPYSIB
D5DSM:	EQU	((77-2)*8*8)/FPYSIB
D6DSM:	EQU	((77-2)*2*8*8)/FPYSIB
F81DSM:	EQU	(8*(94-1)*8*11)/HRDSIB
F82DSM:	EQU	(8*(93-0)*8*11)/HRDSIB
F83DSM:	EQU	(8*(57-0)*8*11)/HRDSIB
M81DSM:	EQU	(4*(123-1)*8*11)/HRDSIB
M82DSM:	EQU	(4*(121-0)*8*11)/HRDSIB
S41DSM:	EQU	(8*(57-1)*8*16)/HRDSIB		
S42DSM:	EQU	(8*(56-0)*8*16)/HRDSIB		
S43DSM:	EQU	(8*(56-0)*8*16)/HRDSIB		
S44DSM:	EQU	(8*(33-0)*8*16)/HRDSIB		
HMDDSM:	EQU	((512-4)*8)/HMDSIB		

;	BDOS constants on entry to write

WRALL:	EQU	0		;write to allocated
WRDIR:	EQU	1		;write to directory
WRUAL:	EQU	2		;write to unallocated
	PAGE
;	Macro for generating Control Blocks for disk drives
;	The format of these disk control blocks are as follows:
;	16 bits = -> translation table.
;	48 bits = Work area for CP/M.
;	16 bits = -> DIRBUF.
;	16 bits = -> Parameter block.
;	16 bits = -> check vector.
;	16 bits = -> allocation vector.

NDSK:	SET	0		;Number of disk drives
NOHRD:	SET	0		;Number of hard disk drives
NOFDD:	SET	0		;Number of floppy disk drives
ngbc10	set	0		;Number of 10 megabyte hard disks
ngbc20	set	0		;Number of 20 megabyte hard disks
ngbc26	set	0		;Number of 26 megabyte hard disks
NOHMEM:	SET	0		;Number of up to 2 megabyte memory disks 
DPHNUM:	SET	0		
ALVS:	SET	0		;Allocation vector size
CSVS:	SET	0		;Check vector size

DPHGEN	MACRO	NUMBER,TYPE,XLATE,DIRBUF,DPBADR
	IF	%2 <= MAXFTP
	DB	NOFDD
	ELSE
 	IF	%2 < HMDTYP
	DB	NOHRD / DRVTYP	
	ELSE
	IF	%2 = HMDTYP
	DB	NOHMEM
	ENDIF
	ENDIF
	ENDIF
NDSK:	SET	NDSK+1
DPHNUM:	SET	DPHNUM+1
DRV%1:	SET	DPHNUM	
	DW	%3
	DW	0,0,0
	DW	%4
	DW	%5
	DW	CSV+CSVS
	DW	ALV+ALVS
.type	IF	%2 <= MAXFTP
NOFDD:	SET	NOFDD+1
CSVS:	SET	CSVS+(256/4)
ALVS:	SET	ALVS+((D6DSM+7)/8)
.type	else	
.type	IF	%2 < HMDTYP
NOHRD:	SET	NOHRD+1
CSVS:	SET	CSVS+0
	IF	GBC20
	IF	%2 = DSK8F1
ngbc20	set	ngbc20+1
ALVS:	SET	ALVS+((F81DSM+7)/8)
	ENDIF
	IF	%2 = DSK8F2
ALVS:	SET	ALVS+((F82DSM+7)/8)
	ENDIF
	IF	%2 = DSK8F3
ALVS:	SET	ALVS+((F83DSM+7)/8)
	ENDIF
	ENDIF
	IF	GBC10
	IF	%2 = DSK8M1
ngbc10	set	ngbc10+1
ALVS:	SET	ALVS+((M81DSM+7)/8)
	ENDIF
	IF	%2 = DSK8M2
ALVS:	SET	ALVS+((M82DSM+7)/8)
	ENDIF
	ENDIF
	IF	GBC26
	IF	%2 = DSK4S1
ngbc26	set	ngbc26+1
ALVS:	SET	ALVS+((S41DSM+7)/8)
	ENDIF
	IF	%2 = DSK4S2
ALVS:	SET	ALVS+((S42DSM+7)/8)
	ENDIF
	IF	%2 = DSK4S3
ALVS:	SET	ALVS+((S43DSM+7)/8)
	ENDIF
	IF	%2 = DSK4S4
ALVS:	SET	ALVS+((S44DSM+7)/8)
	ENDIF
	ENDIF
.type	else
.type	IF %2 = HMDTYP
NOHMEM:	SET	NOHMEM+1
CSVS:	SET	CSVS+0
ALVS:	SET	ALVS+(((HMDDSM*8)+7)/8)
.type	ENDIF
.type 	ENDIF		
.type	ENDIF
	ENDM
	space	4,10
;	Macro for generating the Disk Parameter Blocks.
;
;	Disk type definition blocks for each particular mode.
;	The format of these areas are as follow:
;	8 bit = disk type code
;	16 bit = Sectors per track
;	8 bit  = Block shift
;	8 bit  = BS mask
;	8 bit  = Extent mask
;	16 bit = Disk size/1024 - 1.
;	16 bit = Directory size.
;	16 bit = Allocation for directory.
;	16 bit = check area size.
;	16 bit = offset to first track.

DPBGEN	MACRO	TYPE,SPT,BSH,BSM,EXM,DSM,DIRSIZ,ALVMSK,OFFSET
	DB	%1
	DW	%2
	DB	%3,%4,%5
	DW	%6-1,%7-1,REV (%8)
.hrd	IF	%1 <= MAXFTP
	DW	(%7+3)/4
	else
	DW	0
.hrd	ENDIF
	DW	%9
	ENDM

;
;	macro for generating the drive selection masks
;
maskgen	MACRO	drvcnt,logphy
	ECHO	%1
	ECHO	%2
	db	mask
	ENDM
mask	set	mask+1
	ENDM
	ENDM
	page
;	CP/M86 memory organization:
;
;	0000:	0000	+-----------------------+	Absolute
;			|  Interrupt vectors	|
;		0400	|  Transfer area	|
;		040F	+-----------------------+
;
;	SysSeg:		+-----------------------+	410 nominal
;	     0000	|			|
;			|	CCP 88		|
;	     0AFF	|			|
;			+-----------------------+
;	     0B00	|			|
;			|	BDOS 88		|
;	     24FF	|			|
;			+-----------------------+
;	     2500	|			|
;			|	BIOS 88		|
;			|			|
;	     2E00	+-----------------------+
;			|     uninit storage	|
;	     3400	+-----------------------+	3810
;
;
;	LdrSeg:		+-----------------------+	4000 normal
;	     0000	|			|
;			|	LdCpm		|
;	     03FF	|			|
;			+-----------------------+
;	     0400	|			|
;			|	LdBdos		|
;	     11FF	|			|
;	  F
 PF ^;u   PvF
 P PF PF P ^P P1 P* u  P*p u   P*Fv PXgF uY F PF PF
 PF PF P

 PF ^;r 6 PX
 6 PX  ]ø ]Ë]
F PF P Y^P  PF P PvF P ^P P0 P) u  P)p ui  Pe0 Pt)  u
 PF0,  PR) u
 P$0
 P0P
0  ]ø ]Ë]F P YPF ^P  PF PF P PF PF P PF P  F6VF ^;r+ Pv PF PF PF P
 
]  F
 PF ^;u  Pv7F
 P PF P[F P ^P P. P( u  P (p u   P'Fv PXgF uY F PF PF
 PF PF P

 PF ^;r 6 PX
 6 PX  ]ø ]Ë]

  6$P(.PP%  FF;r v6 P P PvRP-PPo%  FP PF ^P^Ɖ4XF^;ue FPF^;r FPv4 ^X  FF;r vvH v4 Xv PXsv4 X6P
 P$]	F P6 Y^P  P6!F P P6
F P P6  F6VF ^;r@   PPF PF PF P6
^;t ]Ív PX  F6VF ^;r@   PPF PF PF P6" 
^;t ]Ív PX]  F
 PF ^;u  PvF
 P PF PF P ^P P+ P$ u  P$p u   P$Fv PXgF uY F PF PF
 PF PF P

 PF ^;r 6 PX
 6 PX  ]ø ]Ë]  F PF ^;r F P PF ^P^ƉƊ ^;t& F P PF ^P^ƉƊD ^;t& F P PF ^P^ƉƊD ^;t0 F P PF ^P^ƉƊD ^;s ] v PX3F P PF ^P^ƉXF P PF ^P^ƉƍtXF P PF ^P^ƉƍtXF
 P PF ^P^ƉƍtXF P PF ^P^ƉƍtX6 PX]ËGtw	VU
 vJF% 1FF0CP3PPP! FV^t؃ ]^Ëܸ 1GVUFtFu v~  v v~ ~D+EtyEȻ YKKy ً3x CC$  CCE
y3 CC1W ^~ FuF  ]^ ^XZ^X3SSy
؃ πRP0CPSVW~ ^Z  ^XZ^X3R3SSP0CPSVWW ^3  ؎W _E
%E%   ]
VW _^D
% DEËEEEE
uE7  E
tm
]]]] E
ueUUU
)]WUFtFu v~Jy vDv~;3SSSSSS  _ǣD
 .   t.  .  CCsCC t֋F-0@FFދF3FF܋!~]_ "
 " " " WUFu v~FuFFF	F} vi[Y3PPPPQSvT5 Q v~;rwNNOO v~FFGG vFFYċF-?)FF1F~Cv~]_ 
܊o	w
y2y:}Ĺ W9Wu
KK$tw$t$t2܉G _ttt4^XZ[YU]MQSRP_D3۹ %uPPP 8PRS3PD%-?=#=|)D- 8yT\ D
3E_Xˎ&
A.  2
UWFVv~
uy	؃ y
ރ S  3SN;wr;w+@N^Yttut؃ FV
_]  v  UF
fF
FfF
FfFV
]  v   v  ûWg؎Ћ& >O3
	 
t5xt/PV ±$'@'N uӱ	9n vn X&^3^. U+;&v^. PF^;r   PvX^PP^ƉƋ4Fu F]økP	 P%PJ]  F FoRvL~TXu v5I~:   FwvXu   ]ËF=  |   ]ËFud F=   F~v, 4Xu Fvv Pvu$Xu 	 Fv4, Xuo  PvYvV^Ɖ/v)Xu7 vV'^ƉF  PvY 	 Fv4, Xuo  PvYvV'^ƉvEXu7 vV^ƉFw} PvY PvNXu# =F5J;v 4XF؉FFu v~
vvF]Ë]FFvjXu# v~- Pv4 ^XF= |z 0 Pv4 ^X. Pv4 ^XvvYF=  | vvY+  F  Pv4 X^;| 0 Pv4 ^Xs v3FF0 Pv4 ^XvvF~v, 4XuFu . Pv4 ^Xv4, XuH vFF0 Pv4 ^Xivv]q~_  PvX PF+F^t3]Ë]Iv ug% Pv ^;t7 F- Pv 4^ ^;Ƹ tHFu
 v 4Xv F0 PF^;u   F* Pv ^;t v
4 ^4XFv 4XE   Fv Pu* 0 Pv4 ^ ^+P
 PvX^^ƉF. Pv ^;Ƹ tHFu v 4X* Pv ^;t v
4 ^4XFv 4XE   Fv Pou* 0 Pv4 ^ ^+P
 PvX^^ƉFl Pv P^;Ƹ tHFu
 v 4Xv P8Fu  FF
Fv4 ^<~DFF
  PvVF޸g Pv ^;t F= | F=   PF^PvVvPvދYv P\PvP\^ƉFܸE Pv4 ^XF=  | - Pv4 ^XF؉F + Pv4 ^Xv޸uPv\P,F썆\FVFu  FF
Fv4 ^~FF
  PvVF޸ PvދF^^PvVwPvދYvFށ P\PvP\^ƉF܍\PF썆\F F F9  F F*  F
 F  F F  FFދFu, F
Fv4 ^t4vXZTPZFF
K F=  |! v
4 ^4XRPvXZTPZ v
4 ^4X3RPvXZTPZvލ\Pvt4\FvF v
4 ^4XFvgFFu F;Fr FF  Fw v
4 XFܸ F  F[ FFܸ F  FF C  c s d D x X u U o O b B f e g ewod\Fu F;Fw Fu - Pv܊^;t 0 PF^;t.  Pv4 vvЃv, 4Xv, 4XvVv4, X^;w  PvVvvЃF;Fw vvY+   FvvvvЃFu Fu) v4, Xu  PvVvvЃv 4X  Pv4 vvЃ]4 F̍v4 ^ Fv4, Xux   Pv̊ ^;t 	 Pv̊ ^;t
   PvX6 A Pv̊ ^;s Z Pv̊ ^;v   Pv̊ Yv́ 4Xw  PvXzF҉FЉFθ F̸ F Pv4 ^ ^ƉFv4, Xu v̊ u  < Pv̊ ^;t
 F́ F< > Pv̊ ^;t
 F́ F FPv4 ^VF^ƉXF= } P	 P
Pv̊ u v́ 4Xv, 4Xv́ 4X+F̸> PvЊ ^;t vЁ 4XF̸ PPvP^;u Pvv6^;u PPv^;u P	 P 
PEPFԉXFPvYăP
]f  F  FF= |, vVP^ƉƋ4u 
 v 4XF= t  P P	FFu  Pv 4X5^#PvtX Pv^; : PF Ɗ^;tF  FF= |5  FF= |@ vV PvX^P^ƉƉ^ƉƊ PvVF^ƉƊP^;t
 v 4XF= t*  PF^#P PvX^P^ƉƊD ^;t  PvtY PvX^P^ƉƊD PvX P PvtX^#^;t3  Pv4^;t  PvtX
  PvtX
  PvtX
 v 4X PvtX5^#uv vPvXu Fu v4V P Pv4V FP ^;  P YPvtXvtPvtXuf PvtvtVFPvVP^ƉX PvtX5^#u	 Fuv4V# P Pv4t#t!XZYdRPvtXZTPZ PvtX^#u vttXZu v4t!, \ t4XZvtV Piv4V! PY  F P YPF^;|1  PvVvt^	DW	XLTS		;Single 128
	DW	XLTD1		;Double 256
	DW	XLTD2		;Double 512
	DW	XLTD3		;Double 1024

XLTS:	DB	0,6,12,18,24,4,10,16,22,2,8,14,20
	DB	1,7,13,19,25,5,11,17,23,3,9,15,21

XLTD1:	DB	0, 1,18,19,36,37, 2, 3,20,21,38,39
	DB	4, 5,22,23,40,41, 6, 7,24,25,42,43
	DB	8, 9,26,27,44,45,10,11,28,29,46,47
	DB	12,13,30,31,48,49,14,15,32,33,50,51
	DB	16,17,34,35

XLTD2:	DB	0, 1, 2, 3,16,17,18,19
	DB	32,33,34,35,48,49,50,51
	DB	4, 5, 6, 7,20,21,22,23
	DB	36,37,38,39,52,53,54,55
	DB	8, 9,10,11,24,25,26,27
	DB	40,41,42,43,56,57,58,59
	DB	12,13,14,15,28,29,30,31
	DB	44,45,46,47

XLTD3:	DB	0, 1, 2, 3, 4, 5, 6, 7
	DB	24,25,26,27,28,29,30,31
	DB	48,49,50,51,52,53,54,55
	DB	8, 9,10,11,12,13,14,15
	DB	32,33,34,35,36,37,38,39
	DB	56,57,58,59,60,61,62,63
	DB	16,17,18,19,20,21,22,23
	DB	40,41,42,43,44,45,46,47

	PAGE
; 	Initialze for DSKMSK
;
DRV1:	SET	0
DRV2:	SET	0
DRV3:	SET	0
DRV4:	SET	0
DRV5:	SET	0
DRV6:	SET	0
DRV7:	SET	0
DRV8:	SET	0
DRV9:	SET	0
DRV10:	SET	0
DRV11:	SET	0
DRV12:	SET	0
DRV13:	SET	0
DRV14:	SET	0
DRV15:	SET	0
DRV16:	SET	0	

;	Control Blocks for disk drives

DPBASE:
	if @ldr <> 0
	if	order = 0
	DPHGEN	1,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive A:
	ENDIF

	if	order = 1
	IF	GBC20
DRVTYP:	SET	3
	DPHGEN	1,DSK8F1,0,DIRBUF,DPBF81+1	;Drive A:
	ENDIF

	IF	GBC10
DRVTYP:	SET	2
	DPHGEN	1,DSK8M1,0,DIRBUF,DPBM81+1	;Drive A:
	ENDIF

	IF	GBC26
DRVTYP:	SET	4
	DPHGEN	1,DSK4S1,0,DIRBUF,DPBS41+1	;Drive A:
	ENDIF

	ENDIF

	else

	if	order = 0

	DPHGEN	1,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive A:

	DPHGEN	2,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive B:

	IF	NOT HARD

	DPHGEN	3,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive C:

	DPHGEN	4,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive D:

	ENDIF

	IF	GBC20
DRVTYP:	SET	3
	DPHGEN	3,DSK8F1,0,DIRBUF,DPBF81+1	;Drive C:

	DPHGEN	4,DSK8F2,0,DIRBUF,DPBF82+1	;Drive D:

	DPHGEN	5,DSK8F3,0,DIRBUF,DPBF83+1	;Drive E:
	ENDIF

	IF	GBC10
DRVTYP:	SET	2
	DPHGEN	3,DSK8M1,0,DIRBUF,DPBM81+1	;Drive C:

	DPHGEN	4,DSK8M2,0,DIRBUF,DPBM82+1	;Drive D:

	ENDIF

	IF	GBC26
DRVTYP:	SET	4	
	DPHGEN	3,DSK4S1,0,DIRBUF,DPBS41+1	;Drive C:

	DPHGEN	4,DSK4S2,0,DIRBUF,DPBS42+1	;Drive D:

	DPHGEN	5,DSK4S3,0,DIRBUF,DPBS43+1	;Drive E:

	DPHGEN	6,DSK4S4,0,DIRBUF,DPBS44+1	;Drive F:
	ENDIF
	ENDIF

	if	order = 1

	IF	GBC20
DRVTYP:	SET	3
	DPHGEN	1,DSK8F1,0,DIRBUF,DPBF81+1	;Drive A:

	DPHGEN	2,DSK8F2,0,DIRBUF,DPBF82+1	;Drive B:

	DPHGEN	3,DSK8F3,0,DIRBUF,DPBF83+1	;Drive C:

	DPHGEN	4,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive D: (GBC20)

	DPHGEN	5,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive E: (GBC20)

	ENDIF

	IF	GBC10
DRVTYP:	SET	2 
	DPHGEN	1,DSK8M1,0,DIRBUF,DPBM81+1	;Drive A:

	DPHGEN	2,DSK8M2,0,DIRBUF,DPBM82+1	;Drive B:

	DPHGEN	3,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive C: (GBC10)

	DPHGEN	4,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive D: (GBC10)


	ENDIF

	IF	GBC26
DRVTYP:	SET	4
	DPHGEN	1,DSK4S1,0,DIRBUF,DPBS41+1	;Drive A:

	DPHGEN	2,DSK4S2,0,DIRBUF,DPBS42+1	;Drive B:

	DPHGEN	3,DSK4S3,0,DIRBUF,DPBS43+1	;Drive C:

	DPHGEN	4,DSK4S4,0,DIRBUF,DPBS44+1	;Drive D:

	DPHGEN	5,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive E: (GBC26)

	DPHGEN	6,DSKS1,XLTS,DIRBUF,DPBS1+1	;Drive F: (GBC26)

	ENDIF

	ENDIF

	endif
	IF	HDRIVE
	DPHGEN	13,HMDTYP,0,DIRBUF,DPBHMD+1	;Drive M: (M-DRIVE/H)
	ENDIF

	space	4,10
;	Disk type definition blocks for each particular mode.

DPBS1:		;Single density, single sided.

	DPBGEN	DSKS1,26,3,7,0,S1DSM,64,1100000000000000b,2


DPBS2:		;Single density, double sided.

	DPBGEN	DSKS2,26,4,15,1,S2DSM,128,1100000000000000b,2*2


DPBD1:		;Double density, single sided.

	;NOTE: EXM should be 1, however changing now would lose
	;      compatiblity with older CompuPro systems. se la vi. 
	DPBGEN	DSKD1,2*26,4,15,0,D1DSM,128,1100000000000000b,2


DPBD2:		;Double density, double sided.

	DPBGEN	DSKD2,2*26,4,15,0,D2DSM,256,1111000000000000b,2*2


DPBD3:		;Double density, single sided.

	DPBGEN	DSKD3,4*15,4,15,0,D3DSM,128,1100000000000000b,2


DPBD4:		;Double density, double sided.

	DPBGEN	DSKD4,4*15,4,15,0,D4DSM,256,1111000000000000b,2*2


DPBD5:		;Double density, single sided.

	DPBGEN	DSKD5,8*8,4,15,0,D5DSM,128,1100000000000000b,2


DPBD6:		;Double density, double sided.

	DPBGEN	DSKD6,8*8,4,15,0,D6DSM,256,1111000000000000b,2*2


	IF	GBC20
DPBF81:		;Fujitsu 20 megabyte first 8 megabytes

	DPBGEN	DSK8F1,8*11,5,31,1,F81DSM,1024,1111111111111111b,1*8

DPBF82:		;Fujitsu 20 megabyte second 8 megabytes

	DPBGEN	DSK8F2,8*11,5,31,1,F82DSM,1024,1111111111111111b,94*8

DPBF83:		;Fujitsu 20 megabyte first 8 megabytes

	DPBGEN	DSK8F3,8*11,5,31,1,F83DSM,1024,1111111111111111b,187*8

	ENDIF

	IF	GBC10
DPBM81:		;Fujitsu 10 megabyte first 5 megabytes

	DPBGEN	DSK8M1,8*11,5,31,1,M81DSM,1024,1111111111111111b,1*4

DPBM82:		;Fujitsu 10 megabyte second 5 megabytes

	DPBGEN	DSK8M2,8*11,5,31,1,M82DSM,1024,1111111111111111b,123*4

	ENDIF

	IF	GBC26
DPBS41:		;Shugart 26 megabyte first 8 megabytes

	DPBGEN	DSK4S1,8*16,5,31,1,S41DSM,1024,1111111111111111b,1*8

DPBS42:		;Shugart 26 megabyte second 8 megabytes

	DPBGEN	DSK4S2,8*16,5,31,1,S42DSM,1024,1111111111111111b,57*8

DPBS43:		;Shugart 26 megabyte third 8 megabytes

	DPBGEN	DSK4S3,8*16,5,31,1,S43DSM,1024,1111111111111111b,113*8

DPBS44:		;Shugart 26 megabyte last 2 megabytes

	DPBGEN	DSK4S4,8*16,5,31,1,S44DSM,1024,1111111111111111b,169*8

	ENDIF
	IF	HDRIVE
DPBHMD:
	DPBGEN 	HMDTYP,8,4,15,1,HMDDSM,128,1100_0000_0000_0000B,4
	ENDIF
	

;	Disk selection masks
DSKMSK:
	DB	DRV1		;Drive	A:
	DB	DRV2		;Drive	B:
	DB	DRV3		;Drive	C:
	DB	DRV4		;Drive	D:
	DB	DRV5		;Drive	E:
	DB	DRV6		;Drive	F:
	DB	DRV7		;Drive	G:
	DB	DRV8		;Drive	H:
	DB	DRV9		;Drive	I:
	DB	DRV10		;Drive	J:
	DB	DRV11		;Drive	K:
	DB	DRV12		;Drive	L:
	DB	DRV13		;Drive	M:
	DB	DRV14		;Drive	N:
	DB	DRV15		;Drive	O:
	DB	DRV16		;Drive	P:

1,5,31,1,M82DSM,1024,1111111111111111b,123*4

	ENDIF

	IF	GBC26
DPBS41:		;Shugart 26 megabyte first 8 megabytes

	DPBGEN	DSK4S1,8*16,5,31,1,S41DSM,1024,1111111111111111b,1*8

DPBS42:		;Shugart 26 megabyte second 8 megabytes

	DPBGEN	DSK4S2,8*16,	PAGE

;	Disk Input / Output port assignments.

FDPORT	EQU	0C0H		;Base port address for Controller
FDCS	EQU	FDPORT		;Status register
FDCD	EQU	FDPORT+1	;Data register
DMA	EQU	FDPORT+2	;Dma address (when write)
INTS	EQU	FDPORT+2	;Status Register (when read)
SER	EQU	FDPORT+3	;Serial port

;	Controller function definitions

F.SPEC	EQU	03		;Specify
F.DSTS	EQU	04		;Drive status
F.WRT	EQU	05		;Write data
F.RDAT	EQU	06		;Read data
F.RECA	EQU	07		;recalibrate
F.RSTS	EQU	08		;Read status
F.DRID	EQU	10		;Read ID
F.SEEK	EQU	15		;Seek


;	Disk drive constants

STEPR:	EQU	8		;Shugart SA 800
SRT:	EQU	16-STEPR	;Controller value
HUT:	EQU	240/16		;Head unload = 240 ms
HLT:	EQU	(35+1)/2	;Head load = 35 ms
ND:	EQU	0B		;Set DMA mode
	SPACE	4,10
;		   7    6    5    4    3    2    1    0
;		+----+----+----+----+----+----+----+----+
;	ST0	|    IC   | SE | EC | NR | HD |    US   |
;		+----+----+----+----+----+----+----+----+
;	ST1	| EN |    | DE | OR |    | ND | NW | MA |
;		+----+----+----+----+----+----+----+----+
;	ST2	|    | CM | DD | WC | SH | SN | BC | MD |
;		+----+----+----+----+----+----+----+----+
;	ST3	| FT | WP | RY | T0 | TS | HD |    US   |
;		+----+----+----+----+----+----+----+----+
;
;	IC - Interrupt code.
;		00 - Normal termination by TC signal.
;		01 - Abnormal termination.
;		10 - Invalid command.
;		11 - Abnormal termination (READY dropped).
;
;	SE - Seek end, indicates end of seek.
;
;	EC - Equipment Check.
;
;	NR - Not ready.
;
;	HD - State of the head select.
;
;	US - State of the unit select.
;
;
;	EN - End of Cylinder, Read EOT sector.
;
;	DE - CRC error in ID or data fields.
;
;	OR - Over run.
;
;	ND - No Data.
;
;	NW - Not writable (write protect detected)
;
;	MA - Missing address mark.
;
;
;	CM - Control Mark (deleted data address mark).
;
;	DD - CRC error in data field.
;
;	WC - Wrong cylinder.
;
;	SH - Scan equal hit.
;
;	SN - Scan not satisfied.
;
;	BC - Bad cylinder.
;
;	MD - Missing data mark.
;
;
;	FT - Fault.
;
;	  @           " 3 D U f w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
NO CORE$      

$      $@      Y@     @    חA 7yACnF?O8M0HwZ۾sOu?yGz?(C6?30yE>ؗҜ<#I9D2F[%nd(
                      ??      $@              $@      $@CON CON RDR PUN PRN 0123456789ABCDEF                  